/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.impl;

import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.base.CommerceCatalogServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.List;

public class CommerceCatalogServiceImpl
extends CommerceCatalogServiceBaseImpl {
    private static volatile ModelResourcePermission<CommerceCatalog> _commerceCatalogModelResourcePermission = ModelResourcePermissionFactory.getInstance(CommerceCatalogServiceImpl.class, (String)"_commerceCatalogModelResourcePermission", CommerceCatalog.class);

    public CommerceCatalog addCommerceCatalog(String externalReferenceCode, String name, String commerceCurrencyCode, String catalogDefaultLanguageId, ServiceContext serviceContext) throws PortalException {
        PortletResourcePermission portletResourcePermission = _commerceCatalogModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "ADD_COMMERCE_CATALOG");
        return this.commerceCatalogLocalService.addCommerceCatalog(externalReferenceCode, name, commerceCurrencyCode, catalogDefaultLanguageId, serviceContext);
    }

    public CommerceCatalog deleteCommerceCatalog(long commerceCatalogId) throws PortalException {
        _commerceCatalogModelResourcePermission.check(this.getPermissionChecker(), commerceCatalogId, "DELETE");
        return this.commerceCatalogLocalService.deleteCommerceCatalog(commerceCatalogId);
    }

    public CommerceCatalog fetchByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        CommerceCatalog commerceCatalog = this.commerceCatalogLocalService.fetchByExternalReferenceCode(externalReferenceCode, companyId);
        if (commerceCatalog != null) {
            _commerceCatalogModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceCatalog, "VIEW");
        }
        return commerceCatalog;
    }

    public CommerceCatalog fetchCommerceCatalog(long commerceCatalogId) throws PortalException {
        CommerceCatalog commerceCatalog = this.commerceCatalogLocalService.fetchCommerceCatalog(commerceCatalogId);
        if (commerceCatalog != null) {
            _commerceCatalogModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceCatalog, "VIEW");
        }
        return commerceCatalog;
    }

    public CommerceCatalog fetchCommerceCatalogByGroupId(long groupId) throws PortalException {
        CommerceCatalog commerceCatalog = this.commerceCatalogLocalService.fetchCommerceCatalogByGroupId(groupId);
        if (commerceCatalog != null) {
            _commerceCatalogModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceCatalog, "VIEW");
        }
        return commerceCatalog;
    }

    public CommerceCatalog getCommerceCatalog(long commerceCatalogId) throws PortalException {
        _commerceCatalogModelResourcePermission.check(this.getPermissionChecker(), commerceCatalogId, "VIEW");
        return this.commerceCatalogLocalService.getCommerceCatalog(commerceCatalogId);
    }

    public List<CommerceCatalog> getCommerceCatalogs(long companyId, int start, int end) {
        return this.commerceCatalogPersistence.filterFindByCompanyId(companyId, start, end);
    }

    public List<CommerceCatalog> searchCommerceCatalogs(long companyId, String keywords, int start, int end, Sort sort) throws PortalException {
        return this.commerceCatalogLocalService.searchCommerceCatalogs(companyId, keywords, start, end, sort);
    }

    public int searchCommerceCatalogsCount(long companyId, String keywords) throws PortalException {
        return this.commerceCatalogLocalService.searchCommerceCatalogsCount(companyId, keywords);
    }

    public CommerceCatalog updateCommerceCatalog(long commerceCatalogId, String name, String commerceCurrencyCode, String catalogDefaultLanguageId) throws PortalException {
        _commerceCatalogModelResourcePermission.check(this.getPermissionChecker(), commerceCatalogId, "UPDATE");
        return this.commerceCatalogLocalService.updateCommerceCatalog(commerceCatalogId, name, commerceCurrencyCode, catalogDefaultLanguageId);
    }

    public CommerceCatalog updateCommerceCatalogExternalReferenceCode(String externalReferenceCode, long commerceCatalogId) throws PortalException {
        _commerceCatalogModelResourcePermission.check(this.getPermissionChecker(), commerceCatalogId, "UPDATE");
        return this.commerceCatalogLocalService.updateCommerceCatalogExternalReferenceCode(externalReferenceCode, commerceCatalogId);
    }
}

