/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.impl;

import com.liferay.commerce.product.exception.DuplicateCommerceChannelSiteGroupIdException;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.base.CommerceChannelLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CommerceChannelLocalServiceImpl
extends CommerceChannelLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId"};

    @Indexable(type=IndexableType.REINDEX)
    public CommerceChannel addCommerceChannel(String externalReferenceCode, long siteGroupId, String name, String type, UnicodeProperties typeSettingsUnicodeProperties, String commerceCurrencyCode, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        long commerceChannelId = this.counterLocalService.increment();
        CommerceChannel commerceChannel = this.commerceChannelPersistence.create(commerceChannelId);
        commerceChannel.setExternalReferenceCode(externalReferenceCode);
        commerceChannel.setCompanyId(user.getCompanyId());
        commerceChannel.setUserId(user.getUserId());
        commerceChannel.setUserName(user.getFullName());
        commerceChannel.setSiteGroupId(siteGroupId);
        commerceChannel.setName(name);
        commerceChannel.setType(type);
        commerceChannel.setTypeSettingsProperties(typeSettingsUnicodeProperties);
        commerceChannel.setCommerceCurrencyCode(commerceCurrencyCode);
        commerceChannel.setPriceDisplayType("tax-excluded");
        commerceChannel.setDiscountsTargetNetPrice(true);
        commerceChannel = (CommerceChannel)this.commerceChannelPersistence.update((BaseModel)commerceChannel);
        Map<Locale, String> nameMap = Collections.singletonMap(serviceContext.getLocale(), name);
        this.groupLocalService.addGroup(user.getUserId(), 0L, CommerceChannel.class.getName(), commerceChannelId, 0L, nameMap, null, 3, false, 0, null, false, true, null);
        this.resourceLocalService.addModelResources((AuditedModel)commerceChannel, serviceContext);
        return commerceChannel;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommerceChannel deleteCommerceChannel(CommerceChannel commerceChannel) throws PortalException {
        this.commerceChannelRelLocalService.deleteCommerceChannelRels(commerceChannel.getCommerceChannelId());
        this.resourceLocalService.deleteResource((AuditedModel)commerceChannel, 4);
        Group group = this.fetchCommerceChannelGroup(commerceChannel.getCommerceChannelId());
        commerceChannel = (CommerceChannel)this.commerceChannelPersistence.remove((BaseModel)commerceChannel);
        if (group != null) {
            this.groupLocalService.deleteGroup(group);
        }
        return commerceChannel;
    }

    @Override
    public CommerceChannel deleteCommerceChannel(long commerceChannelId) throws PortalException {
        CommerceChannel commerceChannel = this.commerceChannelPersistence.findByPrimaryKey(commerceChannelId);
        return this.commerceChannelLocalService.deleteCommerceChannel(commerceChannel);
    }

    public void deleteCommerceChannels(long companyId) throws PortalException {
        List commerceChannels = this.commerceChannelPersistence.findByCompanyId(companyId);
        for (CommerceChannel commerceChannel : commerceChannels) {
            this.commerceChannelLocalService.deleteCommerceChannel(commerceChannel);
        }
    }

    public CommerceChannel fetchByExternalReferenceCode(String externalReferenceCode, long companyId) {
        if (Validator.isBlank((String)externalReferenceCode)) {
            return null;
        }
        return this.commerceChannelPersistence.fetchByC_ERC(companyId, externalReferenceCode);
    }

    public CommerceChannel fetchCommerceChannelBySiteGroupId(long siteGroupId) {
        return this.commerceChannelPersistence.fetchBySiteGroupId(siteGroupId);
    }

    public Group fetchCommerceChannelGroup(long commerceChannelId) throws PortalException {
        CommerceChannel commerceChannel = this.commerceChannelLocalService.getCommerceChannel(commerceChannelId);
        long classNameId = this.classNameLocalService.getClassNameId(CommerceChannel.class.getName());
        return this.groupLocalService.fetchGroup(commerceChannel.getCompanyId(), classNameId, commerceChannelId);
    }

    public CommerceChannel getCommerceChannelByGroupId(long groupId) throws PortalException {
        Group group = this.groupLocalService.getGroup(groupId);
        return this.commerceChannelLocalService.getCommerceChannel(group.getClassPK());
    }

    public CommerceChannel getCommerceChannelByOrderGroupId(long orderGroupId) throws PortalException {
        return this.commerceChannelLocalService.getCommerceChannelByGroupId(orderGroupId);
    }

    public Group getCommerceChannelGroup(long commerceChannelId) throws PortalException {
        Group group = this.commerceChannelLocalService.fetchCommerceChannelGroup(commerceChannelId);
        if (group != null) {
            return group;
        }
        throw new PortalException();
    }

    public long getCommerceChannelGroupIdBySiteGroupId(long siteGroupId) throws PortalException {
        CommerceChannel commerceChannel = this.commerceChannelPersistence.findBySiteGroupId(siteGroupId);
        Group group = this.commerceChannelLocalService.getCommerceChannelGroup(commerceChannel.getCommerceChannelId());
        return group.getGroupId();
    }

    public List<CommerceChannel> getCommerceChannels(long companyId) {
        return this.commerceChannelPersistence.findByCompanyId(companyId);
    }

    public List<CommerceChannel> searchCommerceChannels(long companyId) throws PortalException {
        return this.searchCommerceChannels(companyId, "", -1, -1, null);
    }

    public List<CommerceChannel> searchCommerceChannels(long companyId, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, start, end, sort);
        searchContext.setKeywords(keywords);
        return this.searchCommerceChannels(searchContext);
    }

    public int searchCommerceChannelsCount(long companyId, String keywords) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, -1, -1, null);
        searchContext.setKeywords(keywords);
        return this.searchCommerceChannelsCount(searchContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceChannel updateCommerceChannel(long commerceChannelId, long siteGroupId, String name, String type, UnicodeProperties typeSettingsUnicodeProperties, String commerceCurrencyCode) throws PortalException {
        CommerceChannel commerceChannel = this.commerceChannelPersistence.findByPrimaryKey(commerceChannelId);
        commerceChannel.setSiteGroupId(siteGroupId);
        commerceChannel.setName(name);
        commerceChannel.setType(type);
        commerceChannel.setTypeSettingsProperties(typeSettingsUnicodeProperties);
        commerceChannel.setCommerceCurrencyCode(commerceCurrencyCode);
        return (CommerceChannel)this.commerceChannelPersistence.update((BaseModel)commerceChannel);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceChannel updateCommerceChannel(long commerceChannelId, long siteGroupId, String name, String type, UnicodeProperties typeSettingsUnicodeProperties, String commerceCurrencyCode, String priceDisplayType, boolean discountsTargetNetPrice) throws PortalException {
        CommerceChannel commerceChannel = this.commerceChannelPersistence.findByPrimaryKey(commerceChannelId);
        commerceChannel.setSiteGroupId(siteGroupId);
        commerceChannel.setName(name);
        commerceChannel.setType(type);
        commerceChannel.setTypeSettingsProperties(typeSettingsUnicodeProperties);
        commerceChannel.setCommerceCurrencyCode(commerceCurrencyCode);
        commerceChannel.setPriceDisplayType(priceDisplayType);
        commerceChannel.setDiscountsTargetNetPrice(discountsTargetNetPrice);
        return (CommerceChannel)this.commerceChannelPersistence.update((BaseModel)commerceChannel);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceChannel updateCommerceChannelExternalReferenceCode(String externalReferenceCode, long commerceChannelId) throws PortalException {
        CommerceChannel commerceChannel = this.commerceChannelPersistence.findByPrimaryKey(commerceChannelId);
        commerceChannel.setExternalReferenceCode(externalReferenceCode);
        return (CommerceChannel)this.commerceChannelPersistence.update((BaseModel)commerceChannel);
    }

    protected SearchContext buildSearchContext(long companyId, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected List<CommerceChannel> getCommerceChannels(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommerceChannel> commerceChannels = new ArrayList<CommerceChannel>(documents.size());
        for (Document document : documents) {
            long commerceChannelId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommerceChannel commerceChannel = this.fetchCommerceChannel(commerceChannelId);
            if (commerceChannel == null) {
                commerceChannels = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CommerceChannel.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (commerceChannels == null) continue;
            commerceChannels.add(commerceChannel);
        }
        return commerceChannels;
    }

    protected List<CommerceChannel> searchCommerceChannels(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceChannel.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CommerceChannel> commerceChannels = this.getCommerceChannels(hits);
            if (commerceChannels == null) continue;
            return commerceChannels;
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected int searchCommerceChannelsCount(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceChannel.class);
        return GetterUtil.getInteger((Object)indexer.searchCount(searchContext));
    }

    protected void validate(long siteGroupId) throws PortalException {
        if (this.fetchCommerceChannelBySiteGroupId(siteGroupId) != null) {
            throw new DuplicateCommerceChannelSiteGroupIdException();
        }
    }
}

