/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.impl;

import com.liferay.commerce.product.exception.DuplicateCommerceChannelRelException;
import com.liferay.commerce.product.model.CommerceChannelRel;
import com.liferay.commerce.product.service.base.CommerceChannelRelLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class CommerceChannelRelLocalServiceImpl
extends CommerceChannelRelLocalServiceBaseImpl {
    public CommerceChannelRel addCommerceChannelRel(String className, long classPK, long commerceChannelId, ServiceContext serviceContext) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        CommerceChannelRel existingCommerceChannelRel = this.commerceChannelRelPersistence.fetchByC_C_C(classNameId, classPK, commerceChannelId);
        if (existingCommerceChannelRel != null) {
            throw new DuplicateCommerceChannelRelException();
        }
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long commerceChannelRelId = this.counterLocalService.increment();
        CommerceChannelRel commerceChannelRel = this.commerceChannelRelPersistence.create(commerceChannelRelId);
        commerceChannelRel.setCompanyId(user.getCompanyId());
        commerceChannelRel.setUserId(user.getUserId());
        commerceChannelRel.setUserName(user.getFullName());
        commerceChannelRel.setClassNameId(classNameId);
        commerceChannelRel.setClassPK(classPK);
        commerceChannelRel.setCommerceChannelId(commerceChannelId);
        return (CommerceChannelRel)this.commerceChannelRelPersistence.update((BaseModel)commerceChannelRel);
    }

    public void deleteCommerceChannelRels(long commerceChannelId) {
        this.commerceChannelRelPersistence.removeByCommerceChannelId(commerceChannelId);
    }

    public void deleteCommerceChannelRels(String className, long classPK) {
        this.commerceChannelRelPersistence.removeByC_C(this.classNameLocalService.getClassNameId(className), classPK);
    }

    public CommerceChannelRel fetchCommerceChannelRel(String className, long classPK, long commerceChannelId) {
        return this.commerceChannelRelPersistence.fetchByC_C_C(this.classNameLocalService.getClassNameId(className), classPK, commerceChannelId);
    }

    public List<CommerceChannelRel> getCommerceChannelRels(long commerceChannelId, int start, int end, OrderByComparator<CommerceChannelRel> orderByComparator) {
        return this.commerceChannelRelPersistence.findByCommerceChannelId(commerceChannelId, start, end, orderByComparator);
    }

    public List<CommerceChannelRel> getCommerceChannelRels(String className, long classPK, int start, int end, OrderByComparator<CommerceChannelRel> orderByComparator) {
        return this.commerceChannelRelPersistence.findByC_C(this.classNameLocalService.getClassNameId(className), classPK, start, end, orderByComparator);
    }

    public List<CommerceChannelRel> getCommerceChannelRels(String className, long classPK, String name, int start, int end) {
        return this.commerceChannelRelFinder.findByC_C(className, classPK, name, start, end);
    }

    public int getCommerceChannelRelsCount(long commerceChannelId) {
        return this.commerceChannelRelPersistence.countByCommerceChannelId(commerceChannelId);
    }

    public int getCommerceChannelRelsCount(String className, long classPK) {
        return this.commerceChannelRelPersistence.countByC_C(this.classNameLocalService.getClassNameId(className), classPK);
    }

    public int getCommerceChannelRelsCount(String className, long classPK, String name) {
        return this.commerceChannelRelFinder.countByC_C(className, classPK, name);
    }
}

