/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.impl;

import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.model.CommerceChannelRel;
import com.liferay.commerce.product.service.base.CommerceChannelRelServiceBaseImpl;
import com.liferay.commerce.product.service.impl.CommerceChannelServiceImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class CommerceChannelRelServiceImpl
extends CommerceChannelRelServiceBaseImpl {
    private static volatile ModelResourcePermission<CommerceChannel> _commerceChannelModelResourcePermission = ModelResourcePermissionFactory.getInstance(CommerceChannelServiceImpl.class, (String)"_commerceChannelModelResourcePermission", CommerceChannel.class);

    public CommerceChannelRel addCommerceChannelRel(String className, long classPK, long commerceChannelId, ServiceContext serviceContext) throws PortalException {
        _commerceChannelModelResourcePermission.check(this.getPermissionChecker(), commerceChannelId, "UPDATE");
        return this.commerceChannelRelLocalService.addCommerceChannelRel(className, classPK, commerceChannelId, serviceContext);
    }

    public void deleteCommerceChannelRel(long commerceChannelRelId) throws PortalException {
        CommerceChannelRel commerceChannelRel = this.commerceChannelRelLocalService.getCommerceChannelRel(commerceChannelRelId);
        _commerceChannelModelResourcePermission.check(this.getPermissionChecker(), commerceChannelRel.getCommerceChannelId(), "UPDATE");
        this.commerceChannelRelLocalService.deleteCommerceChannelRel(commerceChannelRelId);
    }

    public void deleteCommerceChannelRels(String className, long classPK) throws PortalException {
        List commerceChannelRels = this.commerceChannelRelLocalService.getCommerceChannelRels(className, classPK, "", -1, -1);
        for (CommerceChannelRel commerceChannelRel : commerceChannelRels) {
            this.commerceChannelRelLocalService.deleteCommerceChannelRel(commerceChannelRel.getCommerceChannelRelId());
        }
    }

    public CommerceChannelRel fetchCommerceChannelRel(String className, long classPK, long commerceChannelId) throws PortalException {
        _commerceChannelModelResourcePermission.check(this.getPermissionChecker(), commerceChannelId, "VIEW");
        return this.commerceChannelRelLocalService.fetchCommerceChannelRel(className, classPK, commerceChannelId);
    }

    public CommerceChannelRel getCommerceChannelRel(long commerceChannelRelId) throws PortalException {
        CommerceChannelRel commerceChannelRel = this.commerceChannelRelLocalService.getCommerceChannelRel(commerceChannelRelId);
        _commerceChannelModelResourcePermission.check(this.getPermissionChecker(), commerceChannelRel.getCommerceChannelId(), "VIEW");
        return this.commerceChannelRelLocalService.getCommerceChannelRel(commerceChannelRelId);
    }

    public List<CommerceChannelRel> getCommerceChannelRels(long commerceChannelId, int start, int end, OrderByComparator<CommerceChannelRel> orderByComparator) throws PortalException {
        _commerceChannelModelResourcePermission.check(this.getPermissionChecker(), commerceChannelId, "VIEW");
        return this.commerceChannelRelLocalService.getCommerceChannelRels(commerceChannelId, start, end, orderByComparator);
    }

    @Deprecated
    public List<CommerceChannelRel> getCommerceChannelRels(String className, long classPK, int start, int end, OrderByComparator<CommerceChannelRel> orderByComparator) {
        return this.commerceChannelRelService.getCommerceChannelRels(className, classPK, null, start, end);
    }

    public List<CommerceChannelRel> getCommerceChannelRels(String className, long classPK, String name, int start, int end) {
        return this.commerceChannelRelFinder.findByC_C(className, classPK, name, start, end, true);
    }

    @Deprecated
    public List<CommerceChannelRel> getCommerceChannelRels(String className, long classPK, String classPKField, String name, int start, int end) {
        throw new UnsupportedOperationException();
    }

    public int getCommerceChannelRelsCount(long commerceChannelId) throws PortalException {
        _commerceChannelModelResourcePermission.check(this.getPermissionChecker(), commerceChannelId, "VIEW");
        return this.commerceChannelRelLocalService.getCommerceChannelRelsCount(commerceChannelId);
    }

    public int getCommerceChannelRelsCount(String className, long classPK) {
        return this.commerceChannelRelService.getCommerceChannelRelsCount(className, classPK, "");
    }

    public int getCommerceChannelRelsCount(String className, long classPK, String name) {
        return this.commerceChannelRelFinder.countByC_C(className, classPK, name, true);
    }

    @Deprecated
    public int getCommerceChannelRelsCount(String className, long classPK, String classPKField, String name) {
        throw new UnsupportedOperationException();
    }
}

