/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.impl;

import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.base.CommerceChannelServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.List;

public class CommerceChannelServiceImpl
extends CommerceChannelServiceBaseImpl {
    private static volatile ModelResourcePermission<CommerceChannel> _commerceChannelModelResourcePermission = ModelResourcePermissionFactory.getInstance(CommerceChannelServiceImpl.class, (String)"_commerceChannelModelResourcePermission", CommerceChannel.class);

    public CommerceChannel addCommerceChannel(String externalReferenceCode, long siteGroupId, String name, String type, UnicodeProperties typeSettingsUnicodeProperties, String commerceCurrencyCode, ServiceContext serviceContext) throws PortalException {
        PortletResourcePermission portletResourcePermission = _commerceChannelModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "ADD_COMMERCE_CHANNEL");
        return this.commerceChannelLocalService.addCommerceChannel(externalReferenceCode, siteGroupId, name, type, typeSettingsUnicodeProperties, commerceCurrencyCode, serviceContext);
    }

    public CommerceChannel deleteCommerceChannel(long commerceChannelId) throws PortalException {
        _commerceChannelModelResourcePermission.check(this.getPermissionChecker(), commerceChannelId, "DELETE");
        return this.commerceChannelLocalService.deleteCommerceChannel(commerceChannelId);
    }

    public CommerceChannel fetchByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        CommerceChannel commerceChannel = this.commerceChannelLocalService.fetchByExternalReferenceCode(externalReferenceCode, companyId);
        if (commerceChannel != null) {
            _commerceChannelModelResourcePermission.check(this.getPermissionChecker(), commerceChannel.getCommerceChannelId(), "VIEW");
        }
        return commerceChannel;
    }

    public CommerceChannel fetchCommerceChannel(long commerceChannelId) throws PortalException {
        CommerceChannel commerceChannel = this.commerceChannelLocalService.fetchCommerceChannel(commerceChannelId);
        if (commerceChannel != null) {
            _commerceChannelModelResourcePermission.check(this.getPermissionChecker(), commerceChannelId, "VIEW");
        }
        return commerceChannel;
    }

    public CommerceChannel getCommerceChannel(long commerceChannelId) throws PortalException {
        _commerceChannelModelResourcePermission.check(this.getPermissionChecker(), commerceChannelId, "VIEW");
        return this.commerceChannelLocalService.getCommerceChannel(commerceChannelId);
    }

    public CommerceChannel getCommerceChannelByOrderGroupId(long groupId) throws PortalException {
        CommerceChannel commerceChannel = this.commerceChannelLocalService.getCommerceChannelByOrderGroupId(groupId);
        _commerceChannelModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceChannel, "VIEW");
        return commerceChannel;
    }

    public List<CommerceChannel> getCommerceChannels(int start, int end) throws PortalException {
        PortletResourcePermission portletResourcePermission = _commerceChannelModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "VIEW_COMMERCE_CHANNELS");
        return this.commerceChannelLocalService.getCommerceChannels(start, end);
    }

    public List<CommerceChannel> getCommerceChannels(long companyId) throws PortalException {
        PortletResourcePermission portletResourcePermission = _commerceChannelModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "VIEW_COMMERCE_CHANNELS");
        return this.commerceChannelLocalService.getCommerceChannels(companyId);
    }

    public List<CommerceChannel> searchCommerceChannels(long companyId) throws PortalException {
        return this.commerceChannelLocalService.searchCommerceChannels(companyId);
    }

    public List<CommerceChannel> searchCommerceChannels(long companyId, String keywords, int start, int end, Sort sort) throws PortalException {
        PortletResourcePermission portletResourcePermission = _commerceChannelModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "VIEW_COMMERCE_CHANNELS");
        return this.commerceChannelLocalService.searchCommerceChannels(companyId, keywords, start, end, sort);
    }

    public int searchCommerceChannelsCount(long companyId, String keywords) throws PortalException {
        PortletResourcePermission portletResourcePermission = _commerceChannelModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "VIEW_COMMERCE_CHANNELS");
        return this.commerceChannelLocalService.searchCommerceChannelsCount(companyId, keywords);
    }

    public CommerceChannel updateCommerceChannel(long commerceChannelId, long siteGroupId, String name, String type, UnicodeProperties typeSettingsUnicodeProperties, String commerceCurrencyCode) throws PortalException {
        _commerceChannelModelResourcePermission.check(this.getPermissionChecker(), commerceChannelId, "UPDATE");
        return this.commerceChannelLocalService.updateCommerceChannel(commerceChannelId, siteGroupId, name, type, typeSettingsUnicodeProperties, commerceCurrencyCode);
    }

    public CommerceChannel updateCommerceChannel(long commerceChannelId, long siteGroupId, String name, String type, UnicodeProperties typeSettingsUnicodeProperties, String commerceCurrencyCode, String priceDisplayType, boolean discountsTargetNetPrice) throws PortalException {
        _commerceChannelModelResourcePermission.check(this.getPermissionChecker(), commerceChannelId, "UPDATE");
        return this.commerceChannelLocalService.updateCommerceChannel(commerceChannelId, siteGroupId, name, type, typeSettingsUnicodeProperties, commerceCurrencyCode, priceDisplayType, discountsTargetNetPrice);
    }

    public CommerceChannel updateCommerceChannelExternalReferenceCode(String externalReferenceCode, long commerceChannelId) throws PortalException {
        _commerceChannelModelResourcePermission.check(this.getPermissionChecker(), commerceChannelId, "UPDATE");
        return this.commerceChannelLocalService.updateCommerceChannelExternalReferenceCode(externalReferenceCode, commerceChannelId);
    }
}

