/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.persistence.impl;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.impl.CPDefinitionImpl;
import com.liferay.commerce.product.service.persistence.CPDefinitionFinder;
import com.liferay.commerce.product.service.persistence.impl.CPDefinitionFinderBaseImpl;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class CPDefinitionFinderImpl
extends CPDefinitionFinderBaseImpl
implements CPDefinitionFinder {
    public static final String COUNT_BY_G_P_S = CPDefinitionFinder.class.getName() + ".countByG_P_S";
    public static final String FIND_BY_EXPIRATION_DATE = CPDefinitionFinder.class.getName() + ".findByExpirationDate";
    public static final String FIND_BY_G_P_S = CPDefinitionFinder.class.getName() + ".findByG_P_S";
    @ServiceReference(type=CustomSQL.class)
    private CustomSQL _customSQL;

    public int countByG_P_S(long groupId, String productTypeName, String languageId, QueryDefinition<CPDefinition> queryDefinition) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_G_P_S, queryDefinition, "CPDefinition");
            if (groupId <= 0L) {
                sql = StringUtil.removeSubstring((String)sql, (String)"(CPDefinition.groupId = ?) AND");
            }
            if (Validator.isNull((String)productTypeName)) {
                sql = StringUtil.removeSubstring((String)sql, (String)"(CPDefinition.productTypeName = ?) AND");
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(languageId);
            if (groupId > 0L) {
                queryPos.add(groupId);
            }
            if (Validator.isNotNull((String)productTypeName)) {
                queryPos.add(productTypeName);
            }
            queryPos.add(queryDefinition.getStatus());
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CPDefinition> findByExpirationDate(Date expirationDate, QueryDefinition<CPDefinition> queryDefinition) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_EXPIRATION_DATE, queryDefinition, "CPDefinition");
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("CPDefinition", CPDefinitionImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            if (expirationDate != null) {
                queryPos.add(expirationDate);
            }
            queryPos.add(queryDefinition.getStatus());
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CPDefinition> findByG_P_S(long groupId, String productTypeName, String languageId, QueryDefinition<CPDefinition> queryDefinition) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_G_P_S, queryDefinition, "CPDefinition");
            sql = this._customSQL.replaceOrderBy(sql, queryDefinition.getOrderByComparator());
            if (groupId <= 0L) {
                sql = StringUtil.removeSubstring((String)sql, (String)"(CPDefinition.groupId = ?) AND");
            }
            if (Validator.isNull((String)productTypeName)) {
                sql = StringUtil.removeSubstring((String)sql, (String)"(CPDefinition.productTypeName = ?) AND");
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("CPDefinition", CPDefinitionImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(languageId);
            if (groupId > 0L) {
                queryPos.add(groupId);
            }
            if (Validator.isNotNull((String)productTypeName)) {
                queryPos.add(productTypeName);
            }
            queryPos.add(queryDefinition.getStatus());
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }
}

