/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.persistence.impl;

import com.liferay.commerce.product.exception.NoSuchCPTaxCategoryException;
import com.liferay.commerce.product.model.CPTaxCategory;
import com.liferay.commerce.product.model.CPTaxCategoryTable;
import com.liferay.commerce.product.model.impl.CPTaxCategoryImpl;
import com.liferay.commerce.product.model.impl.CPTaxCategoryModelImpl;
import com.liferay.commerce.product.service.persistence.CPTaxCategoryPersistence;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

public class CPTaxCategoryPersistenceImpl
extends BasePersistenceImpl<CPTaxCategory>
implements CPTaxCategoryPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CPTaxCategoryImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "cpTaxCategory.companyId = ?";
    private FinderPath _finderPathFetchByC_ERC;
    private FinderPath _finderPathCountByC_ERC;
    private static final String _FINDER_COLUMN_C_ERC_COMPANYID_2 = "cpTaxCategory.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_2 = "cpTaxCategory.externalReferenceCode = ?";
    private static final String _FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_3 = "(cpTaxCategory.externalReferenceCode IS NULL OR cpTaxCategory.externalReferenceCode = '')";
    private BundleContext _bundleContext;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_CPTAXCATEGORY = "SELECT cpTaxCategory FROM CPTaxCategory cpTaxCategory";
    private static final String _SQL_SELECT_CPTAXCATEGORY_WHERE = "SELECT cpTaxCategory FROM CPTaxCategory cpTaxCategory WHERE ";
    private static final String _SQL_COUNT_CPTAXCATEGORY = "SELECT COUNT(cpTaxCategory) FROM CPTaxCategory cpTaxCategory";
    private static final String _SQL_COUNT_CPTAXCATEGORY_WHERE = "SELECT COUNT(cpTaxCategory) FROM CPTaxCategory cpTaxCategory WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "cpTaxCategory.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No CPTaxCategory exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No CPTaxCategory exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(CPTaxCategoryPersistenceImpl.class);
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public List<CPTaxCategory> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<CPTaxCategory> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<CPTaxCategory> findByCompanyId(long companyId, int start, int end, OrderByComparator<CPTaxCategory> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<CPTaxCategory> findByCompanyId(long companyId, int start, int end, OrderByComparator<CPTaxCategory> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCompanyId;
                finderArgs = new Object[]{companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (CPTaxCategory cpTaxCategory : list) {
                if (companyId == cpTaxCategory.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_CPTAXCATEGORY_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY cpTaxCategory.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CPTaxCategory findByCompanyId_First(long companyId, OrderByComparator<CPTaxCategory> orderByComparator) throws NoSuchCPTaxCategoryException {
        CPTaxCategory cpTaxCategory = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (cpTaxCategory != null) {
            return cpTaxCategory;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchCPTaxCategoryException(sb.toString());
    }

    public CPTaxCategory fetchByCompanyId_First(long companyId, OrderByComparator<CPTaxCategory> orderByComparator) {
        List<CPTaxCategory> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CPTaxCategory findByCompanyId_Last(long companyId, OrderByComparator<CPTaxCategory> orderByComparator) throws NoSuchCPTaxCategoryException {
        CPTaxCategory cpTaxCategory = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (cpTaxCategory != null) {
            return cpTaxCategory;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchCPTaxCategoryException(sb.toString());
    }

    public CPTaxCategory fetchByCompanyId_Last(long companyId, OrderByComparator<CPTaxCategory> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<CPTaxCategory> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CPTaxCategory[] findByCompanyId_PrevAndNext(long CPTaxCategoryId, long companyId, OrderByComparator<CPTaxCategory> orderByComparator) throws NoSuchCPTaxCategoryException {
        CPTaxCategory cpTaxCategory = this.findByPrimaryKey(CPTaxCategoryId);
        Session session = null;
        try {
            session = this.openSession();
            CPTaxCategory[] array = new CPTaxCategoryImpl[]{this.getByCompanyId_PrevAndNext(session, cpTaxCategory, companyId, orderByComparator, true), cpTaxCategory, this.getByCompanyId_PrevAndNext(session, cpTaxCategory, companyId, orderByComparator, false)};
            CPTaxCategory[] cPTaxCategoryArray = array;
            return cPTaxCategoryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CPTaxCategory getByCompanyId_PrevAndNext(Session session, CPTaxCategory cpTaxCategory, long companyId, OrderByComparator<CPTaxCategory> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_CPTAXCATEGORY_WHERE);
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY cpTaxCategory.createDate DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)cpTaxCategory)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CPTaxCategory)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (CPTaxCategory cpTaxCategory : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)cpTaxCategory);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_CPTAXCATEGORY_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CPTaxCategory findByC_ERC(long companyId, String externalReferenceCode) throws NoSuchCPTaxCategoryException {
        CPTaxCategory cpTaxCategory = this.fetchByC_ERC(companyId, externalReferenceCode);
        if (cpTaxCategory == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("companyId=");
            sb.append(companyId);
            sb.append(", externalReferenceCode=");
            sb.append(externalReferenceCode);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchCPTaxCategoryException(sb.toString());
        }
        return cpTaxCategory;
    }

    public CPTaxCategory fetchByC_ERC(long companyId, String externalReferenceCode) {
        return this.fetchByC_ERC(companyId, externalReferenceCode, true);
    }

    public CPTaxCategory fetchByC_ERC(long companyId, String externalReferenceCode, boolean useFinderCache) {
        CPTaxCategory cpTaxCategory;
        externalReferenceCode = Objects.toString(externalReferenceCode, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{companyId, externalReferenceCode};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByC_ERC, finderArgs);
        }
        if (result instanceof CPTaxCategory && (companyId != (cpTaxCategory = (CPTaxCategory)result).getCompanyId() || !Objects.equals(externalReferenceCode, cpTaxCategory.getExternalReferenceCode()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_CPTAXCATEGORY_WHERE);
            sb.append(_FINDER_COLUMN_C_ERC_COMPANYID_2);
            boolean bindExternalReferenceCode = false;
            if (externalReferenceCode.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_3);
            } else {
                bindExternalReferenceCode = true;
                sb.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindExternalReferenceCode) {
                    queryPos.add(externalReferenceCode);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByC_ERC, finderArgs, (Object)list);
                    }
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            if (!useFinderCache) {
                                finderArgs = new Object[]{companyId, externalReferenceCode};
                            }
                            _log.warn((Object)("CPTaxCategoryPersistenceImpl.fetchByC_ERC(long, String, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    CPTaxCategory cpTaxCategory2 = (CPTaxCategory)list.get(0);
                    result = cpTaxCategory2;
                    this.cacheResult(cpTaxCategory2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (CPTaxCategory)result;
    }

    public CPTaxCategory removeByC_ERC(long companyId, String externalReferenceCode) throws NoSuchCPTaxCategoryException {
        CPTaxCategory cpTaxCategory = this.findByC_ERC(companyId, externalReferenceCode);
        return (CPTaxCategory)this.remove((BaseModel)cpTaxCategory);
    }

    public int countByC_ERC(long companyId, String externalReferenceCode) {
        externalReferenceCode = Objects.toString(externalReferenceCode, "");
        FinderPath finderPath = this._finderPathCountByC_ERC;
        Object[] finderArgs = new Object[]{companyId, externalReferenceCode};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_CPTAXCATEGORY_WHERE);
            sb.append(_FINDER_COLUMN_C_ERC_COMPANYID_2);
            boolean bindExternalReferenceCode = false;
            if (externalReferenceCode.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_3);
            } else {
                bindExternalReferenceCode = true;
                sb.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindExternalReferenceCode) {
                    queryPos.add(externalReferenceCode);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CPTaxCategoryPersistenceImpl() {
        this.setModelClass(CPTaxCategory.class);
        this.setModelImplClass(CPTaxCategoryImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)CPTaxCategoryTable.INSTANCE);
    }

    public void cacheResult(CPTaxCategory cpTaxCategory) {
        this.entityCache.putResult(CPTaxCategoryImpl.class, (Serializable)Long.valueOf(cpTaxCategory.getPrimaryKey()), (Serializable)cpTaxCategory);
        this.finderCache.putResult(this._finderPathFetchByC_ERC, new Object[]{cpTaxCategory.getCompanyId(), cpTaxCategory.getExternalReferenceCode()}, (Object)cpTaxCategory);
    }

    public void cacheResult(List<CPTaxCategory> cpTaxCategories) {
        for (CPTaxCategory cpTaxCategory : cpTaxCategories) {
            if (this.entityCache.getResult(CPTaxCategoryImpl.class, (Serializable)Long.valueOf(cpTaxCategory.getPrimaryKey())) != null) continue;
            this.cacheResult(cpTaxCategory);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(CPTaxCategoryImpl.class);
        this.finderCache.clearCache(CPTaxCategoryImpl.class);
    }

    public void clearCache(CPTaxCategory cpTaxCategory) {
        this.entityCache.removeResult(CPTaxCategoryImpl.class, (BaseModel)cpTaxCategory);
    }

    public void clearCache(List<CPTaxCategory> cpTaxCategories) {
        for (CPTaxCategory cpTaxCategory : cpTaxCategories) {
            this.entityCache.removeResult(CPTaxCategoryImpl.class, (BaseModel)cpTaxCategory);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(CPTaxCategoryImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(CPTaxCategoryImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(CPTaxCategoryModelImpl cpTaxCategoryModelImpl) {
        Object[] args = new Object[]{cpTaxCategoryModelImpl.getCompanyId(), cpTaxCategoryModelImpl.getExternalReferenceCode()};
        this.finderCache.putResult(this._finderPathCountByC_ERC, args, (Object)1L);
        this.finderCache.putResult(this._finderPathFetchByC_ERC, args, (Object)cpTaxCategoryModelImpl);
    }

    public CPTaxCategory create(long CPTaxCategoryId) {
        CPTaxCategoryImpl cpTaxCategory = new CPTaxCategoryImpl();
        cpTaxCategory.setNew(true);
        cpTaxCategory.setPrimaryKey(CPTaxCategoryId);
        cpTaxCategory.setCompanyId(CompanyThreadLocal.getCompanyId());
        return cpTaxCategory;
    }

    public CPTaxCategory remove(long CPTaxCategoryId) throws NoSuchCPTaxCategoryException {
        return this.remove(Long.valueOf(CPTaxCategoryId));
    }

    public CPTaxCategory remove(Serializable primaryKey) throws NoSuchCPTaxCategoryException {
        Session session = null;
        try {
            session = this.openSession();
            CPTaxCategory cpTaxCategory = (CPTaxCategory)session.get(CPTaxCategoryImpl.class, primaryKey);
            if (cpTaxCategory == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchCPTaxCategoryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            CPTaxCategory cPTaxCategory = (CPTaxCategory)this.remove((BaseModel)cpTaxCategory);
            return cPTaxCategory;
        }
        catch (NoSuchCPTaxCategoryException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CPTaxCategory removeImpl(CPTaxCategory cpTaxCategory) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)cpTaxCategory)) {
                cpTaxCategory = (CPTaxCategory)session.get(CPTaxCategoryImpl.class, cpTaxCategory.getPrimaryKeyObj());
            }
            if (cpTaxCategory != null) {
                session.delete((Object)cpTaxCategory);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (cpTaxCategory != null) {
            this.clearCache(cpTaxCategory);
        }
        return cpTaxCategory;
    }

    public CPTaxCategory updateImpl(CPTaxCategory cpTaxCategory) {
        boolean isNew = cpTaxCategory.isNew();
        if (!(cpTaxCategory instanceof CPTaxCategoryModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(cpTaxCategory.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)cpTaxCategory);
                throw new IllegalArgumentException("Implement ModelWrapper in cpTaxCategory proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom CPTaxCategory implementation " + cpTaxCategory.getClass());
        }
        CPTaxCategoryModelImpl cpTaxCategoryModelImpl = (CPTaxCategoryModelImpl)cpTaxCategory;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && cpTaxCategory.getCreateDate() == null) {
            if (serviceContext == null) {
                cpTaxCategory.setCreateDate(date);
            } else {
                cpTaxCategory.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!cpTaxCategoryModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                cpTaxCategory.setModifiedDate(date);
            } else {
                cpTaxCategory.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)cpTaxCategory);
            } else {
                cpTaxCategory = (CPTaxCategory)session.merge((Object)cpTaxCategory);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(CPTaxCategoryImpl.class, (BaseModel)cpTaxCategoryModelImpl, false, true);
        this.cacheUniqueFindersCache(cpTaxCategoryModelImpl);
        if (isNew) {
            cpTaxCategory.setNew(false);
        }
        cpTaxCategory.resetOriginalValues();
        return cpTaxCategory;
    }

    public CPTaxCategory findByPrimaryKey(Serializable primaryKey) throws NoSuchCPTaxCategoryException {
        CPTaxCategory cpTaxCategory = (CPTaxCategory)this.fetchByPrimaryKey(primaryKey);
        if (cpTaxCategory == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchCPTaxCategoryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return cpTaxCategory;
    }

    public CPTaxCategory findByPrimaryKey(long CPTaxCategoryId) throws NoSuchCPTaxCategoryException {
        return this.findByPrimaryKey(Long.valueOf(CPTaxCategoryId));
    }

    public CPTaxCategory fetchByPrimaryKey(long CPTaxCategoryId) {
        return (CPTaxCategory)this.fetchByPrimaryKey(Long.valueOf(CPTaxCategoryId));
    }

    public List<CPTaxCategory> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<CPTaxCategory> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<CPTaxCategory> findAll(int start, int end, OrderByComparator<CPTaxCategory> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<CPTaxCategory> findAll(int start, int end, OrderByComparator<CPTaxCategory> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_CPTAXCATEGORY);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_CPTAXCATEGORY;
                sql = sql.concat(" ORDER BY cpTaxCategory.createDate DESC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (CPTaxCategory cpTaxCategory : this.findAll()) {
            this.remove((BaseModel)cpTaxCategory);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_CPTAXCATEGORY);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "CPTaxCategoryId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_CPTAXCATEGORY;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return CPTaxCategoryModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        Bundle bundle = FrameworkUtil.getBundle(CPTaxCategoryPersistenceImpl.class);
        this._bundleContext = bundle.getBundleContext();
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new CPTaxCategoryModelArgumentsResolver(), (Dictionary)new HashMapDictionary());
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathWithoutPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathCountByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, false);
        this._finderPathFetchByC_ERC = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByC_ERC", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "externalReferenceCode"}, true);
        this._finderPathCountByC_ERC = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_ERC", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "externalReferenceCode"}, false);
    }

    public void destroy() {
        this.entityCache.removeCache(CPTaxCategoryImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }

    private static class CPTaxCategoryModelArgumentsResolver
    implements ArgumentsResolver {
        private static final Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();
        private static final long _ORDER_BY_COLUMNS_BITMASK;

        private CPTaxCategoryModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return FINDER_ARGS_EMPTY;
                }
                return null;
            }
            CPTaxCategoryModelImpl cpTaxCategoryModelImpl = (CPTaxCategoryModelImpl)baseModel;
            long columnBitmask = cpTaxCategoryModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return CPTaxCategoryModelArgumentsResolver._getValue(cpTaxCategoryModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | CPTaxCategoryModelImpl.getColumnBitmask(columnName);
                }
                if (finderPath.isBaseModelResult() && FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION == finderPath.getCacheName()) {
                    finderPathColumnBitmask = finderPathColumnBitmask | _ORDER_BY_COLUMNS_BITMASK;
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return CPTaxCategoryModelArgumentsResolver._getValue(cpTaxCategoryModelImpl, columnNames, original);
            }
            return null;
        }

        public String getClassName() {
            return CPTaxCategoryImpl.class.getName();
        }

        public String getTableName() {
            return CPTaxCategoryTable.INSTANCE.getTableName();
        }

        private static Object[] _getValue(CPTaxCategoryModelImpl cpTaxCategoryModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? cpTaxCategoryModelImpl.getColumnOriginalValue(columnName) : cpTaxCategoryModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }

        static {
            long orderByColumnsBitmask = 0L;
            _ORDER_BY_COLUMNS_BITMASK = orderByColumnsBitmask |= CPTaxCategoryModelImpl.getColumnBitmask("createDate");
        }
    }
}

