/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.persistence.impl;

import com.liferay.commerce.product.exception.NoSuchCatalogException;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.model.CommerceCatalogTable;
import com.liferay.commerce.product.model.impl.CommerceCatalogImpl;
import com.liferay.commerce.product.model.impl.CommerceCatalogModelImpl;
import com.liferay.commerce.product.service.persistence.CommerceCatalogPersistence;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

public class CommerceCatalogPersistenceImpl
extends BasePersistenceImpl<CommerceCatalog>
implements CommerceCatalogPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CommerceCatalogImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "commerceCatalog.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByC_S;
    private FinderPath _finderPathWithoutPaginationFindByC_S;
    private FinderPath _finderPathCountByC_S;
    private static final String _FINDER_COLUMN_C_S_COMPANYID_2 = "commerceCatalog.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_S_SYSTEM_2 = "commerceCatalog.system = ?";
    private static final String _FINDER_COLUMN_C_S_SYSTEM_2_SQL = "commerceCatalog.system_ = ?";
    private FinderPath _finderPathFetchByC_ERC;
    private FinderPath _finderPathCountByC_ERC;
    private static final String _FINDER_COLUMN_C_ERC_COMPANYID_2 = "commerceCatalog.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_2 = "commerceCatalog.externalReferenceCode = ?";
    private static final String _FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_3 = "(commerceCatalog.externalReferenceCode IS NULL OR commerceCatalog.externalReferenceCode = '')";
    private BundleContext _bundleContext;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_COMMERCECATALOG = "SELECT commerceCatalog FROM CommerceCatalog commerceCatalog";
    private static final String _SQL_SELECT_COMMERCECATALOG_WHERE = "SELECT commerceCatalog FROM CommerceCatalog commerceCatalog WHERE ";
    private static final String _SQL_COUNT_COMMERCECATALOG = "SELECT COUNT(commerceCatalog) FROM CommerceCatalog commerceCatalog";
    private static final String _SQL_COUNT_COMMERCECATALOG_WHERE = "SELECT COUNT(commerceCatalog) FROM CommerceCatalog commerceCatalog WHERE ";
    private static final String _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN = "commerceCatalog.commerceCatalogId";
    private static final String _FILTER_SQL_SELECT_COMMERCECATALOG_WHERE = "SELECT DISTINCT {commerceCatalog.*} FROM CommerceCatalog commerceCatalog WHERE ";
    private static final String _FILTER_SQL_SELECT_COMMERCECATALOG_NO_INLINE_DISTINCT_WHERE_1 = "SELECT {CommerceCatalog.*} FROM (SELECT DISTINCT commerceCatalog.commerceCatalogId FROM CommerceCatalog commerceCatalog WHERE ";
    private static final String _FILTER_SQL_SELECT_COMMERCECATALOG_NO_INLINE_DISTINCT_WHERE_2 = ") TEMP_TABLE INNER JOIN CommerceCatalog ON TEMP_TABLE.commerceCatalogId = CommerceCatalog.commerceCatalogId";
    private static final String _FILTER_SQL_COUNT_COMMERCECATALOG_WHERE = "SELECT COUNT(DISTINCT commerceCatalog.commerceCatalogId) AS COUNT_VALUE FROM CommerceCatalog commerceCatalog WHERE ";
    private static final String _FILTER_ENTITY_ALIAS = "commerceCatalog";
    private static final String _FILTER_ENTITY_TABLE = "CommerceCatalog";
    private static final String _ORDER_BY_ENTITY_ALIAS = "commerceCatalog.";
    private static final String _ORDER_BY_ENTITY_TABLE = "CommerceCatalog.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No CommerceCatalog exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No CommerceCatalog exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(CommerceCatalogPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"system"});
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public List<CommerceCatalog> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<CommerceCatalog> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<CommerceCatalog> findByCompanyId(long companyId, int start, int end, OrderByComparator<CommerceCatalog> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<CommerceCatalog> findByCompanyId(long companyId, int start, int end, OrderByComparator<CommerceCatalog> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCompanyId;
                finderArgs = new Object[]{companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (CommerceCatalog commerceCatalog : list) {
                if (companyId == commerceCatalog.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_COMMERCECATALOG_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceCatalog.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceCatalog findByCompanyId_First(long companyId, OrderByComparator<CommerceCatalog> orderByComparator) throws NoSuchCatalogException {
        CommerceCatalog commerceCatalog = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (commerceCatalog != null) {
            return commerceCatalog;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchCatalogException(sb.toString());
    }

    public CommerceCatalog fetchByCompanyId_First(long companyId, OrderByComparator<CommerceCatalog> orderByComparator) {
        List<CommerceCatalog> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceCatalog findByCompanyId_Last(long companyId, OrderByComparator<CommerceCatalog> orderByComparator) throws NoSuchCatalogException {
        CommerceCatalog commerceCatalog = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (commerceCatalog != null) {
            return commerceCatalog;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchCatalogException(sb.toString());
    }

    public CommerceCatalog fetchByCompanyId_Last(long companyId, OrderByComparator<CommerceCatalog> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<CommerceCatalog> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceCatalog[] findByCompanyId_PrevAndNext(long commerceCatalogId, long companyId, OrderByComparator<CommerceCatalog> orderByComparator) throws NoSuchCatalogException {
        CommerceCatalog commerceCatalog = this.findByPrimaryKey(commerceCatalogId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceCatalog[] array = new CommerceCatalogImpl[]{this.getByCompanyId_PrevAndNext(session, commerceCatalog, companyId, orderByComparator, true), commerceCatalog, this.getByCompanyId_PrevAndNext(session, commerceCatalog, companyId, orderByComparator, false)};
            CommerceCatalog[] commerceCatalogArray = array;
            return commerceCatalogArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceCatalog getByCompanyId_PrevAndNext(Session session, CommerceCatalog commerceCatalog, long companyId, OrderByComparator<CommerceCatalog> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_COMMERCECATALOG_WHERE);
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceCatalog.createDate DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceCatalog)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceCatalog)list.get(1);
        }
        return null;
    }

    public List<CommerceCatalog> filterFindByCompanyId(long companyId) {
        return this.filterFindByCompanyId(companyId, -1, -1, null);
    }

    public List<CommerceCatalog> filterFindByCompanyId(long companyId, int start, int end) {
        return this.filterFindByCompanyId(companyId, start, end, null);
    }

    public List<CommerceCatalog> filterFindByCompanyId(long companyId, int start, int end, OrderByComparator<CommerceCatalog> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.findByCompanyId(companyId, start, end, orderByComparator);
        }
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCECATALOG_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_COMMERCECATALOG_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCECATALOG_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY commerceCatalog.createDate DESC");
        } else {
            sb.append(" ORDER BY CommerceCatalog.createDate DESC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CommerceCatalog.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, CommerceCatalogImpl.class);
            } else {
                sqlQuery.addEntity(_FILTER_ENTITY_TABLE, CommerceCatalogImpl.class);
            }
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public CommerceCatalog[] filterFindByCompanyId_PrevAndNext(long commerceCatalogId, long companyId, OrderByComparator<CommerceCatalog> orderByComparator) throws NoSuchCatalogException {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.findByCompanyId_PrevAndNext(commerceCatalogId, companyId, orderByComparator);
        }
        CommerceCatalog commerceCatalog = this.findByPrimaryKey(commerceCatalogId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceCatalog[] array = new CommerceCatalogImpl[]{this.filterGetByCompanyId_PrevAndNext(session, commerceCatalog, companyId, orderByComparator, true), commerceCatalog, this.filterGetByCompanyId_PrevAndNext(session, commerceCatalog, companyId, orderByComparator, false)};
            CommerceCatalog[] commerceCatalogArray = array;
            return commerceCatalogArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceCatalog filterGetByCompanyId_PrevAndNext(Session session, CommerceCatalog commerceCatalog, long companyId, OrderByComparator<CommerceCatalog> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCECATALOG_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_COMMERCECATALOG_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCECATALOG_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY commerceCatalog.createDate DESC");
        } else {
            sb.append(" ORDER BY CommerceCatalog.createDate DESC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CommerceCatalog.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
        sqlQuery.setFirstResult(0);
        sqlQuery.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, CommerceCatalogImpl.class);
        } else {
            sqlQuery.addEntity(_FILTER_ENTITY_TABLE, CommerceCatalogImpl.class);
        }
        QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceCatalog)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = sqlQuery.list()).size() == 2) {
            return (CommerceCatalog)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (CommerceCatalog commerceCatalog : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)commerceCatalog);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_COMMERCECATALOG_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByCompanyId(long companyId) {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.countByCompanyId(companyId);
        }
        StringBundler sb = new StringBundler(2);
        sb.append(_FILTER_SQL_COUNT_COMMERCECATALOG_WHERE);
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CommerceCatalog.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            Long count = (Long)sqlQuery.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CommerceCatalog> findByC_S(long companyId, boolean system) {
        return this.findByC_S(companyId, system, -1, -1, null);
    }

    public List<CommerceCatalog> findByC_S(long companyId, boolean system, int start, int end) {
        return this.findByC_S(companyId, system, start, end, null);
    }

    public List<CommerceCatalog> findByC_S(long companyId, boolean system, int start, int end, OrderByComparator<CommerceCatalog> orderByComparator) {
        return this.findByC_S(companyId, system, start, end, orderByComparator, true);
    }

    public List<CommerceCatalog> findByC_S(long companyId, boolean system, int start, int end, OrderByComparator<CommerceCatalog> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_S;
                finderArgs = new Object[]{companyId, system};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_S;
            finderArgs = new Object[]{companyId, system, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (CommerceCatalog commerceCatalog : list) {
                if (companyId == commerceCatalog.getCompanyId() && system == commerceCatalog.isSystem()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCECATALOG_WHERE);
            sb.append("commerceCatalog.companyId = ? AND ");
            sb.append(_FINDER_COLUMN_C_S_SYSTEM_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceCatalog.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(system);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceCatalog findByC_S_First(long companyId, boolean system, OrderByComparator<CommerceCatalog> orderByComparator) throws NoSuchCatalogException {
        CommerceCatalog commerceCatalog = this.fetchByC_S_First(companyId, system, orderByComparator);
        if (commerceCatalog != null) {
            return commerceCatalog;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", system=");
        sb.append(system);
        sb.append("}");
        throw new NoSuchCatalogException(sb.toString());
    }

    public CommerceCatalog fetchByC_S_First(long companyId, boolean system, OrderByComparator<CommerceCatalog> orderByComparator) {
        List<CommerceCatalog> list = this.findByC_S(companyId, system, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceCatalog findByC_S_Last(long companyId, boolean system, OrderByComparator<CommerceCatalog> orderByComparator) throws NoSuchCatalogException {
        CommerceCatalog commerceCatalog = this.fetchByC_S_Last(companyId, system, orderByComparator);
        if (commerceCatalog != null) {
            return commerceCatalog;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", system=");
        sb.append(system);
        sb.append("}");
        throw new NoSuchCatalogException(sb.toString());
    }

    public CommerceCatalog fetchByC_S_Last(long companyId, boolean system, OrderByComparator<CommerceCatalog> orderByComparator) {
        int count = this.countByC_S(companyId, system);
        if (count == 0) {
            return null;
        }
        List<CommerceCatalog> list = this.findByC_S(companyId, system, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceCatalog[] findByC_S_PrevAndNext(long commerceCatalogId, long companyId, boolean system, OrderByComparator<CommerceCatalog> orderByComparator) throws NoSuchCatalogException {
        CommerceCatalog commerceCatalog = this.findByPrimaryKey(commerceCatalogId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceCatalog[] array = new CommerceCatalogImpl[]{this.getByC_S_PrevAndNext(session, commerceCatalog, companyId, system, orderByComparator, true), commerceCatalog, this.getByC_S_PrevAndNext(session, commerceCatalog, companyId, system, orderByComparator, false)};
            CommerceCatalog[] commerceCatalogArray = array;
            return commerceCatalogArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceCatalog getByC_S_PrevAndNext(Session session, CommerceCatalog commerceCatalog, long companyId, boolean system, OrderByComparator<CommerceCatalog> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_COMMERCECATALOG_WHERE);
        sb.append("commerceCatalog.companyId = ? AND ");
        sb.append(_FINDER_COLUMN_C_S_SYSTEM_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceCatalog.createDate DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        queryPos.add(system);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceCatalog)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceCatalog)list.get(1);
        }
        return null;
    }

    public List<CommerceCatalog> filterFindByC_S(long companyId, boolean system) {
        return this.filterFindByC_S(companyId, system, -1, -1, null);
    }

    public List<CommerceCatalog> filterFindByC_S(long companyId, boolean system, int start, int end) {
        return this.filterFindByC_S(companyId, system, start, end, null);
    }

    public List<CommerceCatalog> filterFindByC_S(long companyId, boolean system, int start, int end, OrderByComparator<CommerceCatalog> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.findByC_S(companyId, system, start, end, orderByComparator);
        }
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCECATALOG_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_COMMERCECATALOG_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append("commerceCatalog.companyId = ? AND ");
        sb.append(_FINDER_COLUMN_C_S_SYSTEM_2_SQL);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCECATALOG_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY commerceCatalog.createDate DESC");
        } else {
            sb.append(" ORDER BY CommerceCatalog.createDate DESC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CommerceCatalog.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, CommerceCatalogImpl.class);
            } else {
                sqlQuery.addEntity(_FILTER_ENTITY_TABLE, CommerceCatalogImpl.class);
            }
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            queryPos.add(system);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public CommerceCatalog[] filterFindByC_S_PrevAndNext(long commerceCatalogId, long companyId, boolean system, OrderByComparator<CommerceCatalog> orderByComparator) throws NoSuchCatalogException {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.findByC_S_PrevAndNext(commerceCatalogId, companyId, system, orderByComparator);
        }
        CommerceCatalog commerceCatalog = this.findByPrimaryKey(commerceCatalogId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceCatalog[] array = new CommerceCatalogImpl[]{this.filterGetByC_S_PrevAndNext(session, commerceCatalog, companyId, system, orderByComparator, true), commerceCatalog, this.filterGetByC_S_PrevAndNext(session, commerceCatalog, companyId, system, orderByComparator, false)};
            CommerceCatalog[] commerceCatalogArray = array;
            return commerceCatalogArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceCatalog filterGetByC_S_PrevAndNext(Session session, CommerceCatalog commerceCatalog, long companyId, boolean system, OrderByComparator<CommerceCatalog> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCECATALOG_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_COMMERCECATALOG_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append("commerceCatalog.companyId = ? AND ");
        sb.append(_FINDER_COLUMN_C_S_SYSTEM_2_SQL);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCECATALOG_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY commerceCatalog.createDate DESC");
        } else {
            sb.append(" ORDER BY CommerceCatalog.createDate DESC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CommerceCatalog.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
        sqlQuery.setFirstResult(0);
        sqlQuery.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, CommerceCatalogImpl.class);
        } else {
            sqlQuery.addEntity(_FILTER_ENTITY_TABLE, CommerceCatalogImpl.class);
        }
        QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
        queryPos.add(companyId);
        queryPos.add(system);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceCatalog)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = sqlQuery.list()).size() == 2) {
            return (CommerceCatalog)list.get(1);
        }
        return null;
    }

    public void removeByC_S(long companyId, boolean system) {
        for (CommerceCatalog commerceCatalog : this.findByC_S(companyId, system, -1, -1, null)) {
            this.remove((BaseModel)commerceCatalog);
        }
    }

    public int countByC_S(long companyId, boolean system) {
        FinderPath finderPath = this._finderPathCountByC_S;
        Object[] finderArgs = new Object[]{companyId, system};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCECATALOG_WHERE);
            sb.append("commerceCatalog.companyId = ? AND ");
            sb.append(_FINDER_COLUMN_C_S_SYSTEM_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(system);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByC_S(long companyId, boolean system) {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.countByC_S(companyId, system);
        }
        StringBundler sb = new StringBundler(3);
        sb.append(_FILTER_SQL_COUNT_COMMERCECATALOG_WHERE);
        sb.append("commerceCatalog.companyId = ? AND ");
        sb.append(_FINDER_COLUMN_C_S_SYSTEM_2_SQL);
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CommerceCatalog.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            queryPos.add(system);
            Long count = (Long)sqlQuery.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public CommerceCatalog findByC_ERC(long companyId, String externalReferenceCode) throws NoSuchCatalogException {
        CommerceCatalog commerceCatalog = this.fetchByC_ERC(companyId, externalReferenceCode);
        if (commerceCatalog == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("companyId=");
            sb.append(companyId);
            sb.append(", externalReferenceCode=");
            sb.append(externalReferenceCode);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchCatalogException(sb.toString());
        }
        return commerceCatalog;
    }

    public CommerceCatalog fetchByC_ERC(long companyId, String externalReferenceCode) {
        return this.fetchByC_ERC(companyId, externalReferenceCode, true);
    }

    public CommerceCatalog fetchByC_ERC(long companyId, String externalReferenceCode, boolean useFinderCache) {
        CommerceCatalog commerceCatalog;
        externalReferenceCode = Objects.toString(externalReferenceCode, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{companyId, externalReferenceCode};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByC_ERC, finderArgs);
        }
        if (result instanceof CommerceCatalog && (companyId != (commerceCatalog = (CommerceCatalog)result).getCompanyId() || !Objects.equals(externalReferenceCode, commerceCatalog.getExternalReferenceCode()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCECATALOG_WHERE);
            sb.append("commerceCatalog.companyId = ? AND ");
            boolean bindExternalReferenceCode = false;
            if (externalReferenceCode.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_3);
            } else {
                bindExternalReferenceCode = true;
                sb.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindExternalReferenceCode) {
                    queryPos.add(externalReferenceCode);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByC_ERC, finderArgs, (Object)list);
                    }
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            if (!useFinderCache) {
                                finderArgs = new Object[]{companyId, externalReferenceCode};
                            }
                            _log.warn((Object)("CommerceCatalogPersistenceImpl.fetchByC_ERC(long, String, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    CommerceCatalog commerceCatalog2 = (CommerceCatalog)list.get(0);
                    result = commerceCatalog2;
                    this.cacheResult(commerceCatalog2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (CommerceCatalog)result;
    }

    public CommerceCatalog removeByC_ERC(long companyId, String externalReferenceCode) throws NoSuchCatalogException {
        CommerceCatalog commerceCatalog = this.findByC_ERC(companyId, externalReferenceCode);
        return (CommerceCatalog)this.remove((BaseModel)commerceCatalog);
    }

    public int countByC_ERC(long companyId, String externalReferenceCode) {
        externalReferenceCode = Objects.toString(externalReferenceCode, "");
        FinderPath finderPath = this._finderPathCountByC_ERC;
        Object[] finderArgs = new Object[]{companyId, externalReferenceCode};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCECATALOG_WHERE);
            sb.append("commerceCatalog.companyId = ? AND ");
            boolean bindExternalReferenceCode = false;
            if (externalReferenceCode.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_3);
            } else {
                bindExternalReferenceCode = true;
                sb.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindExternalReferenceCode) {
                    queryPos.add(externalReferenceCode);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommerceCatalogPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("system", "system_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(CommerceCatalog.class);
        this.setModelImplClass(CommerceCatalogImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)CommerceCatalogTable.INSTANCE);
    }

    public void cacheResult(CommerceCatalog commerceCatalog) {
        this.entityCache.putResult(CommerceCatalogImpl.class, (Serializable)Long.valueOf(commerceCatalog.getPrimaryKey()), (Serializable)commerceCatalog);
        this.finderCache.putResult(this._finderPathFetchByC_ERC, new Object[]{commerceCatalog.getCompanyId(), commerceCatalog.getExternalReferenceCode()}, (Object)commerceCatalog);
    }

    public void cacheResult(List<CommerceCatalog> commerceCatalogs) {
        for (CommerceCatalog commerceCatalog : commerceCatalogs) {
            if (this.entityCache.getResult(CommerceCatalogImpl.class, (Serializable)Long.valueOf(commerceCatalog.getPrimaryKey())) != null) continue;
            this.cacheResult(commerceCatalog);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(CommerceCatalogImpl.class);
        this.finderCache.clearCache(CommerceCatalogImpl.class);
    }

    public void clearCache(CommerceCatalog commerceCatalog) {
        this.entityCache.removeResult(CommerceCatalogImpl.class, (BaseModel)commerceCatalog);
    }

    public void clearCache(List<CommerceCatalog> commerceCatalogs) {
        for (CommerceCatalog commerceCatalog : commerceCatalogs) {
            this.entityCache.removeResult(CommerceCatalogImpl.class, (BaseModel)commerceCatalog);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(CommerceCatalogImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(CommerceCatalogImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(CommerceCatalogModelImpl commerceCatalogModelImpl) {
        Object[] args = new Object[]{commerceCatalogModelImpl.getCompanyId(), commerceCatalogModelImpl.getExternalReferenceCode()};
        this.finderCache.putResult(this._finderPathCountByC_ERC, args, (Object)1L);
        this.finderCache.putResult(this._finderPathFetchByC_ERC, args, (Object)commerceCatalogModelImpl);
    }

    public CommerceCatalog create(long commerceCatalogId) {
        CommerceCatalogImpl commerceCatalog = new CommerceCatalogImpl();
        commerceCatalog.setNew(true);
        commerceCatalog.setPrimaryKey(commerceCatalogId);
        commerceCatalog.setCompanyId(CompanyThreadLocal.getCompanyId());
        return commerceCatalog;
    }

    public CommerceCatalog remove(long commerceCatalogId) throws NoSuchCatalogException {
        return this.remove(Long.valueOf(commerceCatalogId));
    }

    public CommerceCatalog remove(Serializable primaryKey) throws NoSuchCatalogException {
        Session session = null;
        try {
            session = this.openSession();
            CommerceCatalog commerceCatalog = (CommerceCatalog)session.get(CommerceCatalogImpl.class, primaryKey);
            if (commerceCatalog == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchCatalogException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            CommerceCatalog commerceCatalog2 = (CommerceCatalog)this.remove((BaseModel)commerceCatalog);
            return commerceCatalog2;
        }
        catch (NoSuchCatalogException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceCatalog removeImpl(CommerceCatalog commerceCatalog) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)commerceCatalog)) {
                commerceCatalog = (CommerceCatalog)session.get(CommerceCatalogImpl.class, commerceCatalog.getPrimaryKeyObj());
            }
            if (commerceCatalog != null) {
                session.delete((Object)commerceCatalog);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (commerceCatalog != null) {
            this.clearCache(commerceCatalog);
        }
        return commerceCatalog;
    }

    public CommerceCatalog updateImpl(CommerceCatalog commerceCatalog) {
        boolean isNew = commerceCatalog.isNew();
        if (!(commerceCatalog instanceof CommerceCatalogModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(commerceCatalog.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)commerceCatalog);
                throw new IllegalArgumentException("Implement ModelWrapper in commerceCatalog proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom CommerceCatalog implementation " + commerceCatalog.getClass());
        }
        CommerceCatalogModelImpl commerceCatalogModelImpl = (CommerceCatalogModelImpl)commerceCatalog;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && commerceCatalog.getCreateDate() == null) {
            if (serviceContext == null) {
                commerceCatalog.setCreateDate(date);
            } else {
                commerceCatalog.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!commerceCatalogModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                commerceCatalog.setModifiedDate(date);
            } else {
                commerceCatalog.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)commerceCatalog);
            } else {
                commerceCatalog = (CommerceCatalog)session.merge((Object)commerceCatalog);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(CommerceCatalogImpl.class, (BaseModel)commerceCatalogModelImpl, false, true);
        this.cacheUniqueFindersCache(commerceCatalogModelImpl);
        if (isNew) {
            commerceCatalog.setNew(false);
        }
        commerceCatalog.resetOriginalValues();
        return commerceCatalog;
    }

    public CommerceCatalog findByPrimaryKey(Serializable primaryKey) throws NoSuchCatalogException {
        CommerceCatalog commerceCatalog = (CommerceCatalog)this.fetchByPrimaryKey(primaryKey);
        if (commerceCatalog == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchCatalogException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return commerceCatalog;
    }

    public CommerceCatalog findByPrimaryKey(long commerceCatalogId) throws NoSuchCatalogException {
        return this.findByPrimaryKey(Long.valueOf(commerceCatalogId));
    }

    public CommerceCatalog fetchByPrimaryKey(long commerceCatalogId) {
        return (CommerceCatalog)this.fetchByPrimaryKey(Long.valueOf(commerceCatalogId));
    }

    public List<CommerceCatalog> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<CommerceCatalog> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<CommerceCatalog> findAll(int start, int end, OrderByComparator<CommerceCatalog> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<CommerceCatalog> findAll(int start, int end, OrderByComparator<CommerceCatalog> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_COMMERCECATALOG);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_COMMERCECATALOG;
                sql = sql.concat(" ORDER BY commerceCatalog.createDate DESC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (CommerceCatalog commerceCatalog : this.findAll()) {
            this.remove((BaseModel)commerceCatalog);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_COMMERCECATALOG);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "commerceCatalogId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_COMMERCECATALOG;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return CommerceCatalogModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        Bundle bundle = FrameworkUtil.getBundle(CommerceCatalogPersistenceImpl.class);
        this._bundleContext = bundle.getBundleContext();
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new CommerceCatalogModelArgumentsResolver(), (Dictionary)new HashMapDictionary());
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathWithoutPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathCountByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, false);
        this._finderPathWithPaginationFindByC_S = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_S", new String[]{Long.class.getName(), Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "system_"}, true);
        this._finderPathWithoutPaginationFindByC_S = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_S", new String[]{Long.class.getName(), Boolean.class.getName()}, new String[]{"companyId", "system_"}, true);
        this._finderPathCountByC_S = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_S", new String[]{Long.class.getName(), Boolean.class.getName()}, new String[]{"companyId", "system_"}, false);
        this._finderPathFetchByC_ERC = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByC_ERC", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "externalReferenceCode"}, true);
        this._finderPathCountByC_ERC = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_ERC", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "externalReferenceCode"}, false);
    }

    public void destroy() {
        this.entityCache.removeCache(CommerceCatalogImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }

    private static class CommerceCatalogModelArgumentsResolver
    implements ArgumentsResolver {
        private static final Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();
        private static final long _ORDER_BY_COLUMNS_BITMASK;

        private CommerceCatalogModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return FINDER_ARGS_EMPTY;
                }
                return null;
            }
            CommerceCatalogModelImpl commerceCatalogModelImpl = (CommerceCatalogModelImpl)baseModel;
            long columnBitmask = commerceCatalogModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return CommerceCatalogModelArgumentsResolver._getValue(commerceCatalogModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | CommerceCatalogModelImpl.getColumnBitmask(columnName);
                }
                if (finderPath.isBaseModelResult() && FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION == finderPath.getCacheName()) {
                    finderPathColumnBitmask = finderPathColumnBitmask | _ORDER_BY_COLUMNS_BITMASK;
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return CommerceCatalogModelArgumentsResolver._getValue(commerceCatalogModelImpl, columnNames, original);
            }
            return null;
        }

        public String getClassName() {
            return CommerceCatalogImpl.class.getName();
        }

        public String getTableName() {
            return CommerceCatalogTable.INSTANCE.getTableName();
        }

        private static Object[] _getValue(CommerceCatalogModelImpl commerceCatalogModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? commerceCatalogModelImpl.getColumnOriginalValue(columnName) : commerceCatalogModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }

        static {
            long orderByColumnsBitmask = 0L;
            _ORDER_BY_COLUMNS_BITMASK = orderByColumnsBitmask |= CommerceCatalogModelImpl.getColumnBitmask("createDate");
        }
    }
}

