/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.persistence.impl;

import com.liferay.commerce.product.exception.NoSuchChannelException;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.model.CommerceChannelTable;
import com.liferay.commerce.product.model.impl.CommerceChannelImpl;
import com.liferay.commerce.product.model.impl.CommerceChannelModelImpl;
import com.liferay.commerce.product.service.persistence.CommerceChannelPersistence;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

public class CommerceChannelPersistenceImpl
extends BasePersistenceImpl<CommerceChannel>
implements CommerceChannelPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CommerceChannelImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "commerceChannel.companyId = ?";
    private FinderPath _finderPathFetchBySiteGroupId;
    private FinderPath _finderPathCountBySiteGroupId;
    private static final String _FINDER_COLUMN_SITEGROUPID_SITEGROUPID_2 = "commerceChannel.siteGroupId = ?";
    private FinderPath _finderPathFetchByC_ERC;
    private FinderPath _finderPathCountByC_ERC;
    private static final String _FINDER_COLUMN_C_ERC_COMPANYID_2 = "commerceChannel.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_2 = "commerceChannel.externalReferenceCode = ?";
    private static final String _FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_3 = "(commerceChannel.externalReferenceCode IS NULL OR commerceChannel.externalReferenceCode = '')";
    private BundleContext _bundleContext;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_COMMERCECHANNEL = "SELECT commerceChannel FROM CommerceChannel commerceChannel";
    private static final String _SQL_SELECT_COMMERCECHANNEL_WHERE = "SELECT commerceChannel FROM CommerceChannel commerceChannel WHERE ";
    private static final String _SQL_COUNT_COMMERCECHANNEL = "SELECT COUNT(commerceChannel) FROM CommerceChannel commerceChannel";
    private static final String _SQL_COUNT_COMMERCECHANNEL_WHERE = "SELECT COUNT(commerceChannel) FROM CommerceChannel commerceChannel WHERE ";
    private static final String _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN = "commerceChannel.commerceChannelId";
    private static final String _FILTER_SQL_SELECT_COMMERCECHANNEL_WHERE = "SELECT DISTINCT {commerceChannel.*} FROM CommerceChannel commerceChannel WHERE ";
    private static final String _FILTER_SQL_SELECT_COMMERCECHANNEL_NO_INLINE_DISTINCT_WHERE_1 = "SELECT {CommerceChannel.*} FROM (SELECT DISTINCT commerceChannel.commerceChannelId FROM CommerceChannel commerceChannel WHERE ";
    private static final String _FILTER_SQL_SELECT_COMMERCECHANNEL_NO_INLINE_DISTINCT_WHERE_2 = ") TEMP_TABLE INNER JOIN CommerceChannel ON TEMP_TABLE.commerceChannelId = CommerceChannel.commerceChannelId";
    private static final String _FILTER_SQL_COUNT_COMMERCECHANNEL_WHERE = "SELECT COUNT(DISTINCT commerceChannel.commerceChannelId) AS COUNT_VALUE FROM CommerceChannel commerceChannel WHERE ";
    private static final String _FILTER_ENTITY_ALIAS = "commerceChannel";
    private static final String _FILTER_ENTITY_TABLE = "CommerceChannel";
    private static final String _ORDER_BY_ENTITY_ALIAS = "commerceChannel.";
    private static final String _ORDER_BY_ENTITY_TABLE = "CommerceChannel.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No CommerceChannel exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No CommerceChannel exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(CommerceChannelPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"type"});
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public List<CommerceChannel> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<CommerceChannel> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<CommerceChannel> findByCompanyId(long companyId, int start, int end, OrderByComparator<CommerceChannel> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<CommerceChannel> findByCompanyId(long companyId, int start, int end, OrderByComparator<CommerceChannel> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCompanyId;
                finderArgs = new Object[]{companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (CommerceChannel commerceChannel : list) {
                if (companyId == commerceChannel.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_COMMERCECHANNEL_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceChannel.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceChannel findByCompanyId_First(long companyId, OrderByComparator<CommerceChannel> orderByComparator) throws NoSuchChannelException {
        CommerceChannel commerceChannel = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (commerceChannel != null) {
            return commerceChannel;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchChannelException(sb.toString());
    }

    public CommerceChannel fetchByCompanyId_First(long companyId, OrderByComparator<CommerceChannel> orderByComparator) {
        List<CommerceChannel> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceChannel findByCompanyId_Last(long companyId, OrderByComparator<CommerceChannel> orderByComparator) throws NoSuchChannelException {
        CommerceChannel commerceChannel = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (commerceChannel != null) {
            return commerceChannel;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchChannelException(sb.toString());
    }

    public CommerceChannel fetchByCompanyId_Last(long companyId, OrderByComparator<CommerceChannel> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<CommerceChannel> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceChannel[] findByCompanyId_PrevAndNext(long commerceChannelId, long companyId, OrderByComparator<CommerceChannel> orderByComparator) throws NoSuchChannelException {
        CommerceChannel commerceChannel = this.findByPrimaryKey(commerceChannelId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceChannel[] array = new CommerceChannelImpl[]{this.getByCompanyId_PrevAndNext(session, commerceChannel, companyId, orderByComparator, true), commerceChannel, this.getByCompanyId_PrevAndNext(session, commerceChannel, companyId, orderByComparator, false)};
            CommerceChannel[] commerceChannelArray = array;
            return commerceChannelArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceChannel getByCompanyId_PrevAndNext(Session session, CommerceChannel commerceChannel, long companyId, OrderByComparator<CommerceChannel> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_COMMERCECHANNEL_WHERE);
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceChannel.createDate DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceChannel)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceChannel)list.get(1);
        }
        return null;
    }

    public List<CommerceChannel> filterFindByCompanyId(long companyId) {
        return this.filterFindByCompanyId(companyId, -1, -1, null);
    }

    public List<CommerceChannel> filterFindByCompanyId(long companyId, int start, int end) {
        return this.filterFindByCompanyId(companyId, start, end, null);
    }

    public List<CommerceChannel> filterFindByCompanyId(long companyId, int start, int end, OrderByComparator<CommerceChannel> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.findByCompanyId(companyId, start, end, orderByComparator);
        }
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCECHANNEL_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_COMMERCECHANNEL_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCECHANNEL_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY commerceChannel.createDate DESC");
        } else {
            sb.append(" ORDER BY CommerceChannel.createDate DESC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CommerceChannel.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, CommerceChannelImpl.class);
            } else {
                sqlQuery.addEntity(_FILTER_ENTITY_TABLE, CommerceChannelImpl.class);
            }
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public CommerceChannel[] filterFindByCompanyId_PrevAndNext(long commerceChannelId, long companyId, OrderByComparator<CommerceChannel> orderByComparator) throws NoSuchChannelException {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.findByCompanyId_PrevAndNext(commerceChannelId, companyId, orderByComparator);
        }
        CommerceChannel commerceChannel = this.findByPrimaryKey(commerceChannelId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceChannel[] array = new CommerceChannelImpl[]{this.filterGetByCompanyId_PrevAndNext(session, commerceChannel, companyId, orderByComparator, true), commerceChannel, this.filterGetByCompanyId_PrevAndNext(session, commerceChannel, companyId, orderByComparator, false)};
            CommerceChannel[] commerceChannelArray = array;
            return commerceChannelArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceChannel filterGetByCompanyId_PrevAndNext(Session session, CommerceChannel commerceChannel, long companyId, OrderByComparator<CommerceChannel> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCECHANNEL_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_COMMERCECHANNEL_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCECHANNEL_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY commerceChannel.createDate DESC");
        } else {
            sb.append(" ORDER BY CommerceChannel.createDate DESC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CommerceChannel.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
        sqlQuery.setFirstResult(0);
        sqlQuery.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, CommerceChannelImpl.class);
        } else {
            sqlQuery.addEntity(_FILTER_ENTITY_TABLE, CommerceChannelImpl.class);
        }
        QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceChannel)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = sqlQuery.list()).size() == 2) {
            return (CommerceChannel)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (CommerceChannel commerceChannel : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)commerceChannel);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_COMMERCECHANNEL_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByCompanyId(long companyId) {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.countByCompanyId(companyId);
        }
        StringBundler sb = new StringBundler(2);
        sb.append(_FILTER_SQL_COUNT_COMMERCECHANNEL_WHERE);
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CommerceChannel.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            Long count = (Long)sqlQuery.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public CommerceChannel findBySiteGroupId(long siteGroupId) throws NoSuchChannelException {
        CommerceChannel commerceChannel = this.fetchBySiteGroupId(siteGroupId);
        if (commerceChannel == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("siteGroupId=");
            sb.append(siteGroupId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchChannelException(sb.toString());
        }
        return commerceChannel;
    }

    public CommerceChannel fetchBySiteGroupId(long siteGroupId) {
        return this.fetchBySiteGroupId(siteGroupId, true);
    }

    public CommerceChannel fetchBySiteGroupId(long siteGroupId, boolean useFinderCache) {
        CommerceChannel commerceChannel;
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{siteGroupId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchBySiteGroupId, finderArgs);
        }
        if (result instanceof CommerceChannel && siteGroupId != (commerceChannel = (CommerceChannel)result).getSiteGroupId()) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_SELECT_COMMERCECHANNEL_WHERE);
            sb.append(_FINDER_COLUMN_SITEGROUPID_SITEGROUPID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(siteGroupId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchBySiteGroupId, finderArgs, (Object)list);
                    }
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            if (!useFinderCache) {
                                finderArgs = new Object[]{siteGroupId};
                            }
                            _log.warn((Object)("CommerceChannelPersistenceImpl.fetchBySiteGroupId(long, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    CommerceChannel commerceChannel2 = (CommerceChannel)list.get(0);
                    result = commerceChannel2;
                    this.cacheResult(commerceChannel2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (CommerceChannel)result;
    }

    public CommerceChannel removeBySiteGroupId(long siteGroupId) throws NoSuchChannelException {
        CommerceChannel commerceChannel = this.findBySiteGroupId(siteGroupId);
        return (CommerceChannel)this.remove((BaseModel)commerceChannel);
    }

    public int countBySiteGroupId(long siteGroupId) {
        FinderPath finderPath = this._finderPathCountBySiteGroupId;
        Object[] finderArgs = new Object[]{siteGroupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_COMMERCECHANNEL_WHERE);
            sb.append(_FINDER_COLUMN_SITEGROUPID_SITEGROUPID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(siteGroupId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommerceChannel findByC_ERC(long companyId, String externalReferenceCode) throws NoSuchChannelException {
        CommerceChannel commerceChannel = this.fetchByC_ERC(companyId, externalReferenceCode);
        if (commerceChannel == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("companyId=");
            sb.append(companyId);
            sb.append(", externalReferenceCode=");
            sb.append(externalReferenceCode);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchChannelException(sb.toString());
        }
        return commerceChannel;
    }

    public CommerceChannel fetchByC_ERC(long companyId, String externalReferenceCode) {
        return this.fetchByC_ERC(companyId, externalReferenceCode, true);
    }

    public CommerceChannel fetchByC_ERC(long companyId, String externalReferenceCode, boolean useFinderCache) {
        CommerceChannel commerceChannel;
        externalReferenceCode = Objects.toString(externalReferenceCode, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{companyId, externalReferenceCode};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByC_ERC, finderArgs);
        }
        if (result instanceof CommerceChannel && (companyId != (commerceChannel = (CommerceChannel)result).getCompanyId() || !Objects.equals(externalReferenceCode, commerceChannel.getExternalReferenceCode()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCECHANNEL_WHERE);
            sb.append(_FINDER_COLUMN_C_ERC_COMPANYID_2);
            boolean bindExternalReferenceCode = false;
            if (externalReferenceCode.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_3);
            } else {
                bindExternalReferenceCode = true;
                sb.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindExternalReferenceCode) {
                    queryPos.add(externalReferenceCode);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByC_ERC, finderArgs, (Object)list);
                    }
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            if (!useFinderCache) {
                                finderArgs = new Object[]{companyId, externalReferenceCode};
                            }
                            _log.warn((Object)("CommerceChannelPersistenceImpl.fetchByC_ERC(long, String, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    CommerceChannel commerceChannel2 = (CommerceChannel)list.get(0);
                    result = commerceChannel2;
                    this.cacheResult(commerceChannel2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (CommerceChannel)result;
    }

    public CommerceChannel removeByC_ERC(long companyId, String externalReferenceCode) throws NoSuchChannelException {
        CommerceChannel commerceChannel = this.findByC_ERC(companyId, externalReferenceCode);
        return (CommerceChannel)this.remove((BaseModel)commerceChannel);
    }

    public int countByC_ERC(long companyId, String externalReferenceCode) {
        externalReferenceCode = Objects.toString(externalReferenceCode, "");
        FinderPath finderPath = this._finderPathCountByC_ERC;
        Object[] finderArgs = new Object[]{companyId, externalReferenceCode};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCECHANNEL_WHERE);
            sb.append(_FINDER_COLUMN_C_ERC_COMPANYID_2);
            boolean bindExternalReferenceCode = false;
            if (externalReferenceCode.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_3);
            } else {
                bindExternalReferenceCode = true;
                sb.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindExternalReferenceCode) {
                    queryPos.add(externalReferenceCode);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommerceChannelPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("type", "type_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(CommerceChannel.class);
        this.setModelImplClass(CommerceChannelImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)CommerceChannelTable.INSTANCE);
    }

    public void cacheResult(CommerceChannel commerceChannel) {
        this.entityCache.putResult(CommerceChannelImpl.class, (Serializable)Long.valueOf(commerceChannel.getPrimaryKey()), (Serializable)commerceChannel);
        this.finderCache.putResult(this._finderPathFetchBySiteGroupId, new Object[]{commerceChannel.getSiteGroupId()}, (Object)commerceChannel);
        this.finderCache.putResult(this._finderPathFetchByC_ERC, new Object[]{commerceChannel.getCompanyId(), commerceChannel.getExternalReferenceCode()}, (Object)commerceChannel);
    }

    public void cacheResult(List<CommerceChannel> commerceChannels) {
        for (CommerceChannel commerceChannel : commerceChannels) {
            if (this.entityCache.getResult(CommerceChannelImpl.class, (Serializable)Long.valueOf(commerceChannel.getPrimaryKey())) != null) continue;
            this.cacheResult(commerceChannel);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(CommerceChannelImpl.class);
        this.finderCache.clearCache(CommerceChannelImpl.class);
    }

    public void clearCache(CommerceChannel commerceChannel) {
        this.entityCache.removeResult(CommerceChannelImpl.class, (BaseModel)commerceChannel);
    }

    public void clearCache(List<CommerceChannel> commerceChannels) {
        for (CommerceChannel commerceChannel : commerceChannels) {
            this.entityCache.removeResult(CommerceChannelImpl.class, (BaseModel)commerceChannel);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(CommerceChannelImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(CommerceChannelImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(CommerceChannelModelImpl commerceChannelModelImpl) {
        Object[] args = new Object[]{commerceChannelModelImpl.getSiteGroupId()};
        this.finderCache.putResult(this._finderPathCountBySiteGroupId, args, (Object)1L);
        this.finderCache.putResult(this._finderPathFetchBySiteGroupId, args, (Object)commerceChannelModelImpl);
        args = new Object[]{commerceChannelModelImpl.getCompanyId(), commerceChannelModelImpl.getExternalReferenceCode()};
        this.finderCache.putResult(this._finderPathCountByC_ERC, args, (Object)1L);
        this.finderCache.putResult(this._finderPathFetchByC_ERC, args, (Object)commerceChannelModelImpl);
    }

    public CommerceChannel create(long commerceChannelId) {
        CommerceChannelImpl commerceChannel = new CommerceChannelImpl();
        commerceChannel.setNew(true);
        commerceChannel.setPrimaryKey(commerceChannelId);
        commerceChannel.setCompanyId(CompanyThreadLocal.getCompanyId());
        return commerceChannel;
    }

    public CommerceChannel remove(long commerceChannelId) throws NoSuchChannelException {
        return this.remove(Long.valueOf(commerceChannelId));
    }

    public CommerceChannel remove(Serializable primaryKey) throws NoSuchChannelException {
        Session session = null;
        try {
            session = this.openSession();
            CommerceChannel commerceChannel = (CommerceChannel)session.get(CommerceChannelImpl.class, primaryKey);
            if (commerceChannel == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchChannelException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            CommerceChannel commerceChannel2 = (CommerceChannel)this.remove((BaseModel)commerceChannel);
            return commerceChannel2;
        }
        catch (NoSuchChannelException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceChannel removeImpl(CommerceChannel commerceChannel) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)commerceChannel)) {
                commerceChannel = (CommerceChannel)session.get(CommerceChannelImpl.class, commerceChannel.getPrimaryKeyObj());
            }
            if (commerceChannel != null) {
                session.delete((Object)commerceChannel);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (commerceChannel != null) {
            this.clearCache(commerceChannel);
        }
        return commerceChannel;
    }

    public CommerceChannel updateImpl(CommerceChannel commerceChannel) {
        boolean isNew = commerceChannel.isNew();
        if (!(commerceChannel instanceof CommerceChannelModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(commerceChannel.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)commerceChannel);
                throw new IllegalArgumentException("Implement ModelWrapper in commerceChannel proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom CommerceChannel implementation " + commerceChannel.getClass());
        }
        CommerceChannelModelImpl commerceChannelModelImpl = (CommerceChannelModelImpl)commerceChannel;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && commerceChannel.getCreateDate() == null) {
            if (serviceContext == null) {
                commerceChannel.setCreateDate(date);
            } else {
                commerceChannel.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!commerceChannelModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                commerceChannel.setModifiedDate(date);
            } else {
                commerceChannel.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)commerceChannel);
            } else {
                commerceChannel = (CommerceChannel)session.merge((Object)commerceChannel);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(CommerceChannelImpl.class, (BaseModel)commerceChannelModelImpl, false, true);
        this.cacheUniqueFindersCache(commerceChannelModelImpl);
        if (isNew) {
            commerceChannel.setNew(false);
        }
        commerceChannel.resetOriginalValues();
        return commerceChannel;
    }

    public CommerceChannel findByPrimaryKey(Serializable primaryKey) throws NoSuchChannelException {
        CommerceChannel commerceChannel = (CommerceChannel)this.fetchByPrimaryKey(primaryKey);
        if (commerceChannel == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchChannelException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return commerceChannel;
    }

    public CommerceChannel findByPrimaryKey(long commerceChannelId) throws NoSuchChannelException {
        return this.findByPrimaryKey(Long.valueOf(commerceChannelId));
    }

    public CommerceChannel fetchByPrimaryKey(long commerceChannelId) {
        return (CommerceChannel)this.fetchByPrimaryKey(Long.valueOf(commerceChannelId));
    }

    public List<CommerceChannel> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<CommerceChannel> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<CommerceChannel> findAll(int start, int end, OrderByComparator<CommerceChannel> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<CommerceChannel> findAll(int start, int end, OrderByComparator<CommerceChannel> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_COMMERCECHANNEL);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_COMMERCECHANNEL;
                sql = sql.concat(" ORDER BY commerceChannel.createDate DESC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (CommerceChannel commerceChannel : this.findAll()) {
            this.remove((BaseModel)commerceChannel);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_COMMERCECHANNEL);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "commerceChannelId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_COMMERCECHANNEL;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return CommerceChannelModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        Bundle bundle = FrameworkUtil.getBundle(CommerceChannelPersistenceImpl.class);
        this._bundleContext = bundle.getBundleContext();
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new CommerceChannelModelArgumentsResolver(), (Dictionary)new HashMapDictionary());
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathWithoutPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathCountByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, false);
        this._finderPathFetchBySiteGroupId = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchBySiteGroupId", new String[]{Long.class.getName()}, new String[]{"siteGroupId"}, true);
        this._finderPathCountBySiteGroupId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countBySiteGroupId", new String[]{Long.class.getName()}, new String[]{"siteGroupId"}, false);
        this._finderPathFetchByC_ERC = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByC_ERC", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "externalReferenceCode"}, true);
        this._finderPathCountByC_ERC = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_ERC", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "externalReferenceCode"}, false);
    }

    public void destroy() {
        this.entityCache.removeCache(CommerceChannelImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }

    private static class CommerceChannelModelArgumentsResolver
    implements ArgumentsResolver {
        private static final Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();
        private static final long _ORDER_BY_COLUMNS_BITMASK;

        private CommerceChannelModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return FINDER_ARGS_EMPTY;
                }
                return null;
            }
            CommerceChannelModelImpl commerceChannelModelImpl = (CommerceChannelModelImpl)baseModel;
            long columnBitmask = commerceChannelModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return CommerceChannelModelArgumentsResolver._getValue(commerceChannelModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | CommerceChannelModelImpl.getColumnBitmask(columnName);
                }
                if (finderPath.isBaseModelResult() && FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION == finderPath.getCacheName()) {
                    finderPathColumnBitmask = finderPathColumnBitmask | _ORDER_BY_COLUMNS_BITMASK;
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return CommerceChannelModelArgumentsResolver._getValue(commerceChannelModelImpl, columnNames, original);
            }
            return null;
        }

        public String getClassName() {
            return CommerceChannelImpl.class.getName();
        }

        public String getTableName() {
            return CommerceChannelTable.INSTANCE.getTableName();
        }

        private static Object[] _getValue(CommerceChannelModelImpl commerceChannelModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? commerceChannelModelImpl.getColumnOriginalValue(columnName) : commerceChannelModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }

        static {
            long orderByColumnsBitmask = 0L;
            _ORDER_BY_COLUMNS_BITMASK = orderByColumnsBitmask |= CommerceChannelModelImpl.getColumnBitmask("createDate");
        }
    }
}

