/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.test.util;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetVocabularyLocalServiceUtil;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalServiceUtil;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.service.CommercePriceEntryLocalServiceUtil;
import com.liferay.commerce.price.list.service.CommercePriceListLocalServiceUtil;
import com.liferay.commerce.product.configuration.CPOptionConfiguration;
import com.liferay.commerce.product.constants.CPConstants;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CPOption;
import com.liferay.commerce.product.model.CPOptionValue;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CPDefinitionLocalServiceUtil;
import com.liferay.commerce.product.service.CPDefinitionOptionRelLocalServiceUtil;
import com.liferay.commerce.product.service.CPDefinitionOptionValueRelLocalServiceUtil;
import com.liferay.commerce.product.service.CPInstanceLocalServiceUtil;
import com.liferay.commerce.product.service.CPOptionLocalServiceUtil;
import com.liferay.commerce.product.service.CPOptionValueLocalServiceUtil;
import com.liferay.commerce.product.service.CommerceCatalogLocalServiceUtil;
import com.liferay.commerce.service.CPDefinitionInventoryLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.settings.SystemSettingsLocator;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;

public class CPTestUtil {
    public static AssetCategory addCategoryToCPDefinitions(long groupId, long ... cpDefinitionIds) throws PortalException {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)groupId);
        AssetVocabulary assetVocabulary = AssetVocabularyLocalServiceUtil.addVocabulary((long)serviceContext.getUserId(), (long)groupId, (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (ServiceContext)serviceContext);
        AssetCategory assetCategory = AssetCategoryLocalServiceUtil.addCategory((long)serviceContext.getUserId(), (long)groupId, (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (long)assetVocabulary.getVocabularyId(), (ServiceContext)serviceContext);
        serviceContext.setAssetCategoryIds(new long[]{assetCategory.getCategoryId()});
        for (long cpDefinitionId : cpDefinitionIds) {
            CPDefinitionLocalServiceUtil.updateCPDefinitionCategorization((long)cpDefinitionId, (ServiceContext)serviceContext);
        }
        return assetCategory;
    }

    public static CPDefinition addCPDefinition(long groupId) throws PortalException {
        return CPTestUtil._addCPDefinition(groupId, "simple", true, true, ServiceContextTestUtil.getServiceContext((long)groupId));
    }

    public static CPDefinition addCPDefinition(long groupId, boolean ignoreSKUCombinations, boolean hasDefaultInstance, int workflowAction) throws PortalException {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)groupId);
        serviceContext.setWorkflowAction(workflowAction);
        return CPTestUtil._addCPDefinition("simple", ignoreSKUCombinations, hasDefaultInstance, serviceContext);
    }

    public static CPDefinition addCPDefinition(long groupId, String productTypeName, boolean ignoreSKUCombinations, boolean hasDefaultInstance) throws PortalException {
        return CPTestUtil._addCPDefinition(productTypeName, ignoreSKUCombinations, hasDefaultInstance, ServiceContextTestUtil.getServiceContext((long)groupId));
    }

    public static CPInstance addCPDefinitionCPInstance(long cpDefinitionId, Map<Long, List<Long>> cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds) throws PortalException {
        CPDefinition cpDefinition = CPDefinitionLocalServiceUtil.getCPDefinition((long)cpDefinitionId);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)cpDefinition.getGroupId());
        User user = UserLocalServiceUtil.getUser((long)serviceContext.getUserId());
        long now = System.currentTimeMillis();
        Date displayDate = new Date(now - 3600000L);
        Date expirationDate = new Date(now + 86400000L);
        Calendar displayCalendar = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
        displayCalendar.setTime(displayDate);
        int displayDateMonth = displayCalendar.get(2);
        int displayDateDay = displayCalendar.get(5);
        int displayDateYear = displayCalendar.get(1);
        int displayDateHour = displayCalendar.get(10);
        int displayDateMinute = displayCalendar.get(12);
        if (displayCalendar.get(9) == 1) {
            displayDateHour += 12;
        }
        Calendar expirationCalendar = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
        expirationCalendar.setTime(expirationDate);
        int expirationDateMonth = expirationCalendar.get(2);
        int expirationDateDay = expirationCalendar.get(5);
        int expirationDateYear = expirationCalendar.get(1);
        int expirationDateHour = expirationCalendar.get(10);
        int expirationDateMinute = expirationCalendar.get(12);
        if (expirationCalendar.get(9) == 1) {
            expirationDateHour += 12;
        }
        return CPInstanceLocalServiceUtil.addCPInstance(null, (long)cpDefinition.getCPDefinitionId(), (long)cpDefinition.getGroupId(), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (boolean)true, cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds, (double)19.77, (double)19.77, (double)9.7, (double)14.55, (BigDecimal)BigDecimal.TEN, (BigDecimal)BigDecimal.TEN, (BigDecimal)BigDecimal.TEN, (boolean)true, (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)true, (boolean)false, (boolean)false, (int)1, (String)"", null, (long)0L, (ServiceContext)serviceContext);
    }

    public static CPInstance addCPDefinitionCPInstanceWithPrice(long cpDefinitionId, Map<Long, List<Long>> cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds, BigDecimal price) throws PortalException {
        CPInstance cpInstance = CPTestUtil.addCPDefinitionCPInstance(cpDefinitionId, cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds);
        cpInstance.setPrice(price);
        cpInstance.setPromoPrice(BigDecimal.ZERO);
        cpInstance.setCost(BigDecimal.ZERO);
        return CPInstanceLocalServiceUtil.updateCPInstance((CPInstance)cpInstance);
    }

    public static CPDefinition addCPDefinitionFromCatalog(long groupId, String productTypeName, boolean ignoreSKUCombinations, boolean hasDefaultInstance) throws PortalException {
        return CPTestUtil._addCPDefinition(groupId, productTypeName, ignoreSKUCombinations, hasDefaultInstance, ServiceContextTestUtil.getServiceContext((long)groupId));
    }

    public static CPDefinitionOptionRel addCPDefinitionOptionRel(long groupId, long cpDefinitionId, boolean skuContributor, int cpDefinitionOptionValueRelsCount) throws PortalException {
        CPOption cpOption = CPTestUtil.addCPOption(groupId, skuContributor);
        for (int i = 0; i < cpDefinitionOptionValueRelsCount; ++i) {
            CPTestUtil.addCPOptionValue(cpOption);
        }
        return CPTestUtil.addCPDefinitionOptionRel(groupId, cpDefinitionId, cpOption.getCPOptionId());
    }

    public static CPDefinitionOptionRel addCPDefinitionOptionRel(long groupId, long cpDefinitionId, long cpOptionId) throws PortalException {
        return CPDefinitionOptionRelLocalServiceUtil.addCPDefinitionOptionRel((long)cpDefinitionId, (long)cpOptionId, (boolean)true, (ServiceContext)ServiceContextTestUtil.getServiceContext((long)groupId));
    }

    public static CPDefinitionOptionValueRel addCPDefinitionOptionValueRelWithPrice(long groupId, long cpDefinitionId, long cpInstanceId, long cpOptionId, String priceType, BigDecimal price, int quantity, boolean required, boolean skuContributor, ServiceContext serviceContext) throws PortalException {
        CPDefinitionOptionRel cpDefinitionOptionRel = CPDefinitionOptionRelLocalServiceUtil.fetchCPDefinitionOptionRel((long)cpDefinitionId, (long)cpOptionId);
        if (cpDefinitionOptionRel == null) {
            cpDefinitionOptionRel = CPDefinitionOptionRelLocalServiceUtil.addCPDefinitionOptionRel((long)cpDefinitionId, (long)cpOptionId, (Map)RandomTestUtil.randomLocaleStringMap(), (Map)RandomTestUtil.randomLocaleStringMap(), (String)CPTestUtil.getDefaultDDMFormFieldType(true), (double)RandomTestUtil.randomDouble(), (boolean)false, (boolean)required, (boolean)skuContributor, (boolean)false, (String)priceType, (ServiceContext)serviceContext);
        }
        CPDefinitionOptionValueRel cpDefinitionOptionValueRel = CPDefinitionOptionValueRelLocalServiceUtil.addCPDefinitionOptionValueRel((long)cpDefinitionOptionRel.getCPDefinitionOptionRelId(), (Map)RandomTestUtil.randomLocaleStringMap(), (double)RandomTestUtil.randomDouble(), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (ServiceContext)serviceContext);
        if (cpInstanceId == 0L && priceType != null) {
            CPInstance cpInstance = CPTestUtil.addCPInstanceFromCatalog(groupId, BigDecimal.valueOf(RandomTestUtil.randomInt()));
            cpInstanceId = cpInstance.getCPInstanceId();
        }
        return CPDefinitionOptionValueRelLocalServiceUtil.updateCPDefinitionOptionValueRel((long)cpDefinitionOptionValueRel.getCPDefinitionOptionValueRelId(), (Map)cpDefinitionOptionValueRel.getNameMap(), (double)cpDefinitionOptionValueRel.getPriority(), (String)cpDefinitionOptionValueRel.getKey(), (long)cpInstanceId, (int)quantity, (BigDecimal)price, (ServiceContext)serviceContext);
    }

    public static CPDefinition addCPDefinitionWithChildCPDefinitions(long groupId) throws Exception {
        return CPTestUtil.addCPDefinitionWithChildCPDefinitions(groupId, 1);
    }

    public static CPDefinition addCPDefinitionWithChildCPDefinitions(long groupId, int priceableOptionsCount) throws Exception {
        return CPTestUtil.addCPDefinitionWithChildCPDefinitions(groupId, priceableOptionsCount, null);
    }

    public static CPDefinition addCPDefinitionWithChildCPDefinitions(long groupId, int priceableOptionsCount, String priceType) throws Exception {
        CPDefinition bundleCPDefinition = CPTestUtil.addCPDefinitionFromCatalog(groupId, "simple", true, true);
        for (int i = 0; i < priceableOptionsCount; ++i) {
            List<CPInstance> cpInstances = CPTestUtil._getSimpleCPDefinitionCPInstances(groupId, RandomTestUtil.randomInt((int)2, (int)5));
            if (Validator.isNull((String)priceType)) {
                CPTestUtil._toPriceableCPDefinitionOptionValueRels(groupId, bundleCPDefinition, CPTestUtil._getRandomPriceType(), cpInstances);
                continue;
            }
            CPTestUtil._toPriceableCPDefinitionOptionValueRels(groupId, bundleCPDefinition, priceType, cpInstances);
        }
        return bundleCPDefinition;
    }

    public static CPDefinition addCPDefinitionWithChildCPDefinitions(long groupId, String priceType) throws Exception {
        return CPTestUtil.addCPDefinitionWithChildCPDefinitions(groupId, 1, priceType);
    }

    public static CPInstance addCPInstance() throws PortalException {
        CPDefinition cpDefinition = CPTestUtil._addCPDefinition("simple", true, true, ServiceContextTestUtil.getServiceContext());
        CPInstance cpInstance = CPInstanceLocalServiceUtil.getCPInstance((long)cpDefinition.getCPDefinitionId(), (String)"default");
        CPTestUtil._addCommercePriceEntry(cpInstance);
        return cpInstance;
    }

    public static CPInstance addCPInstance(long groupId) throws PortalException {
        CPDefinition cpDefinition = CPTestUtil._addCPDefinition("simple", true, true, ServiceContextTestUtil.getServiceContext((long)groupId));
        CPInstance cpInstance = CPInstanceLocalServiceUtil.getCPInstance((long)cpDefinition.getCPDefinitionId(), (String)"default");
        CPTestUtil._addCommercePriceEntry(cpInstance);
        return cpInstance;
    }

    public static CPInstance addCPInstanceFromCatalog(long groupId) throws PortalException {
        CPDefinition cpDefinition = CPTestUtil._addCPDefinition(groupId, "simple", true, true, ServiceContextTestUtil.getServiceContext((long)groupId));
        return CPInstanceLocalServiceUtil.getCPInstance((long)cpDefinition.getCPDefinitionId(), (String)"default");
    }

    public static CPInstance addCPInstanceFromCatalog(long groupId, BigDecimal price) throws PortalException {
        CPInstance cpInstance = CPTestUtil.addCPInstanceFromCatalog(groupId);
        cpInstance.setPrice(price);
        cpInstance = CPInstanceLocalServiceUtil.updateCPInstance((CPInstance)cpInstance);
        CPTestUtil._addCommercePriceEntry(cpInstance);
        return cpInstance;
    }

    public static CPInstance addCPInstanceFromCatalog(long groupId, BigDecimal price, String sku) throws PortalException {
        CPInstance cpInstance = CPTestUtil.addCPInstanceFromCatalog(groupId);
        cpInstance.setSku(sku);
        cpInstance.setPrice(price);
        cpInstance = CPInstanceLocalServiceUtil.updateCPInstance((CPInstance)cpInstance);
        CPTestUtil._addCommercePriceEntry(cpInstance);
        return cpInstance;
    }

    public static CPInstance addCPInstanceFromCatalog(long groupId, long[] assetCategoryIds) throws PortalException {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)groupId);
        serviceContext.setAssetCategoryIds(assetCategoryIds);
        CPDefinition cpDefinition = CPTestUtil._addCPDefinition(groupId, "simple", true, true, serviceContext);
        return CPInstanceLocalServiceUtil.getCPInstance((long)cpDefinition.getCPDefinitionId(), (String)"default");
    }

    public static CPInstance addCPInstanceWithRandomSku(long groupId) throws PortalException {
        String sku = RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        CPDefinition cpDefinition = CPTestUtil._addCPDefinitionWithSku("simple", true, ServiceContextTestUtil.getServiceContext((long)groupId), sku);
        CPInstance cpInstance = CPInstanceLocalServiceUtil.getCPInstance((long)cpDefinition.getCPDefinitionId(), (String)sku);
        CPTestUtil._addCommercePriceEntry(cpInstance);
        return cpInstance;
    }

    public static CPInstance addCPInstanceWithRandomSku(long groupId, BigDecimal price) throws PortalException {
        String sku = RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        CPDefinition cpDefinition = CPTestUtil._addCPDefinitionWithSku("simple", true, ServiceContextTestUtil.getServiceContext((long)groupId), sku);
        CPInstance cpInstance = CPInstanceLocalServiceUtil.getCPInstance((long)cpDefinition.getCPDefinitionId(), (String)sku);
        cpInstance.setPrice(price);
        CPTestUtil._addCommercePriceEntry(cpInstance);
        return cpInstance;
    }

    public static CPInstance addCPInstanceWithRandomSkuFromCatalog(long groupId) throws PortalException {
        String sku = RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        CPDefinition cpDefinition = CPTestUtil._addCPDefinitionWithSku(groupId, "simple", true, ServiceContextTestUtil.getServiceContext((long)groupId), sku);
        return CPInstanceLocalServiceUtil.getCPInstance((long)cpDefinition.getCPDefinitionId(), (String)sku);
    }

    @Deprecated
    public static CPInstance addCPInstanceWithSku(long groupId) throws PortalException {
        CPDefinition cpDefinition = CPTestUtil._addCPDefinition("simple", true, true, ServiceContextTestUtil.getServiceContext((long)groupId));
        CPInstance cpInstance = CPTestUtil.addCPDefinitionCPInstance(cpDefinition.getCPDefinitionId(), Collections.emptyMap());
        cpInstance.setStatus(0);
        CPTestUtil._addCommercePriceEntry(cpInstance);
        return CPInstanceLocalServiceUtil.updateCPInstance((CPInstance)cpInstance);
    }

    public static CPOption addCPOption(long groupId, boolean skuContributor) throws PortalException {
        return CPTestUtil.addCPOption(groupId, CPTestUtil.getDefaultDDMFormFieldType(skuContributor), skuContributor);
    }

    public static List<CPDefinitionOptionRel> addCPOption(long groupId, long cpDefinitionId, int cpOptionsCount, int cpOptionValuesCount) throws Exception {
        ArrayList<CPDefinitionOptionRel> cpDefinitionOptionRels = new ArrayList<CPDefinitionOptionRel>();
        for (int i = 0; i < cpOptionsCount; ++i) {
            CPOption cpOption = CPTestUtil.addCPOption(groupId, true);
            for (int j = 0; j < cpOptionValuesCount; ++j) {
                CPTestUtil.addCPOptionValue(cpOption);
            }
            cpDefinitionOptionRels.add(CPTestUtil.addCPDefinitionOptionRel(groupId, cpDefinitionId, cpOption.getCPOptionId()));
        }
        return cpDefinitionOptionRels;
    }

    public static CPOption addCPOption(long groupId, String ddmFormFieldType, boolean skuContributor) throws PortalException {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)groupId);
        return CPOptionLocalServiceUtil.addCPOption(null, (long)serviceContext.getUserId(), (Map)RandomTestUtil.randomLocaleStringMap(), (Map)RandomTestUtil.randomLocaleStringMap(), (String)ddmFormFieldType, (boolean)RandomTestUtil.randomBoolean(), (boolean)RandomTestUtil.randomBoolean(), (boolean)skuContributor, (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (ServiceContext)serviceContext);
    }

    public static CPOptionValue addCPOptionValue(CPOption cpOption) throws PortalException {
        return CPOptionValueLocalServiceUtil.addCPOptionValue((long)cpOption.getCPOptionId(), (Map)RandomTestUtil.randomLocaleStringMap(), (double)RandomTestUtil.randomDouble(), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (ServiceContext)ServiceContextTestUtil.getServiceContext());
    }

    public static void buildCPInstances(CPDefinition cpDefinition) throws PortalException {
        CPInstanceLocalServiceUtil.buildCPInstances((long)cpDefinition.getCPDefinitionId(), (ServiceContext)ServiceContextTestUtil.getServiceContext((long)cpDefinition.getGroupId()));
    }

    public static String[] getCPOptionFieldTypes() throws ConfigurationException {
        CPOptionConfiguration cpOptionConfiguration = CPTestUtil._getCPOptionConfiguration();
        return cpOptionConfiguration.ddmFormFieldTypesAllowed();
    }

    public static String getDefaultDDMFormFieldType(boolean skuContributor) throws ConfigurationException {
        CPOptionConfiguration cpOptionConfiguration = CPTestUtil._getCPOptionConfiguration();
        String[] ddmFormFieldTypesAllowed = cpOptionConfiguration.ddmFormFieldTypesAllowed();
        if (skuContributor) {
            ddmFormFieldTypesAllowed = CPConstants.PRODUCT_OPTION_SKU_CONTRIBUTOR_FIELD_TYPES;
        }
        return ddmFormFieldTypesAllowed[0];
    }

    public static CPDefinitionOptionValueRel getRandomCPDefinitionOptionValueRel(long cpDefinitionId) {
        List cpDefinitionOptionRels = CPDefinitionOptionRelLocalServiceUtil.getCPDefinitionOptionRels((long)cpDefinitionId);
        CPDefinitionOptionRel cpDefinitionOptionRel = (CPDefinitionOptionRel)cpDefinitionOptionRels.get(RandomTestUtil.randomInt((int)0, (int)(cpDefinitionOptionRels.size() - 1)));
        List cpDefinitionOptionValueRels = cpDefinitionOptionRel.getCPDefinitionOptionValueRels();
        return (CPDefinitionOptionValueRel)cpDefinitionOptionValueRels.get(RandomTestUtil.randomInt((int)0, (int)(cpDefinitionOptionValueRels.size() - 1)));
    }

    public static List<CPDefinitionOptionValueRel> getRandomCPDefinitionOptionValueRels(long cpDefinitionId) {
        ArrayList<CPDefinitionOptionValueRel> cpDefinitionOptionValueRels = new ArrayList<CPDefinitionOptionValueRel>();
        List cpDefinitionOptionRels = CPDefinitionOptionRelLocalServiceUtil.getCPDefinitionOptionRels((long)cpDefinitionId);
        for (CPDefinitionOptionRel cpDefinitionOptionRel : cpDefinitionOptionRels) {
            List sourceCPDefinitionOptionValueRels = cpDefinitionOptionRel.getCPDefinitionOptionValueRels();
            cpDefinitionOptionValueRels.add((CPDefinitionOptionValueRel)sourceCPDefinitionOptionValueRels.get(RandomTestUtil.randomInt((int)0, (int)(sourceCPDefinitionOptionValueRels.size() - 1))));
        }
        return cpDefinitionOptionValueRels;
    }

    public static SearchContext getSearchContext(String keywords, int status, Group group) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"status", (Object)status).put((Object)"params", () -> {
            if (Validator.isNotNull((String)keywords)) {
                return LinkedHashMapBuilder.put((Object)"keywords", (Object)keywords).build();
            }
            return null;
        }).build());
        searchContext.setCompanyId(group.getCompanyId());
        searchContext.setGroupIds(new long[]{group.getGroupId()});
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        return searchContext;
    }

    public static BigDecimal stripTrailingZeros(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return bigDecimal;
        }
        return bigDecimal.stripTrailingZeros();
    }

    private static void _addCatalogBaseCommercePriceList(long groupId, String currencyCode, String type, ServiceContext serviceContext) throws PortalException {
        CommercePriceList commerceCatalogBasePriceList = CommercePriceListLocalServiceUtil.fetchCatalogBaseCommercePriceListByType((long)groupId, (String)type);
        if (commerceCatalogBasePriceList == null) {
            CommerceCurrency commerceCurrency = CommerceCurrencyLocalServiceUtil.getCommerceCurrency((long)serviceContext.getCompanyId(), (String)currencyCode);
            CommercePriceListLocalServiceUtil.addCatalogBaseCommercePriceList((long)groupId, (long)serviceContext.getUserId(), (long)commerceCurrency.getCommerceCurrencyId(), (String)type, (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (ServiceContext)serviceContext);
        }
    }

    private static void _addCommercePriceEntry(CPInstance cpInstance) throws PortalException {
        CommercePriceList commercePriceList = CommercePriceListLocalServiceUtil.fetchCatalogBaseCommercePriceList((long)cpInstance.getGroupId());
        if (commercePriceList == null) {
            return;
        }
        CPDefinition cpDefinition = cpInstance.getCPDefinition();
        CommercePriceEntryLocalServiceUtil.addCommercePriceEntry((String)"", (long)cpDefinition.getCProductId(), (String)cpInstance.getCPInstanceUuid(), (long)commercePriceList.getCommercePriceListId(), (BigDecimal)cpInstance.getPrice(), null, (ServiceContext)ServiceContextTestUtil.getServiceContext((long)cpInstance.getGroupId()));
    }

    private static CPDefinition _addCPDefinition(long groupId, String productTypeName, boolean ignoreSKUCombinations, boolean hasDefaultInstance, ServiceContext serviceContext) throws PortalException {
        String defaultSku = null;
        if (hasDefaultInstance) {
            defaultSku = "default";
        }
        return CPTestUtil._addCPDefinitionWithSku(groupId, productTypeName, ignoreSKUCombinations, serviceContext, defaultSku);
    }

    private static CPDefinition _addCPDefinition(String productTypeName, boolean ignoreSKUCombinations, boolean hasDefaultInstance, ServiceContext serviceContext) throws PortalException {
        User user = UserLocalServiceUtil.getUser((long)serviceContext.getUserId());
        List commerceCatalogs = CommerceCatalogLocalServiceUtil.getCommerceCatalogs((long)user.getCompanyId(), (boolean)true);
        CommerceCatalog commerceCatalog = (CommerceCatalog)commerceCatalogs.get(0);
        CPTestUtil._addCatalogBaseCommercePriceList(commerceCatalog.getGroupId(), commerceCatalog.getCommerceCurrencyCode(), "price-list", serviceContext);
        CPTestUtil._addCatalogBaseCommercePriceList(commerceCatalog.getGroupId(), commerceCatalog.getCommerceCurrencyCode(), "promotion", serviceContext);
        return CPTestUtil._addCPDefinition(commerceCatalog.getGroupId(), productTypeName, ignoreSKUCombinations, hasDefaultInstance, ServiceContextTestUtil.getServiceContext((long)commerceCatalog.getGroupId()));
    }

    private static CPDefinition _addCPDefinitionWithSku(long groupId, String productTypeName, boolean ignoreSKUCombinations, ServiceContext serviceContext, String sku) throws PortalException {
        CPDefinition cpDefinition;
        CPDefinitionInventory cpDefinitionInventory;
        User user = UserLocalServiceUtil.getUser((long)serviceContext.getUserId());
        long now = System.currentTimeMillis();
        Map titleMap = RandomTestUtil.randomLocaleStringMap();
        Map shortDescriptionMap = RandomTestUtil.randomLocaleStringMap();
        Map descriptionMap = RandomTestUtil.randomLocaleStringMap();
        Map metaTitleMap = RandomTestUtil.randomLocaleStringMap();
        Map metaKeywordsMap = RandomTestUtil.randomLocaleStringMap();
        Map metaDescriptionMap = RandomTestUtil.randomLocaleStringMap();
        Map urlTitleMap = RandomTestUtil.randomLocaleStringMap();
        boolean shippable = RandomTestUtil.randomBoolean();
        boolean freeShipping = RandomTestUtil.randomBoolean();
        boolean shipSeparately = RandomTestUtil.randomBoolean();
        double shippingExtraPrice = RandomTestUtil.randomDouble();
        double width = RandomTestUtil.randomDouble();
        double height = RandomTestUtil.randomDouble();
        double depth = RandomTestUtil.randomDouble();
        double weight = RandomTestUtil.randomDouble();
        long cpTaxCategoryId = 0L;
        boolean taxExempt = RandomTestUtil.randomBoolean();
        boolean telcoOrElectronics = RandomTestUtil.randomBoolean();
        String ddmStructureKey = null;
        boolean published = true;
        Date displayDate = new Date(now - 3600000L);
        Date expirationDate = new Date(now + 86400000L);
        Calendar displayCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
        displayCal.setTime(displayDate);
        int displayDateMonth = displayCal.get(2);
        int displayDateDay = displayCal.get(5);
        int displayDateYear = displayCal.get(1);
        int displayDateHour = displayCal.get(10);
        int displayDateMinute = displayCal.get(12);
        if (displayCal.get(9) == 1) {
            displayDateHour += 12;
        }
        Calendar expirationCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
        expirationCal.setTime(expirationDate);
        int expirationDateMonth = expirationCal.get(2);
        int expirationDateDay = expirationCal.get(5);
        int expirationDateYear = expirationCal.get(1);
        int expirationDateHour = expirationCal.get(10);
        int expirationDateMinute = expirationCal.get(12);
        if (expirationCal.get(9) == 1) {
            expirationDateHour += 12;
        }
        if ((cpDefinitionInventory = CPDefinitionInventoryLocalServiceUtil.fetchCPDefinitionInventoryByCPDefinitionId((long)(cpDefinition = CPDefinitionLocalServiceUtil.addCPDefinition(null, (long)groupId, (long)user.getUserId(), (Map)titleMap, (Map)shortDescriptionMap, (Map)descriptionMap, (Map)urlTitleMap, (Map)metaTitleMap, (Map)metaKeywordsMap, (Map)metaDescriptionMap, (String)productTypeName, (boolean)ignoreSKUCombinations, (boolean)shippable, (boolean)freeShipping, (boolean)shipSeparately, (double)shippingExtraPrice, (double)width, (double)height, (double)depth, (double)weight, (long)cpTaxCategoryId, (boolean)taxExempt, (boolean)telcoOrElectronics, ddmStructureKey, (boolean)published, (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)false, (String)sku, (boolean)false, (int)0, null, null, (long)0L, (ServiceContext)serviceContext)).getCPDefinitionId())) != null) {
            cpDefinitionInventory.setBackOrders(false);
            CPDefinitionInventoryLocalServiceUtil.updateCPDefinitionInventory((CPDefinitionInventory)cpDefinitionInventory);
        }
        return cpDefinition;
    }

    private static CPDefinition _addCPDefinitionWithSku(String productTypeName, boolean ignoreSKUCombinations, ServiceContext serviceContext, String sku) throws PortalException {
        User user = UserLocalServiceUtil.getUser((long)serviceContext.getUserId());
        List commerceCatalogs = CommerceCatalogLocalServiceUtil.getCommerceCatalogs((long)user.getCompanyId(), (boolean)true);
        CommerceCatalog commerceCatalog = (CommerceCatalog)commerceCatalogs.get(0);
        CPTestUtil._addCatalogBaseCommercePriceList(commerceCatalog.getGroupId(), commerceCatalog.getCommerceCurrencyCode(), "price-list", serviceContext);
        CPTestUtil._addCatalogBaseCommercePriceList(commerceCatalog.getGroupId(), commerceCatalog.getCommerceCurrencyCode(), "promotion", serviceContext);
        long now = System.currentTimeMillis();
        Map titleMap = RandomTestUtil.randomLocaleStringMap();
        Map shortDescriptionMap = RandomTestUtil.randomLocaleStringMap();
        Map descriptionMap = RandomTestUtil.randomLocaleStringMap();
        Map metaTitleMap = RandomTestUtil.randomLocaleStringMap();
        Map metaKeywordsMap = RandomTestUtil.randomLocaleStringMap();
        Map metaDescriptionMap = RandomTestUtil.randomLocaleStringMap();
        Map urlTitleMap = RandomTestUtil.randomLocaleStringMap();
        boolean shippable = true;
        boolean freeShipping = false;
        boolean shipSeparately = RandomTestUtil.randomBoolean();
        double shippingExtraPrice = RandomTestUtil.randomDouble();
        double width = RandomTestUtil.randomDouble();
        double height = RandomTestUtil.randomDouble();
        double depth = RandomTestUtil.randomDouble();
        double weight = RandomTestUtil.randomDouble();
        long cpTaxCategoryId = 0L;
        boolean taxExempt = RandomTestUtil.randomBoolean();
        boolean telcoOrElectronics = RandomTestUtil.randomBoolean();
        String ddmStructureKey = null;
        boolean published = true;
        Date displayDate = new Date(now - 3600000L);
        Date expirationDate = new Date(now + 86400000L);
        Calendar displayCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
        displayCal.setTime(displayDate);
        int displayDateMonth = displayCal.get(2);
        int displayDateDay = displayCal.get(5);
        int displayDateYear = displayCal.get(1);
        int displayDateHour = displayCal.get(10);
        int displayDateMinute = displayCal.get(12);
        if (displayCal.get(9) == 1) {
            displayDateHour += 12;
        }
        Calendar expirationCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
        expirationCal.setTime(expirationDate);
        int expirationDateMonth = expirationCal.get(2);
        int expirationDateDay = expirationCal.get(5);
        int expirationDateYear = expirationCal.get(1);
        int expirationDateHour = expirationCal.get(10);
        int expirationDateMinute = expirationCal.get(12);
        if (expirationCal.get(9) == 1) {
            expirationDateHour += 12;
        }
        return CPDefinitionLocalServiceUtil.addCPDefinition(null, (long)commerceCatalog.getGroupId(), (long)user.getUserId(), (Map)titleMap, (Map)shortDescriptionMap, (Map)descriptionMap, (Map)urlTitleMap, (Map)metaTitleMap, (Map)metaKeywordsMap, (Map)metaDescriptionMap, (String)productTypeName, (boolean)ignoreSKUCombinations, (boolean)shippable, (boolean)freeShipping, (boolean)shipSeparately, (double)shippingExtraPrice, (double)width, (double)height, (double)depth, (double)weight, (long)cpTaxCategoryId, (boolean)taxExempt, (boolean)telcoOrElectronics, ddmStructureKey, (boolean)published, (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)false, (String)sku, (boolean)false, (int)0, null, null, (long)0L, (ServiceContext)serviceContext);
    }

    private static CPOptionConfiguration _getCPOptionConfiguration() throws ConfigurationException {
        return (CPOptionConfiguration)ConfigurationProviderUtil.getConfiguration(CPOptionConfiguration.class, (SettingsLocator)new SystemSettingsLocator("com.liferay.commerce.product.option"));
    }

    private static CPInstance _getRandomApprovedCPInstance(long cpDefinitionId) {
        List cpDefinitionApprovedCPInstances = CPInstanceLocalServiceUtil.getCPDefinitionApprovedCPInstances((long)cpDefinitionId);
        return (CPInstance)cpDefinitionApprovedCPInstances.get(0);
    }

    private static String _getRandomPriceType() {
        if (RandomTestUtil.randomBoolean()) {
            return "dynamic";
        }
        return "static";
    }

    private static List<CPInstance> _getSimpleCPDefinitionCPInstances(long groupId, int size) throws Exception {
        ArrayList<CPInstance> cpInstances = new ArrayList<CPInstance>();
        for (int i = 0; i < size; ++i) {
            CPDefinition optionACPDefinition = CPTestUtil.addCPDefinitionFromCatalog(groupId, "simple", true, true);
            CPInstance cpInstance = CPTestUtil._getRandomApprovedCPInstance(optionACPDefinition.getCPDefinitionId());
            cpInstance.setPurchasable(true);
            cpInstance.setPrice(new BigDecimal(RandomTestUtil.randomDouble()));
            cpInstances.add(CPInstanceLocalServiceUtil.updateCPInstance((CPInstance)cpInstance));
        }
        return cpInstances;
    }

    private static List<CPDefinitionOptionValueRel> _toPriceableCPDefinitionOptionValueRels(long groupId, CPDefinition parentCPDefinition, String priceType, List<CPInstance> childCPInstances) throws Exception {
        ArrayList<CPDefinitionOptionValueRel> cpDefinitionOptionValueRels = new ArrayList<CPDefinitionOptionValueRel>();
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)groupId);
        CPOption priceableCPOption = CPTestUtil.addCPOption(groupId, CPTestUtil.getDefaultDDMFormFieldType(true), true);
        CPDefinitionOptionRel cpDefinitionOptionRel = CPDefinitionOptionRelLocalServiceUtil.addCPDefinitionOptionRel((long)parentCPDefinition.getCPDefinitionId(), (long)priceableCPOption.getCPOptionId(), (Map)RandomTestUtil.randomLocaleStringMap(), (Map)RandomTestUtil.randomLocaleStringMap(), (String)CPTestUtil.getDefaultDDMFormFieldType(true), (double)RandomTestUtil.nextDouble(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (String)priceType, (ServiceContext)serviceContext);
        for (CPInstance cpInstance : childCPInstances) {
            CPDefinitionOptionValueRel cpInstanceOptionValueRel = CPDefinitionOptionValueRelLocalServiceUtil.addCPDefinitionOptionValueRel((long)cpDefinitionOptionRel.getCPDefinitionOptionRelId(), (Map)RandomTestUtil.randomLocaleStringMap(), (double)RandomTestUtil.nextDouble(), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (ServiceContext)serviceContext);
            BigDecimal price = null;
            if (Objects.equals(priceType, "static")) {
                price = new BigDecimal(RandomTestUtil.randomDouble());
            }
            cpDefinitionOptionValueRels.add(CPDefinitionOptionValueRelLocalServiceUtil.updateCPDefinitionOptionValueRel((long)cpInstanceOptionValueRel.getCPDefinitionOptionValueRelId(), (Map)cpInstanceOptionValueRel.getNameMap(), (double)cpInstanceOptionValueRel.getPriority(), (String)cpInstanceOptionValueRel.getKey(), (long)cpInstance.getCPInstanceId(), (int)2, (BigDecimal)price, (ServiceContext)serviceContext));
        }
        return cpDefinitionOptionValueRels;
    }
}

