/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.model.impl;

import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.service.CommerceOrderTypeLocalServiceUtil;

/**
 * The extended model base implementation for the CommerceOrderType service. Represents a row in the &quot;CommerceOrderType&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceOrderTypeImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceOrderTypeImpl
 * @see CommerceOrderType
 * @generated
 */
public abstract class CommerceOrderTypeBaseImpl
	extends CommerceOrderTypeModelImpl implements CommerceOrderType {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce order type model instance should use the <code>CommerceOrderType</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommerceOrderTypeLocalServiceUtil.addCommerceOrderType(this);
		}
		else {
			CommerceOrderTypeLocalServiceUtil.updateCommerceOrderType(this);
		}
	}

}