/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.health.status;

import com.liferay.commerce.health.status.CommerceHealthStatus;
import com.liferay.commerce.health.status.CommerceHealthStatusRegistry;
import com.liferay.commerce.internal.health.status.comparator.CommerceHealthStatusServiceWrapperDisplayOrderComparator;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={CommerceHealthStatusRegistry.class})
public class CommerceHealthStatusRegistryImpl
implements CommerceHealthStatusRegistry {
    private static final Log _log = LogFactoryUtil.getLog(CommerceHealthStatusRegistryImpl.class);
    private static final Comparator<ServiceTrackerCustomizerFactory.ServiceWrapper<CommerceHealthStatus>> _commerceHealthStatusServiceWrapperDisplayOrderComparator = new CommerceHealthStatusServiceWrapperDisplayOrderComparator();
    private ServiceTrackerMap<String, ServiceTrackerCustomizerFactory.ServiceWrapper<CommerceHealthStatus>> _serviceTrackerMap;

    public List<CommerceHealthStatus> getActiveCommerceHealthStatuses(int type) {
        return TransformUtil.transform((Collection)ListUtil.sort((List)ListUtil.fromCollection((Collection)this._serviceTrackerMap.values()), _commerceHealthStatusServiceWrapperDisplayOrderComparator), commerceHealthStatusServiceWrapper -> {
            CommerceHealthStatus commerceHealthStatus = (CommerceHealthStatus)commerceHealthStatusServiceWrapper.getService();
            if (type == commerceHealthStatus.getType() && commerceHealthStatus.isActive()) {
                return commerceHealthStatus;
            }
            return null;
        });
    }

    public CommerceHealthStatus getCommerceHealthStatus(String key) {
        if (Validator.isNull((String)key)) {
            return null;
        }
        ServiceTrackerCustomizerFactory.ServiceWrapper commerceHealthStatusServiceWrapper = (ServiceTrackerCustomizerFactory.ServiceWrapper)this._serviceTrackerMap.getService((Object)key);
        if (commerceHealthStatusServiceWrapper == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No commerce health status registered with key " + key));
            }
            return null;
        }
        return (CommerceHealthStatus)commerceHealthStatusServiceWrapper.getService();
    }

    public List<CommerceHealthStatus> getCommerceHealthStatuses(int type) {
        return TransformUtil.transform((Collection)ListUtil.sort((List)ListUtil.fromCollection((Collection)this._serviceTrackerMap.values()), _commerceHealthStatusServiceWrapperDisplayOrderComparator), commerceHealthStatusServiceWrapper -> {
            CommerceHealthStatus commerceHealthStatus = (CommerceHealthStatus)commerceHealthStatusServiceWrapper.getService();
            if (type == commerceHealthStatus.getType()) {
                return commerceHealthStatus;
            }
            return null;
        });
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, CommerceHealthStatus.class, (String)"commerce.health.status.key", (ServiceTrackerCustomizer)ServiceTrackerCustomizerFactory.serviceWrapper((BundleContext)bundleContext));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

