/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.model.listener;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.order.CommerceOrderThreadLocal;
import com.liferay.commerce.order.engine.CommerceOrderEngine;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import java.math.BigDecimal;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class CommerceOrderItemModelListener
extends BaseModelListener<CommerceOrderItem> {
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderItemModelListener.class);
    @Reference
    private CommerceOrderEngine _commerceOrderEngine;
    @Reference
    private CommerceOrderItemLocalService _commerceOrderItemLocalService;

    public void onAfterRemove(CommerceOrderItem commerceOrderItem) {
        block4: {
            try {
                if (CommerceOrderThreadLocal.isDeleteInProcess()) {
                    return;
                }
                CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
                if (commerceOrder.getOrderStatus() == 14) {
                    this._commerceOrderEngine.checkCommerceOrderShipmentStatus(commerceOrderItem.getCommerceOrder(), true);
                }
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Throwable)portalException);
            }
        }
    }

    public void onAfterUpdate(CommerceOrderItem originalCommerceOrderItem, CommerceOrderItem commerceOrderItem) {
        block10: {
            try {
                long customerCommerceOrderItemId;
                CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
                if (commerceOrder.getOrderStatus() == 14 || commerceOrder.getOrderStatus() == 15) {
                    this._commerceOrderEngine.checkCommerceOrderShipmentStatus(commerceOrderItem.getCommerceOrder(), true);
                }
                if ((customerCommerceOrderItemId = commerceOrderItem.getCustomerCommerceOrderItemId()) > 0L) {
                    BigDecimal newFinalPrice;
                    int compareFinalPrice;
                    BigDecimal newUnitPrice;
                    int compareUnitPrice;
                    BigDecimal newDiscountAmount;
                    int compareDiscountAmount;
                    BigDecimal newQuantity;
                    CommerceOrderItem customerCommerceOrderItem = this._commerceOrderItemLocalService.getCommerceOrderItem(customerCommerceOrderItemId);
                    int originalShippedQuantity = originalCommerceOrderItem.getShippedQuantity();
                    int newShippedQuantity = commerceOrderItem.getShippedQuantity();
                    boolean update = false;
                    if (originalShippedQuantity != newShippedQuantity) {
                        int commerceShippedQuantity = customerCommerceOrderItem.getShippedQuantity();
                        customerCommerceOrderItem.setShippedQuantity(commerceShippedQuantity - originalShippedQuantity + newShippedQuantity);
                        update = true;
                    }
                    if (!BigDecimalUtil.eq((BigDecimal)(newQuantity = commerceOrderItem.getQuantity()), (BigDecimal)originalCommerceOrderItem.getQuantity())) {
                        customerCommerceOrderItem.setQuantity(newQuantity);
                        update = true;
                    }
                    if ((compareDiscountAmount = (newDiscountAmount = commerceOrderItem.getDiscountAmount()).compareTo(originalCommerceOrderItem.getDiscountAmount())) != 0) {
                        customerCommerceOrderItem.setDiscountAmount(newDiscountAmount);
                    }
                    if ((compareUnitPrice = (newUnitPrice = commerceOrderItem.getUnitPrice()).compareTo(originalCommerceOrderItem.getUnitPrice())) != 0) {
                        customerCommerceOrderItem.setUnitPrice(newUnitPrice);
                        update = true;
                    }
                    if ((compareFinalPrice = (newFinalPrice = commerceOrderItem.getFinalPrice()).compareTo(originalCommerceOrderItem.getFinalPrice())) != 0) {
                        customerCommerceOrderItem.setFinalPrice(newFinalPrice);
                        update = true;
                    }
                    if (update) {
                        customerCommerceOrderItem = this._commerceOrderItemLocalService.updateCommerceOrderItem(customerCommerceOrderItem);
                        this._commerceOrderEngine.checkCommerceOrderShipmentStatus(customerCommerceOrderItem.getCommerceOrder(), false);
                    }
                }
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block10;
                _log.warn((Throwable)portalException);
            }
        }
    }
}

