/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order.term.contributor;

import com.liferay.account.model.AccountEntry;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceSubscriptionEntry;
import com.liferay.commerce.order.CommerceDefinitionTermContributor;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"commerce.definition.term.contributor.key=BodyAndSubjectTerms", "commerce.notification.type.key=subscription-activated", "commerce.notification.type.key=subscription-cancelled", "commerce.notification.type.key=subscription-renewed", "commerce.notification.type.key=subscription-suspended"}, service={CommerceDefinitionTermContributor.class})
public class CommerceSubscriptionCommerceDefinitionTermContributor
implements CommerceDefinitionTermContributor {
    public static final String KEY = "BodyAndSubjectTerms";
    private static final String _ORDER_CREATOR = "[%ORDER_CREATOR%]";
    private static final String _ORDER_ID = "[%ORDER_ID%]";
    private static final String _PRODUCT_NAME = "[%PRODUCT_NAME%]";
    private static final Map<String, String> _languageKeys = HashMapBuilder.put((Object)"[%ORDER_CREATOR%]", (Object)"order-creator-definition-term").put((Object)"[%ORDER_ID%]", (Object)"order-id-definition-term").put((Object)"[%PRODUCT_NAME%]", (Object)"product-name").build();
    @Reference
    private CommerceOrderItemLocalService _commerceOrderItemLocalService;
    @Reference
    private Language _language;
    @Reference
    private UserLocalService _userLocalService;

    public String getFilledTerm(String term, Object object, Locale locale) throws PortalException {
        if (!(object instanceof CommerceSubscriptionEntry)) {
            return term;
        }
        CommerceSubscriptionEntry commerceSubscriptionEntry = (CommerceSubscriptionEntry)object;
        CommerceOrderItem commerceOrderItem = this._commerceOrderItemLocalService.getCommerceOrderItem(commerceSubscriptionEntry.getCommerceOrderItemId());
        if (term.equals(_ORDER_CREATOR)) {
            CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
            AccountEntry accountEntry = commerceOrder.getAccountEntry();
            if (accountEntry.isPersonalAccount()) {
                User user = this._userLocalService.getUser(accountEntry.getUserId());
                return user.getFullName(true, true);
            }
            return accountEntry.getName();
        }
        if (term.equals(_ORDER_ID)) {
            return String.valueOf(commerceOrderItem.getCommerceOrderId());
        }
        if (term.equals(_PRODUCT_NAME)) {
            CPDefinition cpDefinition = commerceOrderItem.getCPDefinition();
            return cpDefinition.getName(LocaleUtil.toLanguageId((Locale)locale));
        }
        return term;
    }

    public String getLabel(String term, Locale locale) {
        return this._language.get(locale, _languageKeys.get(term));
    }

    public List<String> getTerms() {
        return new ArrayList<String>(_languageKeys.keySet());
    }
}

