/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.scheduler;

import com.liferay.commerce.configuration.CommerceSubscriptionConfiguration;
import com.liferay.commerce.service.CommerceSubscriptionEntryLocalService;
import com.liferay.commerce.subscription.CommerceSubscriptionEntryHelper;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.scheduler.SchedulerJobConfiguration;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerConfiguration;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.commerce.configuration.CommerceSubscriptionConfiguration"}, service={SchedulerJobConfiguration.class})
public class CheckCommerceSubscriptionEntrySchedulerJobConfiguration
implements SchedulerJobConfiguration {
    private static final Log _log = LogFactoryUtil.getLog(CheckCommerceSubscriptionEntrySchedulerJobConfiguration.class);
    private CommerceSubscriptionConfiguration _commerceSubscriptionConfiguration;
    @Reference
    private CommerceSubscriptionEntryHelper _commerceSubscriptionEntryHelper;
    @Reference
    private CommerceSubscriptionEntryLocalService _commerceSubscriptionEntryLocalService;

    public UnsafeRunnable<Exception> getJobExecutorUnsafeRunnable() {
        return () -> {
            try {
                this._commerceSubscriptionEntryHelper.checkSubscriptionEntriesStatus(this._commerceSubscriptionEntryLocalService.getCommerceSubscriptionEntriesToRenew());
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
            try {
                this._commerceSubscriptionEntryHelper.checkDeliverySubscriptionEntriesStatus(this._commerceSubscriptionEntryLocalService.getCommerceDeliverySubscriptionEntriesToRenew());
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        };
    }

    public TriggerConfiguration getTriggerConfiguration() {
        return TriggerConfiguration.createTriggerConfiguration((int)this._commerceSubscriptionConfiguration.renewalCheckIntervalMinutes(), (TimeUnit)TimeUnit.MINUTE);
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._commerceSubscriptionConfiguration = (CommerceSubscriptionConfiguration)ConfigurableUtil.createConfigurable(CommerceSubscriptionConfiguration.class, properties);
    }
}

