/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.scheduler;

import com.liferay.commerce.configuration.CommerceOrderConfiguration;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.scheduler.SchedulerJobConfiguration;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerConfiguration;
import java.util.Date;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.commerce.configuration.CommerceOrderConfiguration"}, service={SchedulerJobConfiguration.class})
public class CheckGuestCommerceOrdersSchedulerJobConfiguration
implements SchedulerJobConfiguration {
    private volatile CommerceOrderConfiguration _commerceOrderConfiguration;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;

    public UnsafeRunnable<Exception> getJobExecutorUnsafeRunnable() {
        return () -> {
            int deleteInterval = this._commerceOrderConfiguration.deleteInterval();
            Date createDate = new Date(System.currentTimeMillis() - (long)deleteInterval * 60000L);
            this._commerceOrderLocalService.deleteCommerceOrdersByAccountId(-1L, createDate, 2);
        };
    }

    public TriggerConfiguration getTriggerConfiguration() {
        return TriggerConfiguration.createTriggerConfiguration((int)this._commerceOrderConfiguration.checkInterval(), (TimeUnit)TimeUnit.MINUTE);
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._commerceOrderConfiguration = (CommerceOrderConfiguration)ConfigurableUtil.createConfigurable(CommerceOrderConfiguration.class, properties);
    }
}

