/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v6_1_0;

import com.liferay.account.model.AccountGroup;
import com.liferay.account.service.AccountGroupLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.Objects;

public class CommerceAccountGroupUpgradeProcess
extends UpgradeProcess {
    private final AccountGroupLocalService _accountGroupLocalService;
    private final ResourceLocalService _resourceLocalService;

    public CommerceAccountGroupUpgradeProcess(AccountGroupLocalService accountGroupLocalService, ResourceLocalService resourceLocalService) {
        this._accountGroupLocalService = accountGroupLocalService;
        this._resourceLocalService = resourceLocalService;
    }

    protected void doUpgrade() throws Exception {
        String selectCommerceAccountGroupSQL = "select * from CommerceAccountGroup order by commerceAccountGroupId asc";
        try (Statement selectStatement = this.connection.createStatement();){
            ResultSet resultSet = selectStatement.executeQuery(selectCommerceAccountGroupSQL);
            while (resultSet.next()) {
                boolean system = resultSet.getBoolean("system_");
                if (system) continue;
                long accountGroupId = resultSet.getLong("commerceAccountGroupId");
                AccountGroup accountGroup = this._accountGroupLocalService.createAccountGroup(accountGroupId);
                accountGroup.setExternalReferenceCode(resultSet.getString("externalReferenceCode"));
                accountGroup.setCompanyId(resultSet.getLong("companyId"));
                accountGroup.setUserId(resultSet.getLong("userId"));
                accountGroup.setUserName(resultSet.getString("userName"));
                accountGroup.setCreateDate((Date)resultSet.getTimestamp("createDate"));
                accountGroup.setModifiedDate((Date)resultSet.getTimestamp("modifiedDate"));
                accountGroup.setDefaultAccountGroup(system);
                accountGroup.setName(resultSet.getString("name"));
                accountGroup.setType(this._toAccountGroupType(resultSet.getInt("type_")));
                this._accountGroupLocalService.addAccountGroup(accountGroup);
                this._resourceLocalService.addResources(resultSet.getLong("companyId"), 0L, resultSet.getLong("userId"), AccountGroup.class.getName(), accountGroupId, false, false, false);
            }
        }
    }

    protected UpgradeStep[] getPostUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.dropTables((String[])new String[]{"CommerceAccountGroup"})};
    }

    private String _toAccountGroupType(Integer type) {
        if (Objects.equals(type, 2)) {
            return "guest";
        }
        if (Objects.equals(type, 1)) {
            return "dynamic";
        }
        if (Objects.equals(type, 0)) {
            return "static";
        }
        return "static";
    }
}

