/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v8_9_6;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.List;

public class CommerceAccountRoleUpgradeProcess
extends UpgradeProcess {
    private static final String[] _ASSET_CATEGORIES_ADMIN_PORTLET_ACTION_IDS = new String[]{"CONFIGURATION", "PERMISSIONS", "PREFERENCES"};
    private static final String[] _ASSET_CATEGORY_ACTION_IDS = new String[]{"ADD_CATEGORY", "DELETE", "PERMISSIONS", "UPDATE", "VIEW"};
    private static final String[] _COMMERCE_DISCOUNT_ACTION_IDS = new String[]{"ADD_COMMERCE_DISCOUNT", "PERMISSIONS", "VIEW_COMMERCE_DISCOUNTS"};
    private static final String[] _COMMERCE_DISCOUNT_PORTLET_ACTION_IDS = new String[]{"ACCESS_IN_CONTROL_PANEL", "CONFIGURATION", "PERMISSIONS", "PREFERENCES", "VIEW"};
    private static final String _PORTLET_NAME_ASSET_CATEGORIES_ADMIN = "com_liferay_asset_categories_admin_web_portlet_AssetCategoriesAdminPortlet";
    private static final String _PORTLET_NAME_COMMERCE_DISCOUNT_PRICING = "com_liferay_commerce_pricing_web_internal_portlet_CommerceDiscountPortlet";
    private static final String _ROLE_NAME_ACCOUNT_CATEGORY_MANAGER = "Category Manager";
    private static final String[] _SHARED_MODEL_ACTION_IDS = new String[]{"DELETE", "PERMISSIONS", "UPDATE", "VIEW"};
    private final CompanyLocalService _companyLocalService;
    private final ResourceActionLocalService _resourceActionLocalService;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;
    private final RoleLocalService _roleLocalService;

    public CommerceAccountRoleUpgradeProcess(CompanyLocalService companyLocalService, ResourceActionLocalService resourceActionLocalService, ResourcePermissionLocalService resourcePermissionLocalService, RoleLocalService roleLocalService) {
        this._companyLocalService = companyLocalService;
        this._resourceActionLocalService = resourceActionLocalService;
        this._resourcePermissionLocalService = resourcePermissionLocalService;
        this._roleLocalService = roleLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._companyLocalService.forEachCompanyId(companyId -> {
            this._updateCommerceCategoryManagerRolePermissions((long)companyId, _ROLE_NAME_ACCOUNT_CATEGORY_MANAGER);
            this._updateCommerceDiscountManagerRolePermissions((long)companyId, "Discount Manager");
        });
    }

    private void _addResourcePermission(long companyId, Role role, String resourceName, String actionId) throws PortalException {
        this._resourcePermissionLocalService.addResourcePermission(companyId, resourceName, 1, String.valueOf(0L), role.getRoleId(), actionId);
    }

    private void _updateCommerceCategoryManagerRolePermissions(long companyId, String name) throws PortalException {
        this._updateCommerceRoles(companyId, name, "com.liferay.asset.categories", ListUtil.fromString((String)"PERMISSIONS"));
        this._updateCommerceRoles(companyId, name, "com.liferay.asset.kernel.model.AssetCategory", ListUtil.fromArray((Object[])_ASSET_CATEGORY_ACTION_IDS));
        this._updateCommerceRoles(companyId, name, "com.liferay.asset.kernel.model.AssetVocabulary", ListUtil.fromArray((Object[])_SHARED_MODEL_ACTION_IDS));
        this._updateCommerceRoles(companyId, name, _PORTLET_NAME_ASSET_CATEGORIES_ADMIN, ListUtil.fromArray((Object[])_ASSET_CATEGORIES_ADMIN_PORTLET_ACTION_IDS));
    }

    private void _updateCommerceDiscountManagerRolePermissions(long companyId, String name) throws PortalException {
        this._updateCommerceRoles(companyId, name, "com.liferay.commerce.currency", ListUtil.fromString((String)"MANAGE_COMMERCE_CURRENCIES"));
        this._updateCommerceRoles(companyId, name, "com.liferay.commerce.discount", ListUtil.fromArray((Object[])_COMMERCE_DISCOUNT_ACTION_IDS));
        this._updateCommerceRoles(companyId, name, "com.liferay.commerce.discount.model.CommerceDiscount", ListUtil.fromArray((Object[])_SHARED_MODEL_ACTION_IDS));
        this._updateCommerceRoles(companyId, name, _PORTLET_NAME_COMMERCE_DISCOUNT_PRICING, ListUtil.fromArray((Object[])_COMMERCE_DISCOUNT_PORTLET_ACTION_IDS));
    }

    private void _updateCommerceRoles(long companyId, String name, String resourceName, List<String> actionIds) throws PortalException {
        this._resourceActionLocalService.checkResourceActions(resourceName, actionIds);
        Role role = this._roleLocalService.fetchRole(companyId, name);
        if (role == null) {
            return;
        }
        for (String actionId : actionIds) {
            this._addResourcePermission(companyId, role, resourceName, actionId);
        }
    }
}

