/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.model.impl;

import com.liferay.account.constants.AccountListTypeConstants;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalServiceUtil;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.impl.CommerceAddressBaseImpl;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.model.Phone;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.service.CountryLocalServiceUtil;
import com.liferay.portal.kernel.service.ListTypeLocalServiceUtil;
import com.liferay.portal.kernel.service.PhoneLocalServiceUtil;
import com.liferay.portal.kernel.service.RegionLocalServiceUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;

public class CommerceAddressImpl
extends CommerceAddressBaseImpl {
    public static CommerceAddress fromAddress(Address address) {
        if (address == null) {
            return null;
        }
        CommerceAddressImpl commerceAddress = new CommerceAddressImpl();
        Map attributeSetterBiConsumers = commerceAddress.getAttributeSetterBiConsumers();
        Map modelAttributes = address.getModelAttributes();
        for (Map.Entry entry : modelAttributes.entrySet()) {
            BiConsumer commerceAddressObjectBiConsumer = (BiConsumer)attributeSetterBiConsumers.get(entry.getKey());
            if (commerceAddressObjectBiConsumer == null) continue;
            commerceAddressObjectBiConsumer.accept(commerceAddress, entry.getValue());
        }
        commerceAddress.setCommerceAddressId(address.getAddressId());
        List phones = PhoneLocalServiceUtil.getPhones((long)address.getCompanyId(), (String)Address.class.getName(), (long)address.getAddressId());
        if (!phones.isEmpty()) {
            Phone phone = (Phone)phones.get(0);
            commerceAddress.setPhoneNumber(phone.getNumber());
        }
        commerceAddress.setDefaultBilling(CommerceAddressImpl.toCommerceAccountDefaultBilling(address));
        commerceAddress.setDefaultShipping(CommerceAddressImpl.toCommerceAccountDefaultShipping(address));
        commerceAddress.setType(CommerceAddressImpl.toCommerceAddressType(address));
        return commerceAddress;
    }

    public static boolean isAccountEntryAddress(Address address) {
        return Objects.equals(AccountEntry.class.getName(), address.getClassName());
    }

    public static long toAddressTypeId(int commerceAddressType) {
        if (1 == commerceAddressType) {
            return CommerceAddressImpl._getAddressTypeId("billing");
        }
        if (3 == commerceAddressType) {
            return CommerceAddressImpl._getAddressTypeId("shipping");
        }
        return CommerceAddressImpl._getAddressTypeId("billing-and-shipping");
    }

    public static boolean toCommerceAccountDefaultBilling(Address address) {
        Address defaultBillingAddress;
        AccountEntry accountEntry;
        return CommerceAddressImpl.isAccountEntryAddress(address) && (accountEntry = AccountEntryLocalServiceUtil.fetchAccountEntry((long)address.getClassPK())) != null && (defaultBillingAddress = accountEntry.getDefaultBillingAddress()) != null && defaultBillingAddress.getAddressId() == address.getAddressId();
    }

    public static boolean toCommerceAccountDefaultShipping(Address address) {
        Address defaultShippingAddress;
        AccountEntry accountEntry;
        return CommerceAddressImpl.isAccountEntryAddress(address) && (accountEntry = AccountEntryLocalServiceUtil.fetchAccountEntry((long)address.getClassPK())) != null && (defaultShippingAddress = accountEntry.getDefaultShippingAddress()) != null && defaultShippingAddress.getAddressId() == address.getAddressId();
    }

    public static int toCommerceAddressType(Address address) {
        ListType listType = address.getListType();
        String listTypeName = listType.getName();
        if (Objects.equals("billing", listTypeName)) {
            return 1;
        }
        if (Objects.equals("shipping", listTypeName)) {
            return 3;
        }
        if (Objects.equals("billing-and-shipping", listTypeName)) {
            return 2;
        }
        return 2;
    }

    public Country fetchCountry() {
        return CountryLocalServiceUtil.fetchCountry((long)this.getCountryId());
    }

    public Country getCountry() throws PortalException {
        return CountryLocalServiceUtil.getCountry((long)this.getCountryId());
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge((long)this.getCompanyId(), (String)Address.class.getName(), (long)this.getPrimaryKey());
    }

    public Region getRegion() throws PortalException {
        long regionId = this.getRegionId();
        if (regionId > 0L) {
            return RegionLocalServiceUtil.getRegion((long)regionId);
        }
        return null;
    }

    public boolean isGeolocated() {
        return this.getLatitude() != 0.0 || this.getLongitude() != 0.0;
    }

    public boolean isSameAddress(CommerceAddress commerceAddress) {
        return Objects.equals(this.getName(), commerceAddress.getName()) && Objects.equals(this.getStreet1(), commerceAddress.getStreet1()) && Objects.equals(this.getStreet2(), commerceAddress.getStreet2()) && Objects.equals(this.getStreet3(), commerceAddress.getStreet3()) && Objects.equals(this.getCity(), commerceAddress.getCity()) && Objects.equals(this.getZip(), commerceAddress.getZip()) && this.getRegionId() == commerceAddress.getRegionId() && this.getCountryId() == commerceAddress.getCountryId() && Objects.equals(this.getPhoneNumber(), commerceAddress.getPhoneNumber());
    }

    private static long _getAddressTypeId(String name) {
        ListType listType = ListTypeLocalServiceUtil.getListType((String)name, (String)AccountListTypeConstants.ACCOUNT_ENTRY_ADDRESS);
        return listType.getListTypeId();
    }
}

