/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CommerceCatalogLocalService;
import com.liferay.commerce.service.base.CPDefinitionInventoryServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=commerce", "json.web.service.context.path=CPDefinitionInventory"}, service={AopService.class})
public class CPDefinitionInventoryServiceImpl
extends CPDefinitionInventoryServiceBaseImpl {
    @Reference
    private CommerceCatalogLocalService _commerceCatalogLocalService;
    @Reference(target="(model.class.name=com.liferay.commerce.product.model.CommerceCatalog)")
    private ModelResourcePermission<CommerceCatalog> _commerceCatalogModelResourcePermission;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;

    public CPDefinitionInventory addCPDefinitionInventory(long cpDefinitionId, String cpDefinitionInventoryEngine, String lowStockActivity, boolean displayAvailability, boolean displayStockQuantity, int minStockQuantity, boolean backOrders, int minOrderQuantity, int maxOrderQuantity, String allowedOrderQuantities, int multipleOrderQuantity) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "UPDATE");
        return this.cpDefinitionInventoryLocalService.addCPDefinitionInventory(this.getUserId(), cpDefinitionId, cpDefinitionInventoryEngine, lowStockActivity, displayAvailability, displayStockQuantity, minStockQuantity, backOrders, minOrderQuantity, maxOrderQuantity, allowedOrderQuantities, multipleOrderQuantity);
    }

    public void deleteCPDefinitionInventory(long cpDefinitionInventoryId) throws PortalException {
        CPDefinitionInventory cpDefinitionInventory = this.cpDefinitionInventoryLocalService.getCPDefinitionInventory(cpDefinitionInventoryId);
        this._checkCommerceCatalog(cpDefinitionInventory.getCPDefinitionId(), "UPDATE");
        this.cpDefinitionInventoryLocalService.deleteCPDefinitionInventory(cpDefinitionInventoryId);
    }

    public CPDefinitionInventory fetchCPDefinitionInventoryByCPDefinitionId(long cpDefinitionId) throws PortalException {
        CPDefinitionInventory cpDefinitionInventory = this.cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpDefinitionId);
        if (cpDefinitionInventory != null) {
            this._checkCommerceCatalog(cpDefinitionInventory.getCPDefinitionId(), "UPDATE");
        }
        return cpDefinitionInventory;
    }

    @Deprecated
    public CPDefinitionInventory updateCPDefinitionInventory(long groupId, long cpDefinitionInventoryId, String cpDefinitionInventoryEngine, String lowStockActivity, boolean displayAvailability, boolean displayStockQuantity, int minStockQuantity, boolean backOrders, int minOrderQuantity, int maxOrderQuantity, String allowedOrderQuantities, int multipleOrderQuantity) throws PortalException {
        CPDefinitionInventory cpDefinitionInventory = this.cpDefinitionInventoryLocalService.getCPDefinitionInventory(cpDefinitionInventoryId);
        this._checkCommerceCatalog(cpDefinitionInventory.getCPDefinitionId(), "UPDATE");
        return this.cpDefinitionInventoryLocalService.updateCPDefinitionInventory(cpDefinitionInventoryId, cpDefinitionInventoryEngine, lowStockActivity, displayAvailability, displayStockQuantity, minStockQuantity, backOrders, minOrderQuantity, maxOrderQuantity, allowedOrderQuantities, multipleOrderQuantity);
    }

    public CPDefinitionInventory updateCPDefinitionInventory(long cpDefinitionInventoryId, String cpDefinitionInventoryEngine, String lowStockActivity, boolean displayAvailability, boolean displayStockQuantity, int minStockQuantity, boolean backOrders, int minOrderQuantity, int maxOrderQuantity, String allowedOrderQuantities, int multipleOrderQuantity) throws PortalException {
        CPDefinitionInventory cpDefinitionInventory = this.cpDefinitionInventoryLocalService.getCPDefinitionInventory(cpDefinitionInventoryId);
        this._checkCommerceCatalog(cpDefinitionInventory.getCPDefinitionId(), "UPDATE");
        return this.cpDefinitionInventoryLocalService.updateCPDefinitionInventory(cpDefinitionInventoryId, cpDefinitionInventoryEngine, lowStockActivity, displayAvailability, displayStockQuantity, minStockQuantity, backOrders, minOrderQuantity, maxOrderQuantity, allowedOrderQuantities, multipleOrderQuantity);
    }

    private void _checkCommerceCatalog(long cpDefinitionId, String actionId) throws PortalException {
        CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinition(cpDefinitionId);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException();
        }
        CommerceCatalog commerceCatalog = this._commerceCatalogLocalService.fetchCommerceCatalogByGroupId(cpDefinition.getGroupId());
        this._commerceCatalogModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceCatalog, actionId);
    }
}

