/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.constants.CommerceAddressConstants;
import com.liferay.commerce.exception.CommerceAddressCityException;
import com.liferay.commerce.exception.CommerceAddressCountryException;
import com.liferay.commerce.exception.CommerceAddressNameException;
import com.liferay.commerce.exception.CommerceAddressStreetException;
import com.liferay.commerce.exception.CommerceAddressTypeException;
import com.liferay.commerce.exception.CommerceAddressZipException;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceGeocoder;
import com.liferay.commerce.model.impl.CommerceAddressImpl;
import com.liferay.commerce.product.model.CommerceChannelRelTable;
import com.liferay.commerce.service.base.CommerceAddressLocalServiceBaseImpl;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.AddressTable;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.CountryTable;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.AddressLocalService;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.model.CommerceAddress"}, service={AopService.class})
public class CommerceAddressLocalServiceImpl
extends CommerceAddressLocalServiceBaseImpl {
    @Reference
    private AddressLocalService _addressLocalService;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CommerceGeocoder _commerceGeocoder;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private UserLocalService _userLocalService;

    @Deprecated
    public CommerceAddress addCommerceAddress(String className, long classPK, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, boolean defaultBilling, boolean defaultShipping, ServiceContext serviceContext) throws PortalException {
        int type = 2;
        if (defaultBilling && !defaultShipping) {
            type = 1;
        } else if (!defaultBilling && defaultShipping) {
            type = 3;
        }
        return this.commerceAddressLocalService.addCommerceAddress(className, classPK, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, type, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceAddress addCommerceAddress(String className, long classPK, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, int type, ServiceContext serviceContext) throws PortalException {
        return this.commerceAddressLocalService.addCommerceAddress(null, className, classPK, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, type, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceAddress addCommerceAddress(String externalReferenceCode, String className, long classPK, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, int type, ServiceContext serviceContext) throws PortalException {
        this._validate(name, street1, city, zip, countryId, type);
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        return CommerceAddressImpl.fromAddress(this._addressLocalService.addAddress(externalReferenceCode, user.getUserId(), className, classPK, name, description, street1, street2, street3, city, zip, regionId, countryId, CommerceAddressImpl.toAddressTypeId(type), false, false, phoneNumber, serviceContext));
    }

    public CommerceAddress copyCommerceAddress(long sourceCommerceAddressId, String className, long classPK, ServiceContext serviceContext) throws PortalException {
        CommerceAddress sourceCommerceAddress = this.getCommerceAddress(sourceCommerceAddressId);
        CommerceAddress targetCommerceAddress = this.commerceAddressLocalService.addCommerceAddress(className, classPK, sourceCommerceAddress.getName(), sourceCommerceAddress.getDescription(), sourceCommerceAddress.getStreet1(), sourceCommerceAddress.getStreet2(), sourceCommerceAddress.getStreet3(), sourceCommerceAddress.getCity(), sourceCommerceAddress.getZip(), sourceCommerceAddress.getRegionId(), sourceCommerceAddress.getCountryId(), sourceCommerceAddress.getPhoneNumber(), false, false, serviceContext);
        return CommerceAddressImpl.fromAddress(this._addressLocalService.getAddress(targetCommerceAddress.getCommerceAddressId()));
    }

    public CommerceAddress createCommerceAddress(long commerceAddressId) {
        CommerceAddressImpl commerceAddress = new CommerceAddressImpl();
        commerceAddress.setNew(true);
        commerceAddress.setPrimaryKey(commerceAddressId);
        commerceAddress.setCompanyId(CompanyThreadLocal.getCompanyId());
        return commerceAddress;
    }

    @Indexable(type=IndexableType.DELETE)
    public CommerceAddress deleteCommerceAddress(CommerceAddress commerceAddress) throws PortalException {
        this._addressLocalService.deleteAddress(commerceAddress.getCommerceAddressId());
        return commerceAddress;
    }

    public void deleteCommerceAddresses(String className, long classPK) throws PortalException {
        this._addressLocalService.deleteAddresses(CompanyThreadLocal.getCompanyId().longValue(), className, classPK);
    }

    public void deleteCountryCommerceAddresses(long countryId) throws PortalException {
        this._addressLocalService.deleteCountryAddresses(countryId);
    }

    public void deleteRegionCommerceAddresses(long regionId) throws PortalException {
        this._addressLocalService.deleteRegionAddresses(regionId);
    }

    public CommerceAddress fetchByExternalReferenceCode(String externalReferenceCode, long companyId) {
        return CommerceAddressImpl.fromAddress(this._addressLocalService.fetchAddressByExternalReferenceCode(externalReferenceCode, companyId));
    }

    public CommerceAddress fetchCommerceAddress(long commerceAddressId) {
        return CommerceAddressImpl.fromAddress(this._addressLocalService.fetchAddress(commerceAddressId));
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceAddress geolocateCommerceAddress(long commerceAddressId) throws PortalException {
        Address address = this._addressLocalService.getAddress(commerceAddressId);
        double[] coordinates = this._commerceGeocoder.getCoordinates(address.getStreet1(), address.getCity(), address.getZip(), address.getRegion(), address.getCountry());
        address.setLatitude(coordinates[0]);
        address.setLongitude(coordinates[1]);
        return CommerceAddressImpl.fromAddress(this._addressLocalService.updateAddress(address));
    }

    public List<CommerceAddress> getBillingAndShippingCommerceAddresses(long companyId, String className, long classPK) {
        return TransformUtil.transform((Collection)this._addressLocalService.getListTypeAddresses(companyId, className, classPK, new long[]{CommerceAddressImpl.toAddressTypeId(2)}), CommerceAddressImpl::fromAddress);
    }

    public List<CommerceAddress> getBillingCommerceAddresses(long companyId, String className, long classPK) throws PortalException {
        return this.commerceAddressLocalService.getBillingCommerceAddresses(companyId, className, classPK, null, -1, -1, null);
    }

    public List<CommerceAddress> getBillingCommerceAddresses(long channelId, String className, long classPK, int start, int end) {
        return TransformUtil.transform((Collection)((Collection)this._addressLocalService.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)AddressTable.INSTANCE), AddressTable.INSTANCE.listTypeId.eq((Object)CommerceAddressImpl.toAddressTypeId(1)).or((Expression)AddressTable.INSTANCE.listTypeId.eq((Object)CommerceAddressImpl.toAddressTypeId(2))), channelId, className, classPK, true, false).limit(start, end))), CommerceAddressImpl::fromAddress);
    }

    public List<CommerceAddress> getBillingCommerceAddresses(long companyId, String className, long classPK, String keywords, int start, int end, Sort sort) throws PortalException {
        BaseModelSearchResult addressBaseModelSearchResult = this._addressLocalService.searchAddresses(companyId, className, classPK, keywords, LinkedHashMapBuilder.put((Object)"listTypeIds", (Object)new long[]{CommerceAddressImpl.toAddressTypeId(1), CommerceAddressImpl.toAddressTypeId(2)}).build(), start, end, sort);
        return TransformUtil.transform((Collection)addressBaseModelSearchResult.getBaseModels(), CommerceAddressImpl::fromAddress);
    }

    public int getBillingCommerceAddressesCount(long channelId, String className, long classPK, int start, int end) {
        return this._addressLocalService.dslQueryCount(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)AddressTable.INSTANCE), AddressTable.INSTANCE.listTypeId.eq((Object)CommerceAddressImpl.toAddressTypeId(1)).or((Expression)AddressTable.INSTANCE.listTypeId.eq((Object)CommerceAddressImpl.toAddressTypeId(2))), channelId, className, classPK, true, false).limit(start, end));
    }

    public int getBillingCommerceAddressesCount(long companyId, String className, long classPK, String keywords) throws PortalException {
        BaseModelSearchResult addressBaseModelSearchResult = this._addressLocalService.searchAddresses(companyId, className, classPK, keywords, LinkedHashMapBuilder.put((Object)"listTypeIds", (Object)new long[]{CommerceAddressImpl.toAddressTypeId(1), CommerceAddressImpl.toAddressTypeId(2)}).build(), -1, -1, null);
        return addressBaseModelSearchResult.getLength();
    }

    public CommerceAddress getCommerceAddress(long commerceAddressId) throws PortalException {
        return CommerceAddressImpl.fromAddress(this._addressLocalService.getAddress(commerceAddressId));
    }

    @Deprecated
    public List<CommerceAddress> getCommerceAddresses(long groupId, String className, long classPK) {
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return new ArrayList<CommerceAddress>();
        }
        return this.getCommerceAddressesByCompanyId(group.getCompanyId(), className, classPK);
    }

    @Deprecated
    public List<CommerceAddress> getCommerceAddresses(long groupId, String className, long classPK, int start, int end, OrderByComparator<CommerceAddress> orderByComparator) {
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return new ArrayList<CommerceAddress>();
        }
        return this.getCommerceAddressesByCompanyId(group.getCompanyId(), className, classPK, start, end, orderByComparator);
    }

    public List<CommerceAddress> getCommerceAddresses(String className, long classPK, int start, int end, OrderByComparator<CommerceAddress> orderByComparator) {
        return this.getCommerceAddressesByCompanyId(CompanyThreadLocal.getCompanyId(), className, classPK, start, end, orderByComparator);
    }

    public List<CommerceAddress> getCommerceAddressesByCompanyId(long companyId, String className, long classPK) {
        return TransformUtil.transform((Collection)this._addressLocalService.getAddresses(companyId, className, classPK), CommerceAddressImpl::fromAddress);
    }

    public List<CommerceAddress> getCommerceAddressesByCompanyId(long companyId, String className, long classPK, int start, int end, OrderByComparator<CommerceAddress> orderByComparator) {
        return TransformUtil.transform((Collection)this._addressLocalService.getAddresses(companyId, className, classPK, start, end, this._getAddressOrderByComparator(orderByComparator)), CommerceAddressImpl::fromAddress);
    }

    @Deprecated
    public int getCommerceAddressesCount(long groupId, String className, long classPK) {
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return 0;
        }
        return this.getCommerceAddressesCountByCompanyId(group.getCompanyId(), className, classPK);
    }

    public int getCommerceAddressesCount(String className, long classPK) {
        return this.getCommerceAddressesCountByCompanyId(CompanyThreadLocal.getCompanyId(), className, classPK);
    }

    public int getCommerceAddressesCountByCompanyId(long companyId, String className, long classPK) {
        return this._addressLocalService.getAddressesCount(companyId, className, classPK);
    }

    public List<CommerceAddress> getShippingCommerceAddresses(long companyId, String className, long classPK) throws PortalException {
        return this.commerceAddressLocalService.getShippingCommerceAddresses(companyId, className, classPK, null, -1, -1, null);
    }

    public List<CommerceAddress> getShippingCommerceAddresses(long channelId, String className, long classPK, int start, int end) {
        return TransformUtil.transform((Collection)((Collection)this._addressLocalService.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)AddressTable.INSTANCE), AddressTable.INSTANCE.listTypeId.eq((Object)CommerceAddressImpl.toAddressTypeId(3)).or((Expression)AddressTable.INSTANCE.listTypeId.eq((Object)CommerceAddressImpl.toAddressTypeId(2))), channelId, className, classPK, false, true).limit(start, end))), CommerceAddressImpl::fromAddress);
    }

    public List<CommerceAddress> getShippingCommerceAddresses(long companyId, String className, long classPK, String keywords, int start, int end, Sort sort) throws PortalException {
        BaseModelSearchResult addressBaseModelSearchResult = this._addressLocalService.searchAddresses(companyId, className, classPK, keywords, LinkedHashMapBuilder.put((Object)"listTypeIds", (Object)new long[]{CommerceAddressImpl.toAddressTypeId(2), CommerceAddressImpl.toAddressTypeId(3)}).build(), start, end, sort);
        return TransformUtil.transform((Collection)addressBaseModelSearchResult.getBaseModels(), CommerceAddressImpl::fromAddress);
    }

    public int getShippingCommerceAddressesCount(long channelId, String className, long classPK, int start, int end) {
        return this._addressLocalService.dslQueryCount(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)AddressTable.INSTANCE), AddressTable.INSTANCE.listTypeId.eq((Object)CommerceAddressImpl.toAddressTypeId(3)).or((Expression)AddressTable.INSTANCE.listTypeId.eq((Object)CommerceAddressImpl.toAddressTypeId(2))), channelId, className, classPK, false, true).limit(start, end));
    }

    public int getShippingCommerceAddressesCount(long companyId, String className, long classPK, String keywords) throws PortalException {
        BaseModelSearchResult addressBaseModelSearchResult = this._addressLocalService.searchAddresses(companyId, className, classPK, keywords, LinkedHashMapBuilder.put((Object)"listTypeIds", (Object)new long[]{CommerceAddressImpl.toAddressTypeId(2), CommerceAddressImpl.toAddressTypeId(3)}).build(), -1, -1, null);
        return addressBaseModelSearchResult.getLength();
    }

    @Deprecated
    public BaseModelSearchResult<CommerceAddress> searchCommerceAddresses(long companyId, long groupId, String className, long classPK, String keywords, int start, int end, Sort sort) throws PortalException {
        BaseModelSearchResult addressBaseModelSearchResult = this._addressLocalService.searchAddresses(companyId, className, classPK, keywords, new LinkedHashMap(), start, end, sort);
        return new BaseModelSearchResult(TransformUtil.transform((Collection)addressBaseModelSearchResult.getBaseModels(), CommerceAddressImpl::fromAddress), addressBaseModelSearchResult.getLength());
    }

    public BaseModelSearchResult<CommerceAddress> searchCommerceAddresses(long companyId, String className, long classPK, String keywords, int start, int end, Sort sort) throws PortalException {
        BaseModelSearchResult addressBaseModelSearchResult = this._addressLocalService.searchAddresses(companyId, className, classPK, keywords, new LinkedHashMap(), start, end, sort);
        return new BaseModelSearchResult(TransformUtil.transform((Collection)addressBaseModelSearchResult.getBaseModels(), CommerceAddressImpl::fromAddress), addressBaseModelSearchResult.getLength());
    }

    @Deprecated
    public CommerceAddress updateCommerceAddress(long commerceAddressId, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, boolean defaultBilling, boolean defaultShipping, ServiceContext serviceContext) throws PortalException {
        int type = 2;
        if (defaultBilling && !defaultShipping) {
            type = 1;
        } else if (!defaultBilling && defaultShipping) {
            type = 3;
        }
        return this.updateCommerceAddress(commerceAddressId, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, type, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceAddress updateCommerceAddress(long commerceAddressId, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, int type, ServiceContext serviceContext) throws PortalException {
        Address address = this._addressLocalService.getAddress(commerceAddressId);
        this._validate(name, street1, city, zip, countryId, type);
        address = this._addressLocalService.updateAddress(commerceAddressId, name, description, street1, street2, street3, city, zip, regionId, countryId, CommerceAddressImpl.toAddressTypeId(type), address.isMailing(), address.isPrimary(), phoneNumber);
        return CommerceAddressImpl.fromAddress(address);
    }

    private OrderByComparator<Address> _getAddressOrderByComparator(final OrderByComparator<CommerceAddress> orderByComparator) {
        if (orderByComparator == null) {
            return null;
        }
        return new OrderByComparator<Address>(){

            public int compare(Address address1, Address address2) {
                return orderByComparator.compare((Object)CommerceAddressImpl.fromAddress(address1), (Object)CommerceAddressImpl.fromAddress(address2));
            }
        };
    }

    private GroupByStep _getGroupByStep(FromStep fromStep, Predicate listTypeFilterPredicate, long commerceChannelId, String className, long classPK, boolean billingAllowed, boolean shippingAllowed) {
        JoinStep joinStep = fromStep.from((Table)AddressTable.INSTANCE).leftJoinOn((Table)CountryTable.INSTANCE, AddressTable.INSTANCE.countryId.eq((Expression)CountryTable.INSTANCE.countryId)).leftJoinOn((Table)CommerceChannelRelTable.INSTANCE, CountryTable.INSTANCE.countryId.eq((Expression)CommerceChannelRelTable.INSTANCE.classPK));
        return joinStep.where(() -> {
            Predicate predicate = CountryTable.INSTANCE.active.eq((Object)true);
            predicate = predicate.and((Expression)AddressTable.INSTANCE.classNameId.eq((Object)this._classNameLocalService.getClassNameId(className)).and((Expression)AddressTable.INSTANCE.classPK.eq((Object)classPK)));
            predicate = predicate.and((Expression)listTypeFilterPredicate.withParentheses());
            Predicate groupFilterPredicate = CountryTable.INSTANCE.groupFilterEnabled.eq((Object)false);
            Predicate channelFilterPredicate = CountryTable.INSTANCE.groupFilterEnabled.eq((Object)true);
            channelFilterPredicate = channelFilterPredicate.and((Expression)CommerceChannelRelTable.INSTANCE.classNameId.eq((Object)this._classNameLocalService.getClassNameId(Country.class)));
            channelFilterPredicate = channelFilterPredicate.and((Expression)CommerceChannelRelTable.INSTANCE.commerceChannelId.eq((Object)commerceChannelId));
            groupFilterPredicate = groupFilterPredicate.or((Expression)channelFilterPredicate.withParentheses());
            predicate = predicate.and((Expression)groupFilterPredicate.withParentheses());
            if (billingAllowed) {
                predicate = predicate.and((Expression)CountryTable.INSTANCE.billingAllowed.eq((Object)true));
            }
            if (shippingAllowed) {
                predicate = predicate.and((Expression)CountryTable.INSTANCE.shippingAllowed.eq((Object)true));
            }
            return predicate;
        });
    }

    private void _validate(String name, String street1, String city, String zip, long countryId, int type) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new CommerceAddressNameException();
        }
        if (Validator.isNull((String)street1)) {
            throw new CommerceAddressStreetException();
        }
        if (Validator.isNull((String)city)) {
            throw new CommerceAddressCityException();
        }
        if (Validator.isNull((String)zip)) {
            throw new CommerceAddressZipException();
        }
        if (countryId <= 0L) {
            throw new CommerceAddressCountryException();
        }
        if (!ArrayUtil.contains((int[])CommerceAddressConstants.ADDRESS_TYPES, (int)type)) {
            throw new CommerceAddressTypeException();
        }
    }
}

