/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderPayment;
import com.liferay.commerce.service.base.CommerceOrderPaymentLocalServiceBaseImpl;
import com.liferay.commerce.service.persistence.CommerceOrderPersistence;
import com.liferay.commerce.util.comparator.CommerceOrderPaymentCreateDateComparator;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.model.CommerceOrderPayment"}, service={AopService.class})
public class CommerceOrderPaymentLocalServiceImpl
extends CommerceOrderPaymentLocalServiceBaseImpl {
    @Reference
    private CommerceOrderPersistence _commerceOrderPersistence;
    @Reference
    private UserLocalService _userLocalService;

    public CommerceOrderPayment addCommerceOrderPayment(long commerceOrderId, int status, String result) throws PortalException {
        CommerceOrder commerceOrder = this._commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        User user = this._userLocalService.getUser(commerceOrder.getUserId());
        return this._getCommerceOrderPayment(status, result, commerceOrder, user);
    }

    public CommerceOrderPayment addCommerceOrderPayment(long commerceOrderId, int status, String content, ServiceContext serviceContext) throws PortalException {
        return this._getCommerceOrderPayment(status, content, this._commerceOrderPersistence.findByPrimaryKey(commerceOrderId), this._userLocalService.getUser(serviceContext.getUserId()));
    }

    public void deleteCommerceOrderPayments(long commerceOrderId) {
        this.commerceOrderPaymentPersistence.removeByCommerceOrderId(commerceOrderId);
    }

    public CommerceOrderPayment fetchLatestCommerceOrderPayment(long commerceOrderId) throws PortalException {
        return this.commerceOrderPaymentPersistence.fetchByCommerceOrderId_First(commerceOrderId, (OrderByComparator)new CommerceOrderPaymentCreateDateComparator());
    }

    public List<CommerceOrderPayment> getCommerceOrderPayments(long commerceOrderId, int start, int end, OrderByComparator<CommerceOrderPayment> orderByComparator) {
        return this.commerceOrderPaymentPersistence.findByCommerceOrderId(commerceOrderId, start, end, orderByComparator);
    }

    public int getCommerceOrderPaymentsCount(long commerceOrderId) {
        return this.commerceOrderPaymentPersistence.countByCommerceOrderId(commerceOrderId);
    }

    private CommerceOrderPayment _getCommerceOrderPayment(int status, String result, CommerceOrder commerceOrder, User user) {
        long commerceOrderPaymentId = this.counterLocalService.increment();
        CommerceOrderPayment commerceOrderPayment = this.commerceOrderPaymentPersistence.create(commerceOrderPaymentId);
        commerceOrderPayment.setGroupId(commerceOrder.getGroupId());
        commerceOrderPayment.setCompanyId(user.getCompanyId());
        commerceOrderPayment.setUserId(user.getUserId());
        commerceOrderPayment.setUserName(user.getFullName());
        commerceOrderPayment.setCommerceOrderId(commerceOrder.getCommerceOrderId());
        commerceOrderPayment.setCommercePaymentMethodKey(commerceOrder.getCommercePaymentMethodKey());
        commerceOrderPayment.setContent(result);
        commerceOrderPayment.setStatus(status);
        return (CommerceOrderPayment)this.commerceOrderPaymentPersistence.update((BaseModel)commerceOrderPayment);
    }
}

