/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.service.base.CommerceOrderTypeServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=commerce", "json.web.service.context.path=CommerceOrderType"}, service={AopService.class})
public class CommerceOrderTypeServiceImpl
extends CommerceOrderTypeServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.commerce.model.CommerceOrderType)")
    private ModelResourcePermission<CommerceOrderType> _commerceOrderTypeModelResourcePermission;

    public CommerceOrderType addCommerceOrderType(String externalReferenceCode, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int displayOrder, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        PortletResourcePermission portletResourcePermission = this._commerceOrderTypeModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "ADD_COMMERCE_ORDER_TYPE");
        return this.commerceOrderTypeLocalService.addCommerceOrderType(externalReferenceCode, this.getUserId(), nameMap, descriptionMap, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, displayOrder, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public CommerceOrderType deleteCommerceOrderType(long commerceOrderTypeId) throws PortalException {
        this._commerceOrderTypeModelResourcePermission.check(this.getPermissionChecker(), commerceOrderTypeId, "DELETE");
        return this.commerceOrderTypeLocalService.deleteCommerceOrderType(commerceOrderTypeId);
    }

    public CommerceOrderType fetchByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        CommerceOrderType commerceOrderType = this.commerceOrderTypeLocalService.fetchByExternalReferenceCode(externalReferenceCode, companyId);
        if (commerceOrderType != null) {
            this._commerceOrderTypeModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrderType, "VIEW");
        }
        return commerceOrderType;
    }

    public CommerceOrderType fetchCommerceOrderType(long commerceOrderTypeId) throws PortalException {
        CommerceOrderType commerceOrderType = this.commerceOrderTypeLocalService.fetchCommerceOrderType(commerceOrderTypeId);
        if (commerceOrderType != null) {
            this._commerceOrderTypeModelResourcePermission.check(this.getPermissionChecker(), commerceOrderTypeId, "VIEW");
        }
        return commerceOrderType;
    }

    public CommerceOrderType getCommerceOrderType(long commerceOrderTypeId) throws PortalException {
        this._commerceOrderTypeModelResourcePermission.check(this.getPermissionChecker(), commerceOrderTypeId, "VIEW");
        return this.commerceOrderTypeLocalService.getCommerceOrderType(commerceOrderTypeId);
    }

    public List<CommerceOrderType> getCommerceOrderTypes(String className, long classPK, boolean active, int start, int end) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        return this.commerceOrderTypeLocalService.getCommerceOrderTypes(permissionChecker.getCompanyId(), className, classPK, active, start, end);
    }

    public int getCommerceOrderTypesCount(String className, long classPK, boolean active) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        return this.commerceOrderTypeLocalService.getCommerceOrderTypesCount(permissionChecker.getCompanyId(), className, classPK, active);
    }

    public CommerceOrderType updateCommerceOrderType(String externalReferenceCode, long commerceOrderTypeId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int displayOrder, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        this._commerceOrderTypeModelResourcePermission.check(this.getPermissionChecker(), commerceOrderTypeId, "UPDATE");
        return this.commerceOrderTypeLocalService.updateCommerceOrderType(externalReferenceCode, this.getUserId(), commerceOrderTypeId, nameMap, descriptionMap, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, displayOrder, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public CommerceOrderType updateCommerceOrderTypeExternalReferenceCode(String externalReferenceCode, long commerceOrderTypeId) throws PortalException {
        this._commerceOrderTypeModelResourcePermission.check(this.getPermissionChecker(), commerceOrderTypeId, "UPDATE");
        return this.commerceOrderTypeLocalService.updateCommerceOrderTypeExternalReferenceCode(externalReferenceCode, commerceOrderTypeId);
    }
}

