/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelService;
import com.liferay.commerce.service.base.CommerceShipmentServiceBaseImpl;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=commerce", "json.web.service.context.path=CommerceShipment"}, service={AopService.class})
public class CommerceShipmentServiceImpl
extends CommerceShipmentServiceBaseImpl {
    @Reference
    private CommerceChannelService _commerceChannelService;
    @Reference(target="(resource.name=com.liferay.commerce.shipment)")
    private PortletResourcePermission _portletResourcePermission;

    public CommerceShipment addCommerceShipment(long commerceOrderId, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.addCommerceShipment(commerceOrderId, serviceContext);
    }

    public CommerceShipment addCommerceShipment(String externalReferenceCode, long groupId, long commerceAccountId, long commerceAddressId, long commerceShippingMethodId, String commerceShippingOptionName, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.addCommerceShipment(externalReferenceCode, groupId, commerceAccountId, commerceAddressId, commerceShippingMethodId, commerceShippingOptionName, serviceContext);
    }

    @Deprecated
    public void deleteCommerceShipment(long commerceShipmentId) throws PortalException {
        this.deleteCommerceShipment(commerceShipmentId, false);
    }

    public void deleteCommerceShipment(long commerceShipmentId, boolean restoreStockQuantity) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        this.commerceShipmentLocalService.deleteCommerceShipment(commerceShipment, restoreStockQuantity);
    }

    public CommerceShipment fetchCommerceShipmentByExternalReferenceCode(long companyId, String externalReferenceCode) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.fetchCommerceShipmentByExternalReferenceCode(externalReferenceCode, companyId);
    }

    public CommerceShipment getCommerceShipment(long commerceShipmentId) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.getCommerceShipment(commerceShipmentId);
    }

    public List<CommerceShipment> getCommerceShipments(long companyId, int status, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        List commerceChannels = this._commerceChannelService.search(companyId);
        if (commerceChannels.isEmpty()) {
            return Collections.emptyList();
        }
        return this.commerceShipmentLocalService.getCommerceShipments(TransformUtil.transformToLongArray((Collection)commerceChannels, CommerceChannel::getGroupId), status, start, end, orderByComparator);
    }

    public List<CommerceShipment> getCommerceShipments(long companyId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        List commerceChannels = this._commerceChannelService.search(companyId);
        if (commerceChannels.isEmpty()) {
            return Collections.emptyList();
        }
        return this.commerceShipmentLocalService.getCommerceShipments(TransformUtil.transformToLongArray((Collection)commerceChannels, CommerceChannel::getGroupId), start, end, orderByComparator);
    }

    public List<CommerceShipment> getCommerceShipments(long companyId, long commerceAddressId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        List commerceChannels = this._commerceChannelService.search(companyId);
        if (commerceChannels.isEmpty()) {
            return Collections.emptyList();
        }
        return this.commerceShipmentLocalService.getCommerceShipments(TransformUtil.transformToLongArray((Collection)commerceChannels, CommerceChannel::getGroupId), commerceAddressId, start, end, orderByComparator);
    }

    public List<CommerceShipment> getCommerceShipments(long companyId, long[] groupIds, long[] commerceAccountIds, String keywords, int[] shipmentStatuses, boolean excludeShipmentStatus, int start, int end) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.getCommerceShipments(companyId, groupIds, commerceAccountIds, keywords, shipmentStatuses, excludeShipmentStatus, start, end);
    }

    public List<CommerceShipment> getCommerceShipmentsByOrderId(long commerceOrderId, int start, int end) {
        return this.commerceShipmentLocalService.getCommerceShipments(commerceOrderId, start, end);
    }

    public int getCommerceShipmentsCount(long companyId) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        List commerceChannels = this._commerceChannelService.search(companyId);
        if (commerceChannels.isEmpty()) {
            return 0;
        }
        return this.commerceShipmentLocalService.getCommerceShipmentsCount(TransformUtil.transformToLongArray((Collection)commerceChannels, CommerceChannel::getGroupId));
    }

    public int getCommerceShipmentsCount(long companyId, int status) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        List commerceChannels = this._commerceChannelService.search(companyId);
        if (commerceChannels.isEmpty()) {
            return 0;
        }
        return this.commerceShipmentLocalService.getCommerceShipmentsCount(TransformUtil.transformToLongArray((Collection)commerceChannels, CommerceChannel::getGroupId), status);
    }

    public int getCommerceShipmentsCount(long companyId, long commerceAddressId) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        List commerceChannels = this._commerceChannelService.search(companyId);
        if (commerceChannels.isEmpty()) {
            return 0;
        }
        return this.commerceShipmentLocalService.getCommerceShipmentsCount(TransformUtil.transformToLongArray((Collection)commerceChannels, CommerceChannel::getGroupId), commerceAddressId);
    }

    public int getCommerceShipmentsCount(long companyId, long[] groupIds, long[] commerceAccountIds, String keywords, int[] shipmentStatuses, boolean excludeShipmentStatus) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.getCommerceShipmentsCount(companyId, groupIds, commerceAccountIds, keywords, shipmentStatuses, excludeShipmentStatus);
    }

    public int getCommerceShipmentsCountByOrderId(long commerceOrderId) {
        return this.commerceShipmentLocalService.getCommerceShipmentsCount(commerceOrderId);
    }

    public CommerceShipment reprocessCommerceShipment(long commerceShipmentId) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.reprocessCommerceShipment(commerceShipmentId);
    }

    @Deprecated
    public CommerceShipment updateAddress(long commerceShipmentId, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber) throws PortalException {
        return this.updateAddress(commerceShipmentId, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, null);
    }

    public CommerceShipment updateAddress(long commerceShipmentId, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.updateAddress(commerceShipmentId, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, serviceContext);
    }

    public CommerceShipment updateCarrierDetails(long commerceShipmentId, long commerceShippingMethodId, String carrier, String trackingNumber, String trackingURL) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.updateCarrierDetails(commerceShipmentId, commerceShippingMethodId, carrier, trackingNumber, trackingURL);
    }

    public CommerceShipment updateCommerceShipment(CommerceShipment commerceShipment) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.updateCommerceShipment(commerceShipment);
    }

    public CommerceShipment updateCommerceShipment(long commerceShipmentId, long commerceShippingMethodId, String carrier, int expectedDateMonth, int expectedDateDay, int expectedDateYear, int expectedDateHour, int expectedDateMinute, int shippingDateMonth, int shippingDateDay, int shippingDateYear, int shippingDateHour, int shippingDateMinute, String trackingNumber, String trackingURL, int status, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.updateCommerceShipment(commerceShipmentId, commerceShippingMethodId, carrier, expectedDateMonth, expectedDateDay, expectedDateYear, expectedDateHour, expectedDateMinute, shippingDateMonth, shippingDateDay, shippingDateYear, shippingDateHour, shippingDateMinute, trackingNumber, trackingURL, status, serviceContext);
    }

    public CommerceShipment updateCommerceShipment(long commerceShipmentId, long commerceShippingMethodId, String carrier, int expectedDateMonth, int expectedDateDay, int expectedDateYear, int expectedDateHour, int expectedDateMinute, int shippingDateMonth, int shippingDateDay, int shippingDateYear, int shippingDateHour, int shippingDateMinute, String trackingNumber, String trackingURL, int status, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.updateCommerceShipment(commerceShipmentId, commerceShippingMethodId, carrier, expectedDateMonth, expectedDateDay, expectedDateYear, expectedDateHour, expectedDateMinute, shippingDateMonth, shippingDateDay, shippingDateYear, shippingDateHour, shippingDateMinute, trackingNumber, trackingURL, status, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, serviceContext);
    }

    public CommerceShipment updateExpectedDate(long commerceShipmentId, int expectedDateMonth, int expectedDateDay, int expectedDateYear, int expectedDateHour, int expectedDateMinute) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.updateExpectedDate(commerceShipmentId, expectedDateMonth, expectedDateDay, expectedDateYear, expectedDateHour, expectedDateMinute);
    }

    public CommerceShipment updateExternalReferenceCode(long commerceShipmentId, String externalReferenceCode) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.updateExternalReferenceCode(commerceShipmentId, externalReferenceCode);
    }

    public CommerceShipment updateShippingDate(long commerceShipmentId, int shippingDateMonth, int shippingDateDay, int shippingDateYear, int shippingDateHour, int shippingDateMinute) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.updateShippingDate(commerceShipmentId, shippingDateMonth, shippingDateDay, shippingDateYear, shippingDateHour, shippingDateMinute);
    }

    public CommerceShipment updateStatus(long commerceShipmentId, int status) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.updateStatus(commerceShipmentId, status);
    }
}

