/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.exception.CommerceSubscriptionEntryNextIterationDateException;
import com.liferay.commerce.exception.CommerceSubscriptionEntrySubscriptionStatusException;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceSubscriptionEntry;
import com.liferay.commerce.notification.util.CommerceNotificationHelper;
import com.liferay.commerce.product.util.CPSubscriptionType;
import com.liferay.commerce.product.util.CPSubscriptionTypeRegistry;
import com.liferay.commerce.service.base.CommerceSubscriptionEntryLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUID;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.model.CommerceSubscriptionEntry"}, service={AopService.class})
public class CommerceSubscriptionEntryLocalServiceImpl
extends CommerceSubscriptionEntryLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId", "groupId", "uid"};
    private static final Log _log = LogFactoryUtil.getLog(CommerceSubscriptionEntryLocalServiceImpl.class);
    @Reference
    private CommerceNotificationHelper _commerceNotificationHelper;
    @Reference
    private CPSubscriptionTypeRegistry _cpSubscriptionTypeRegistry;
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private Portal _portal;
    @Reference
    private PortalUUID _portalUUID;
    @Reference
    private UserLocalService _userLocalService;

    @Deprecated
    public CommerceSubscriptionEntry addCommerceSubscriptionEntry(long userId, long groupId, long commerceOrderItemId, int subscriptionLength, String subscriptionType, long maxSubscriptionCycles, UnicodeProperties subscriptionTypeSettingsUnicodeProperties) throws PortalException {
        return this.commerceSubscriptionEntryLocalService.addCommerceSubscriptionEntry(userId, groupId, commerceOrderItemId, subscriptionLength, subscriptionType, maxSubscriptionCycles, subscriptionTypeSettingsUnicodeProperties, 0, null, 0L, null);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceSubscriptionEntry addCommerceSubscriptionEntry(long userId, long groupId, long commerceOrderItemId, int subscriptionLength, String subscriptionType, long maxSubscriptionCycles, UnicodeProperties subscriptionTypeSettingsUnicodeProperties, int deliverySubscriptionLength, String deliverySubscriptionType, long deliveryMaxSubscriptionCycles, UnicodeProperties deliverySubscriptionTypeSettingsUnicodeProperties) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        long commerceSubscriptionEntryId = this.counterLocalService.increment();
        CommerceSubscriptionEntry commerceSubscriptionEntry = this.commerceSubscriptionEntryPersistence.create(commerceSubscriptionEntryId);
        commerceSubscriptionEntry.setUuid(this._portalUUID.generate());
        commerceSubscriptionEntry.setGroupId(groupId);
        commerceSubscriptionEntry.setCompanyId(user.getCompanyId());
        commerceSubscriptionEntry.setUserId(user.getUserId());
        commerceSubscriptionEntry.setUserName(user.getFullName());
        commerceSubscriptionEntry.setCommerceOrderItemId(commerceOrderItemId);
        commerceSubscriptionEntry.setSubscriptionLength(subscriptionLength);
        commerceSubscriptionEntry.setSubscriptionType(subscriptionType);
        commerceSubscriptionEntry.setCurrentCycle(1L);
        commerceSubscriptionEntry.setMaxSubscriptionCycles(maxSubscriptionCycles);
        commerceSubscriptionEntry.setLastIterationDate(new Date());
        commerceSubscriptionEntry.setDeliverySubscriptionLength(deliverySubscriptionLength);
        commerceSubscriptionEntry.setDeliverySubscriptionType(deliverySubscriptionType);
        commerceSubscriptionEntry.setDeliveryCurrentCycle(1L);
        commerceSubscriptionEntry.setDeliveryMaxSubscriptionCycles(deliveryMaxSubscriptionCycles);
        commerceSubscriptionEntry.setDeliveryLastIterationDate(new Date());
        CPSubscriptionType cpSubscriptionType = this._cpSubscriptionTypeRegistry.getCPSubscriptionType(subscriptionType);
        if (cpSubscriptionType != null) {
            commerceSubscriptionEntry.setSubscriptionStatus(0);
            commerceSubscriptionEntry.setNextIterationDate(cpSubscriptionType.getSubscriptionNextIterationDate(user.getTimeZone(), subscriptionLength, subscriptionTypeSettingsUnicodeProperties, null));
            commerceSubscriptionEntry.setStartDate(cpSubscriptionType.getSubscriptionStartDate(user.getTimeZone(), subscriptionTypeSettingsUnicodeProperties));
            commerceSubscriptionEntry.setSubscriptionTypeSettingsUnicodeProperties(cpSubscriptionType.getSubscriptionTypeSettingsUnicodeProperties(subscriptionTypeSettingsUnicodeProperties));
        } else {
            commerceSubscriptionEntry.setSubscriptionStatus(-1);
            commerceSubscriptionEntry.setSubscriptionTypeSettingsUnicodeProperties(subscriptionTypeSettingsUnicodeProperties);
        }
        CPSubscriptionType deliveryCPSubscriptionType = this._cpSubscriptionTypeRegistry.getCPSubscriptionType(deliverySubscriptionType);
        if (deliveryCPSubscriptionType != null) {
            commerceSubscriptionEntry.setDeliverySubscriptionStatus(0);
            commerceSubscriptionEntry.setDeliveryNextIterationDate(deliveryCPSubscriptionType.getSubscriptionNextIterationDate(user.getTimeZone(), deliverySubscriptionLength, deliverySubscriptionTypeSettingsUnicodeProperties, null));
            commerceSubscriptionEntry.setDeliveryStartDate(deliveryCPSubscriptionType.getSubscriptionStartDate(user.getTimeZone(), deliverySubscriptionTypeSettingsUnicodeProperties));
            commerceSubscriptionEntry.setDeliverySubscriptionTypeSettingsUnicodeProperties(deliveryCPSubscriptionType.getDeliverySubscriptionTypeSettingsUnicodeProperties(deliverySubscriptionTypeSettingsUnicodeProperties));
        } else {
            commerceSubscriptionEntry.setDeliverySubscriptionStatus(-1);
            commerceSubscriptionEntry.setDeliverySubscriptionTypeSettingsUnicodeProperties(deliverySubscriptionTypeSettingsUnicodeProperties);
        }
        return (CommerceSubscriptionEntry)this.commerceSubscriptionEntryPersistence.update((BaseModel)commerceSubscriptionEntry);
    }

    public void deleteCommerceSubscriptionEntries(long groupId) {
        List commerceSubscriptionEntries = this.commerceSubscriptionEntryPersistence.findByGroupId(groupId);
        for (CommerceSubscriptionEntry commerceSubscriptionEntry : commerceSubscriptionEntries) {
            this.commerceSubscriptionEntryLocalService.deleteCommerceSubscriptionEntry(commerceSubscriptionEntry);
        }
    }

    public CommerceSubscriptionEntry fetchCommerceSubscriptionEntryByCommerceOrderItemId(long commerceOrderItemId) {
        return this.commerceSubscriptionEntryPersistence.fetchByCommerceOrderItemId(commerceOrderItemId);
    }

    public List<CommerceSubscriptionEntry> getActiveCommerceSubscriptionEntries() {
        return this.commerceSubscriptionEntryPersistence.findBySubscriptionStatus(0);
    }

    public List<CommerceSubscriptionEntry> getActiveCommerceSubscriptionEntries(long commerceAccountId) {
        return this.commerceSubscriptionEntryFinder.findByA_S(commerceAccountId, 0L);
    }

    public List<CommerceSubscriptionEntry> getCommerceDeliverySubscriptionEntriesToRenew() {
        return this.commerceSubscriptionEntryFinder.findByDeliveryNextIterationDate(new Date());
    }

    @Deprecated
    public List<CommerceSubscriptionEntry> getCommerceSubscriptionEntries(long companyId, long userId, int start, int end, OrderByComparator<CommerceSubscriptionEntry> orderByComparator) {
        return this.commerceSubscriptionEntryPersistence.findByC_U(companyId, userId, start, end, orderByComparator);
    }

    public List<CommerceSubscriptionEntry> getCommerceSubscriptionEntries(long companyId, long groupId, long userId, int start, int end, OrderByComparator<CommerceSubscriptionEntry> orderByComparator) {
        return this.commerceSubscriptionEntryPersistence.findByG_C_U(groupId, companyId, userId, start, end, orderByComparator);
    }

    @Deprecated
    public int getCommerceSubscriptionEntriesCount(long companyId, long userId) {
        return this.commerceSubscriptionEntryPersistence.countByC_U(companyId, userId);
    }

    public int getCommerceSubscriptionEntriesCount(long companyId, long groupId, long userId) {
        return this.commerceSubscriptionEntryPersistence.countByG_C_U(groupId, companyId, userId);
    }

    public List<CommerceSubscriptionEntry> getCommerceSubscriptionEntriesToRenew() {
        return this.commerceSubscriptionEntryFinder.findByNextIterationDate(new Date());
    }

    public CommerceSubscriptionEntry incrementCommerceDeliverySubscriptionEntryCycle(long commerceSubscriptionEntryId) throws PortalException {
        CommerceSubscriptionEntry commerceSubscriptionEntry = this.commerceSubscriptionEntryPersistence.findByPrimaryKey(commerceSubscriptionEntryId);
        CPSubscriptionType cpSubscriptionType = this._cpSubscriptionTypeRegistry.getCPSubscriptionType(commerceSubscriptionEntry.getDeliverySubscriptionType());
        if (cpSubscriptionType == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("No subscription type found for subscription entry " + commerceSubscriptionEntryId));
            }
            return commerceSubscriptionEntry;
        }
        long currentSubscriptionCycle = commerceSubscriptionEntry.getDeliveryCurrentCycle();
        commerceSubscriptionEntry.setDeliveryCurrentCycle(currentSubscriptionCycle + 1L);
        User user = this._userLocalService.getUser(commerceSubscriptionEntry.getUserId());
        commerceSubscriptionEntry.setDeliveryLastIterationDate(commerceSubscriptionEntry.getDeliveryNextIterationDate());
        Date subscriptionNextIterationDate = cpSubscriptionType.getSubscriptionNextIterationDate(user.getTimeZone(), commerceSubscriptionEntry.getDeliverySubscriptionLength(), commerceSubscriptionEntry.getDeliverySubscriptionTypeSettingsUnicodeProperties(), commerceSubscriptionEntry.getDeliveryNextIterationDate());
        commerceSubscriptionEntry.setDeliveryNextIterationDate(subscriptionNextIterationDate);
        CommerceSubscriptionEntry updatedSubscriptionEntry = (CommerceSubscriptionEntry)this.commerceSubscriptionEntryPersistence.update((BaseModel)commerceSubscriptionEntry);
        CommerceOrderItem commerceOrderItem = commerceSubscriptionEntry.fetchCommerceOrderItem();
        if (commerceOrderItem != null) {
            CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
            this._commerceNotificationHelper.sendNotifications(commerceOrder.getGroupId(), commerceOrder.getUserId(), "subscription-renewed", (Object)updatedSubscriptionEntry);
        }
        return updatedSubscriptionEntry;
    }

    public CommerceSubscriptionEntry incrementCommerceSubscriptionEntryCycle(long commerceSubscriptionEntryId) throws PortalException {
        CommerceSubscriptionEntry commerceSubscriptionEntry = this.commerceSubscriptionEntryPersistence.findByPrimaryKey(commerceSubscriptionEntryId);
        CPSubscriptionType cpSubscriptionType = this._cpSubscriptionTypeRegistry.getCPSubscriptionType(commerceSubscriptionEntry.getSubscriptionType());
        if (cpSubscriptionType == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("No subscription type found for subscription entry " + commerceSubscriptionEntryId));
            }
            return commerceSubscriptionEntry;
        }
        long currentSubscriptionCycle = commerceSubscriptionEntry.getCurrentCycle();
        commerceSubscriptionEntry.setCurrentCycle(currentSubscriptionCycle + 1L);
        User user = this._userLocalService.getUser(commerceSubscriptionEntry.getUserId());
        commerceSubscriptionEntry.setLastIterationDate(commerceSubscriptionEntry.getNextIterationDate());
        Date subscriptionNextIterationDate = cpSubscriptionType.getSubscriptionNextIterationDate(user.getTimeZone(), commerceSubscriptionEntry.getSubscriptionLength(), commerceSubscriptionEntry.getSubscriptionTypeSettingsUnicodeProperties(), commerceSubscriptionEntry.getNextIterationDate());
        commerceSubscriptionEntry.setNextIterationDate(subscriptionNextIterationDate);
        CommerceSubscriptionEntry updatedSubscriptionEntry = (CommerceSubscriptionEntry)this.commerceSubscriptionEntryPersistence.update((BaseModel)commerceSubscriptionEntry);
        CommerceOrderItem commerceOrderItem = commerceSubscriptionEntry.fetchCommerceOrderItem();
        if (commerceOrderItem != null) {
            CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
            this._commerceNotificationHelper.sendNotifications(commerceOrder.getGroupId(), commerceOrder.getUserId(), "subscription-renewed", (Object)updatedSubscriptionEntry);
        }
        return updatedSubscriptionEntry;
    }

    @Deprecated
    public BaseModelSearchResult<CommerceSubscriptionEntry> searchCommerceSubscriptionEntries(long companyId, Long maxSubscriptionCycles, Integer subscriptionStatus, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this._buildSearchContext(companyId, null, maxSubscriptionCycles, subscriptionStatus, keywords, start, end, sort);
        return this._searchCommerceSubscriptionEntries(searchContext);
    }

    public BaseModelSearchResult<CommerceSubscriptionEntry> searchCommerceSubscriptionEntries(long companyId, long[] groupIds, Long maxSubscriptionCycles, Integer subscriptionStatus, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this._buildSearchContext(companyId, groupIds, maxSubscriptionCycles, subscriptionStatus, keywords, start, end, sort);
        return this._searchCommerceSubscriptionEntries(searchContext);
    }

    @Deprecated
    public CommerceSubscriptionEntry updateCommerceSubscriptionEntry(long commerceSubscriptionEntryId, int subscriptionLength, String subscriptionType, UnicodeProperties subscriptionTypeSettingsUnicodeProperties, long maxSubscriptionCycles, int subscriptionStatus, int nextIterationDateMonth, int nextIterationDateDay, int nextIterationDateYear, int nextIterationDateHour, int nextIterationDateMinute) throws PortalException {
        return this.commerceSubscriptionEntryLocalService.updateCommerceSubscriptionEntry(commerceSubscriptionEntryId, subscriptionLength, subscriptionType, subscriptionTypeSettingsUnicodeProperties, maxSubscriptionCycles, subscriptionStatus, nextIterationDateMonth, nextIterationDateDay, nextIterationDateYear, nextIterationDateHour, nextIterationDateMinute, 0, null, null, 0L, -1, 0, 0, 0, 0, 0);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceSubscriptionEntry updateCommerceSubscriptionEntry(long commerceSubscriptionEntryId, int subscriptionLength, String subscriptionType, UnicodeProperties subscriptionTypeSettingsUnicodeProperties, long maxSubscriptionCycles, int subscriptionStatus, int nextIterationDateMonth, int nextIterationDateDay, int nextIterationDateYear, int nextIterationDateHour, int nextIterationDateMinute, int deliverySubscriptionLength, String deliverySubscriptionType, UnicodeProperties deliverySubscriptionTypeSettingsUnicodeProperties, long deliveryMaxSubscriptionCycles, int deliverySubscriptionStatus, int deliveryNextIterationDateMonth, int deliveryNextIterationDateDay, int deliveryNextIterationDateYear, int deliveryNextIterationDateHour, int deliveryNextIterationDateMinute) throws PortalException {
        CPSubscriptionType deliveryCPSubscriptionType;
        CommerceSubscriptionEntry commerceSubscriptionEntry = this.commerceSubscriptionEntryPersistence.findByPrimaryKey(commerceSubscriptionEntryId);
        User user = this._userLocalService.getUser(commerceSubscriptionEntry.getUserId());
        this._validateSubscriptionStatus(subscriptionStatus, commerceSubscriptionEntry.getSubscriptionStatus());
        this._validateSubscriptionStatus(deliverySubscriptionStatus, commerceSubscriptionEntry.getDeliverySubscriptionStatus());
        CPSubscriptionType cpSubscriptionType = this._cpSubscriptionTypeRegistry.getCPSubscriptionType(subscriptionType);
        if (cpSubscriptionType != null) {
            subscriptionTypeSettingsUnicodeProperties = cpSubscriptionType.getSubscriptionTypeSettingsUnicodeProperties(subscriptionTypeSettingsUnicodeProperties);
        }
        if ((deliveryCPSubscriptionType = this._cpSubscriptionTypeRegistry.getCPSubscriptionType(deliverySubscriptionType)) != null) {
            deliverySubscriptionTypeSettingsUnicodeProperties = deliveryCPSubscriptionType.getDeliverySubscriptionTypeSettingsUnicodeProperties(deliverySubscriptionTypeSettingsUnicodeProperties);
        }
        commerceSubscriptionEntry.setSubscriptionLength(subscriptionLength);
        commerceSubscriptionEntry.setSubscriptionType(subscriptionType);
        commerceSubscriptionEntry.setSubscriptionTypeSettingsUnicodeProperties(subscriptionTypeSettingsUnicodeProperties);
        commerceSubscriptionEntry.setMaxSubscriptionCycles(maxSubscriptionCycles);
        commerceSubscriptionEntry.setSubscriptionStatus(subscriptionStatus);
        if (subscriptionStatus != -1) {
            commerceSubscriptionEntry.setNextIterationDate(this._portal.getDate(nextIterationDateMonth, nextIterationDateDay, nextIterationDateYear, nextIterationDateHour, nextIterationDateMinute, user.getTimeZone(), CommerceSubscriptionEntryNextIterationDateException.class));
        }
        commerceSubscriptionEntry.setDeliverySubscriptionLength(deliverySubscriptionLength);
        commerceSubscriptionEntry.setDeliverySubscriptionType(deliverySubscriptionType);
        commerceSubscriptionEntry.setDeliverySubscriptionTypeSettingsUnicodeProperties(deliverySubscriptionTypeSettingsUnicodeProperties);
        commerceSubscriptionEntry.setDeliveryMaxSubscriptionCycles(deliveryMaxSubscriptionCycles);
        commerceSubscriptionEntry.setDeliverySubscriptionStatus(deliverySubscriptionStatus);
        if (deliverySubscriptionStatus != -1) {
            commerceSubscriptionEntry.setDeliveryNextIterationDate(this._portal.getDate(deliveryNextIterationDateMonth, deliveryNextIterationDateDay, deliveryNextIterationDateYear, deliveryNextIterationDateHour, deliveryNextIterationDateMinute, user.getTimeZone(), CommerceSubscriptionEntryNextIterationDateException.class));
        }
        return (CommerceSubscriptionEntry)this.commerceSubscriptionEntryPersistence.update((BaseModel)commerceSubscriptionEntry);
    }

    @Deprecated
    public CommerceSubscriptionEntry updateCommerceSubscriptionEntryIterationDates(long commerceSubscriptionEntryId, Date lastIterationDate) throws PortalException {
        CommerceSubscriptionEntry commerceSubscriptionEntry = this.commerceSubscriptionEntryPersistence.findByPrimaryKey(commerceSubscriptionEntryId);
        CPSubscriptionType cpSubscriptionType = this._cpSubscriptionTypeRegistry.getCPSubscriptionType(commerceSubscriptionEntry.getSubscriptionType());
        User user = this._userLocalService.getUser(commerceSubscriptionEntry.getUserId());
        commerceSubscriptionEntry.setLastIterationDate(lastIterationDate);
        Date subscriptionNextIterationDate = cpSubscriptionType.getSubscriptionNextIterationDate(user.getTimeZone(), commerceSubscriptionEntry.getSubscriptionLength(), commerceSubscriptionEntry.getSubscriptionTypeSettingsUnicodeProperties(), lastIterationDate);
        commerceSubscriptionEntry.setNextIterationDate(subscriptionNextIterationDate);
        return (CommerceSubscriptionEntry)this.commerceSubscriptionEntryPersistence.update((BaseModel)commerceSubscriptionEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceSubscriptionEntry updateDeliverySubscriptionStatus(long commerceSubscriptionEntryId, int subscriptionStatus) throws PortalException {
        CommerceSubscriptionEntry commerceSubscriptionEntry = this.commerceSubscriptionEntryPersistence.findByPrimaryKey(commerceSubscriptionEntryId);
        this._validateSubscriptionStatus(subscriptionStatus, commerceSubscriptionEntry.getSubscriptionStatus());
        commerceSubscriptionEntry.setDeliverySubscriptionStatus(subscriptionStatus);
        this._sendSubscriptionStatusMessage(commerceSubscriptionEntryId, subscriptionStatus);
        return (CommerceSubscriptionEntry)this.commerceSubscriptionEntryPersistence.update((BaseModel)commerceSubscriptionEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceSubscriptionEntry updateSubscriptionStatus(long commerceSubscriptionEntryId, int subscriptionStatus) throws PortalException {
        CommerceSubscriptionEntry commerceSubscriptionEntry = this.commerceSubscriptionEntryPersistence.findByPrimaryKey(commerceSubscriptionEntryId);
        this._validateSubscriptionStatus(subscriptionStatus, commerceSubscriptionEntry.getSubscriptionStatus());
        commerceSubscriptionEntry.setSubscriptionStatus(subscriptionStatus);
        this._sendSubscriptionStatusMessage(commerceSubscriptionEntryId, subscriptionStatus);
        return (CommerceSubscriptionEntry)this.commerceSubscriptionEntryPersistence.update((BaseModel)commerceSubscriptionEntry);
    }

    private SearchContext _buildSearchContext(long companyId, long[] groupIds, Long maxSubscriptionCycles, Integer subscriptionStatus, String keywords, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"CPInstanceId", (Object)keywords).put((Object)"maxSubscriptionCycles", () -> maxSubscriptionCycles).put((Object)"sku", (Object)keywords).put((Object)"subscriptionStatus", () -> subscriptionStatus).put((Object)"entryClassPK", (Object)keywords).put((Object)"params", (Object)LinkedHashMapBuilder.put((Object)"keywords", (Object)keywords).build()).build());
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        if (groupIds != null && groupIds.length > 0) {
            searchContext.setGroupIds(groupIds);
        }
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    private List<CommerceSubscriptionEntry> _getCommerceSubscriptionEntries(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommerceSubscriptionEntry> commerceSubscriptionEntries = new ArrayList<CommerceSubscriptionEntry>(documents.size());
        for (Document document : documents) {
            long commerceSubscriptionEntryId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommerceSubscriptionEntry commerceSubscriptionEntry = this.fetchCommerceSubscriptionEntry(commerceSubscriptionEntryId);
            if (commerceSubscriptionEntry == null) {
                commerceSubscriptionEntries = null;
                Indexer indexer = this._indexerRegistry.getIndexer(CommerceSubscriptionEntry.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (commerceSubscriptionEntries == null) continue;
            commerceSubscriptionEntries.add(commerceSubscriptionEntry);
        }
        return commerceSubscriptionEntries;
    }

    private BaseModelSearchResult<CommerceSubscriptionEntry> _searchCommerceSubscriptionEntries(SearchContext searchContext) throws PortalException {
        Indexer indexer = this._indexerRegistry.nullSafeGetIndexer(CommerceSubscriptionEntry.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CommerceSubscriptionEntry> commerceSubscriptionEntries = this._getCommerceSubscriptionEntries(hits);
            if (commerceSubscriptionEntries == null) continue;
            return new BaseModelSearchResult(commerceSubscriptionEntries, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    private void _sendSubscriptionStatusMessage(long commerceSubscriptionEntryId, int subscriptionStatus) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            Message message = new Message();
            message.setPayload((Object)JSONUtil.put((String)"commerceSubscriptionEntryId", (Object)commerceSubscriptionEntryId).put("subscriptionStatus", subscriptionStatus));
            MessageBusUtil.sendMessage((String)"liferay/commerce_subscription_status", (Message)message);
            return null;
        });
    }

    private void _validateSubscriptionStatus(int subscriptionStatus, int oldSubscriptionStatus) throws PortalException {
        if (oldSubscriptionStatus == 1 || subscriptionStatus == -1 && oldSubscriptionStatus != 3) {
            return;
        }
        if (subscriptionStatus < oldSubscriptionStatus) {
            throw new CommerceSubscriptionEntrySubscriptionStatusException();
        }
    }
}

