/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order.term.contributor;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.order.CommerceDefinitionTermContributor;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"commerce.definition.term.contributor.key=BodyAndSubjectTerms", "commerce.notification.type.key=order-awaiting-shipment", "commerce.notification.type.key=order-completed", "commerce.notification.type.key=order-partially-shipped", "commerce.notification.type.key=order-placed", "commerce.notification.type.key=order-processing", "commerce.notification.type.key=order-shipped"}, service={CommerceDefinitionTermContributor.class})
public class CommerceOrderDefinitionTermContributor
implements CommerceDefinitionTermContributor {
    public static final String KEY = "BodyAndSubjectTerms";
    private static final String _ORDER_BILLING_ADDRESS = "[%ORDER_BILLING_ADDRESS%]";
    private static final String _ORDER_CREATOR = "[%ORDER_CREATOR%]";
    private static final String _ORDER_ID = "[%ORDER_ID%]";
    private static final String _ORDER_ITEMS = "[%ORDER_ITEMS%]";
    private static final String _ORDER_SHIPPING_ADDRESS = "[%ORDER_SHIPPING_ADDRESS%]";
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderDefinitionTermContributor.class);
    private static final Map<String, String> _commerceOrderDefinitionTermsMap = HashMapBuilder.put((Object)"[%ORDER_BILLING_ADDRESS%]", (Object)"order-billing-address-definition-term").put((Object)"[%ORDER_CREATOR%]", (Object)"order-creator-definition-term").put((Object)"[%ORDER_ID%]", (Object)"order-id-definition-term").put((Object)"[%ORDER_ITEMS%]", (Object)"order-items-definition-term").put((Object)"[%ORDER_SHIPPING_ADDRESS%]", (Object)"order-shipping-address-definition-term").build();
    @Reference
    private UserLocalService _userLocalService;

    public Map<String, String> getDefinitionTerms(Locale locale) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<String> terms = this.getTerms();
        for (String term : terms) {
            map.put(term, this.getLabel(term, locale));
        }
        return map;
    }

    public String getFilledTerm(String term, Object object, Locale locale) throws PortalException {
        if (!(object instanceof CommerceOrder)) {
            return term;
        }
        CommerceOrder commerceOrder = (CommerceOrder)object;
        if (term.equals(_ORDER_CREATOR)) {
            CommerceAccount commerceAccount = commerceOrder.getCommerceAccount();
            if (commerceAccount.getType() == 1) {
                User user = this._userLocalService.getUser(commerceAccount.getUserId());
                return user.getFullName(true, true);
            }
            return commerceAccount.getName();
        }
        if (term.equals(_ORDER_ID)) {
            return String.valueOf(commerceOrder.getCommerceOrderId());
        }
        if (term.equals(_ORDER_ITEMS)) {
            return this._getOrderItemsTerm(commerceOrder, locale);
        }
        if (term.equals(_ORDER_BILLING_ADDRESS)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Processing billing address term");
            }
            return this._formatAddressTerm(commerceOrder.getBillingAddress(), locale);
        }
        if (term.equals(_ORDER_SHIPPING_ADDRESS)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Processing shipping address term");
            }
            return this._formatAddressTerm(commerceOrder.getShippingAddress(), locale);
        }
        return term;
    }

    public String getLabel(String term, Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)_commerceOrderDefinitionTermsMap.get(term));
    }

    public List<String> getTerms() {
        return new ArrayList<String>(_commerceOrderDefinitionTermsMap.keySet());
    }

    private String _formatAddressTerm(CommerceAddress commerceAddress, Locale locale) {
        StringBundler addressSB;
        block9: {
            if (commerceAddress == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"The commerce address is null");
                }
                return "";
            }
            addressSB = new StringBundler(commerceAddress.getName());
            addressSB.append("<br/>");
            addressSB.append(commerceAddress.getStreet1());
            addressSB.append("<br/>");
            if (!Validator.isBlank((String)commerceAddress.getStreet2())) {
                addressSB.append(commerceAddress.getStreet2());
                addressSB.append("<br/>");
            }
            if (!Validator.isBlank((String)commerceAddress.getStreet3())) {
                addressSB.append(commerceAddress.getStreet3());
                addressSB.append("<br/>");
            }
            addressSB.append(commerceAddress.getCity());
            addressSB.append(", ");
            addressSB.append(commerceAddress.getZip());
            addressSB.append("<br/>");
            try {
                Country country;
                Region region = commerceAddress.getRegion();
                if (region != null) {
                    addressSB.append(region.getName());
                    addressSB.append(", ");
                }
                if ((country = commerceAddress.getCountry()) != null) {
                    addressSB.append(country.getTitle(locale));
                }
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block9;
                _log.debug((Object)"It was not possible to get either the country or region for this commerce address", (Throwable)portalException);
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Adding address term to the notification: " + addressSB.toString()));
        }
        return addressSB.toString();
    }

    private String _getOrderItemsTerm(CommerceOrder commerceOrder, Locale locale) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Processing order items term");
        }
        if (commerceOrder == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Trying to get the item list for an order without an order object!");
            }
            return "";
        }
        List orderItemsList = commerceOrder.getCommerceOrderItems();
        if (ListUtil.isEmpty((List)orderItemsList)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"This order has no linked order items to be included in the mail notification");
            }
            return "";
        }
        StringBundler orderItemsTableSB = new StringBundler("<table style=\"border: 1px solid black;\">");
        orderItemsTableSB.append("<tr><th style=\"border: 1px solid black;\">");
        orderItemsTableSB.append(LanguageUtil.get((Locale)locale, (String)"product-name"));
        orderItemsTableSB.append("</th>");
        orderItemsTableSB.append("<th style=\"border: 1px solid black;\">");
        orderItemsTableSB.append(LanguageUtil.get((Locale)locale, (String)"sku"));
        orderItemsTableSB.append("</th>");
        orderItemsTableSB.append("<th style=\"border: 1px solid black;\">");
        orderItemsTableSB.append(LanguageUtil.get((Locale)locale, (String)"quantity"));
        orderItemsTableSB.append("</th></tr>");
        for (CommerceOrderItem commerceOrderItem : orderItemsList) {
            orderItemsTableSB.append("<tr><td style=\"border: 1px solid black;\">");
            orderItemsTableSB.append(commerceOrderItem.getName(locale));
            orderItemsTableSB.append("</td><td style=\"border: 1px solid black;\">");
            orderItemsTableSB.append(commerceOrderItem.getSku());
            orderItemsTableSB.append("</td><td style=\"border: 1px solid black;\">");
            orderItemsTableSB.append(commerceOrderItem.getQuantity());
            orderItemsTableSB.append("</td></tr>");
        }
        orderItemsTableSB.append("</table>");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Order items table built successfully: " + orderItemsTableSB.toString()));
        }
        return orderItemsTableSB.toString();
    }
}

