/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CPDAvailabilityEstimate;
import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CommerceCatalogLocalService;
import com.liferay.commerce.service.base.CPDAvailabilityEstimateServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.spring.extender.service.ServiceReference;

public class CPDAvailabilityEstimateServiceImpl
extends CPDAvailabilityEstimateServiceBaseImpl {
    @ServiceReference(type=CommerceCatalogLocalService.class)
    protected CommerceCatalogLocalService commerceCatalogLocalService;
    @ServiceReference(type=CPDefinitionLocalService.class)
    protected CPDefinitionLocalService cpDefinitionLocalService;
    private static volatile ModelResourcePermission<CommerceCatalog> _commerceCatalogModelResourcePermission = ModelResourcePermissionFactory.getInstance(CPDAvailabilityEstimateServiceImpl.class, (String)"_commerceCatalogModelResourcePermission", CommerceCatalog.class);

    public CPDAvailabilityEstimate fetchCPDAvailabilityEstimateByCPDefinitionId(long cpDefinitionId) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "VIEW");
        return this.cpdAvailabilityEstimateLocalService.fetchCPDAvailabilityEstimateByCPDefinitionId(cpDefinitionId);
    }

    public CPDAvailabilityEstimate updateCPDAvailabilityEstimate(long cpdAvailabilityEstimateId, long cpDefinitionId, long commerceAvailabilityEstimateId, ServiceContext serviceContext) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "VIEW");
        return this.cpdAvailabilityEstimateLocalService.updateCPDAvailabilityEstimate(cpdAvailabilityEstimateId, cpDefinitionId, commerceAvailabilityEstimateId, serviceContext);
    }

    private void _checkCommerceCatalog(long cpDefinitionId, String actionId) throws PortalException {
        CPDefinition cpDefinition = this.cpDefinitionLocalService.fetchCPDefinition(cpDefinitionId);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException();
        }
        CommerceCatalog commerceCatalog = this.commerceCatalogLocalService.fetchCommerceCatalogByGroupId(cpDefinition.getGroupId());
        if (commerceCatalog == null) {
            throw new PrincipalException();
        }
        _commerceCatalogModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceCatalog, actionId);
    }
}

