/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.persistence.impl;

import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.model.impl.CommerceShipmentImpl;
import com.liferay.commerce.service.persistence.CommerceShipmentFinder;
import com.liferay.commerce.service.persistence.impl.CommerceShipmentFinderBaseImpl;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CommerceShipmentFinderImpl
extends CommerceShipmentFinderBaseImpl
implements CommerceShipmentFinder {
    public static final String COUNT_BY_COMMERCE_ORDER_ID = CommerceShipmentFinder.class.getName() + ".countByCommerceOrderId";
    public static final String FIND_BY_COMMERCE_ORDER_ID = CommerceShipmentFinder.class.getName() + ".findByCommerceOrderId";
    public static final String FIND_COMMERCE_SHIPMENT_STATUSES_BY_COMMERCE_ORDER_ID = CommerceShipmentFinder.class.getName() + ".findCommerceShipmentStatusesByCommerceOrderId";
    @ServiceReference(type=CustomSQL.class)
    private CustomSQL _customSQL;

    public int countByCommerceOrderId(long commerceOrderId) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_COMMERCE_ORDER_ID);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(commerceOrderId);
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CommerceShipment> findByCommerceOrderId(long commerceOrderId, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_COMMERCE_ORDER_ID);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("CommerceShipment", CommerceShipmentImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(commerceOrderId);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int[] findCommerceShipmentStatusesByCommerceOrderId(long commerceOrderId) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_COMMERCE_SHIPMENT_STATUSES_BY_COMMERCE_ORDER_ID);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(commerceOrderId);
            List commerceShipmentStatuses = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)-1, (int)-1);
            int[] nArray = ArrayUtil.toIntArray((Collection)commerceShipmentStatuses);
            return nArray;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }
}

