/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.shop.by.diagram.model.impl;

import com.liferay.commerce.shop.by.diagram.model.CSDiagramSetting;
import com.liferay.commerce.shop.by.diagram.service.CSDiagramSettingLocalServiceUtil;

/**
 * The extended model base implementation for the CSDiagramSetting service. Represents a row in the &quot;CSDiagramSetting&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CSDiagramSettingImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CSDiagramSettingImpl
 * @see CSDiagramSetting
 * @generated
 */
public abstract class CSDiagramSettingBaseImpl
	extends CSDiagramSettingModelImpl implements CSDiagramSetting {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a cs diagram setting model instance should use the <code>CSDiagramSetting</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CSDiagramSettingLocalServiceUtil.addCSDiagramSetting(this);
		}
		else {
			CSDiagramSettingLocalServiceUtil.updateCSDiagramSetting(this);
		}
	}

}