/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.shop.by.diagram.service.impl;

import com.liferay.commerce.shop.by.diagram.model.CSDiagramPin;
import com.liferay.commerce.shop.by.diagram.service.base.CSDiagramPinLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(enabled=false, property={"model.class.name=com.liferay.commerce.shop.by.diagram.model.CSDiagramPin"}, service={AopService.class})
public class CSDiagramPinLocalServiceImpl
extends CSDiagramPinLocalServiceBaseImpl {
    public CSDiagramPin addCSDiagramPin(long userId, long cpDefinitionId, double positionX, double positionY, String sequence) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        long csDiagramPinId = this.counterLocalService.increment();
        CSDiagramPin csDiagramPin = this.csDiagramPinPersistence.create(csDiagramPinId);
        csDiagramPin.setCompanyId(user.getCompanyId());
        csDiagramPin.setUserId(user.getUserId());
        csDiagramPin.setUserName(user.getFullName());
        csDiagramPin.setCPDefinitionId(cpDefinitionId);
        csDiagramPin.setPositionX(positionX);
        csDiagramPin.setPositionY(positionY);
        csDiagramPin.setSequence(sequence);
        return (CSDiagramPin)this.csDiagramPinPersistence.update((BaseModel)csDiagramPin);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CSDiagramPin deleteCSDiagramPin(CSDiagramPin csDiagramPin) {
        return (CSDiagramPin)this.csDiagramPinPersistence.remove((BaseModel)csDiagramPin);
    }

    public void deleteCSDiagramPins(long cpDefinitionId) {
        List csDiagramPins = this.csDiagramPinPersistence.findByCPDefinitionId(cpDefinitionId);
        for (CSDiagramPin csDiagramPin : csDiagramPins) {
            this.csDiagramPinLocalService.deleteCSDiagramPin(csDiagramPin);
        }
    }

    public List<CSDiagramPin> getCSDiagramPins(long cpDefinitionId, int start, int end) {
        return this.csDiagramPinPersistence.findByCPDefinitionId(cpDefinitionId, start, end);
    }

    public int getCSDiagramPinsCount(long cpDefinitionId) {
        return this.csDiagramPinPersistence.countByCPDefinitionId(cpDefinitionId);
    }

    public CSDiagramPin updateCSDiagramPin(long csDiagramPinId, double positionX, double positionY, String sequence) throws PortalException {
        CSDiagramPin csDiagramPin = this.csDiagramPinLocalService.getCSDiagramPin(csDiagramPinId);
        csDiagramPin.setPositionX(positionX);
        csDiagramPin.setPositionY(positionY);
        csDiagramPin.setSequence(sequence);
        return (CSDiagramPin)this.csDiagramPinPersistence.update((BaseModel)csDiagramPin);
    }
}

