/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.shop.by.diagram.model.impl;

import com.liferay.commerce.shop.by.diagram.model.CSDiagramEntry;
import com.liferay.commerce.shop.by.diagram.service.CSDiagramEntryLocalServiceUtil;

/**
 * The extended model base implementation for the CSDiagramEntry service. Represents a row in the &quot;CSDiagramEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CSDiagramEntryImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CSDiagramEntryImpl
 * @see CSDiagramEntry
 * @generated
 */
public abstract class CSDiagramEntryBaseImpl
	extends CSDiagramEntryModelImpl implements CSDiagramEntry {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a cs diagram entry model instance should use the <code>CSDiagramEntry</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CSDiagramEntryLocalServiceUtil.addCSDiagramEntry(this);
		}
		else {
			CSDiagramEntryLocalServiceUtil.updateCSDiagramEntry(this);
		}
	}

}