/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.shop.by.diagram.model.impl;

import com.liferay.commerce.shop.by.diagram.model.CSDiagramEntry;
import com.liferay.commerce.shop.by.diagram.model.CSDiagramEntryModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CSDiagramEntry service. Represents a row in the &quot;CSDiagramEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CSDiagramEntryModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CSDiagramEntryImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CSDiagramEntryImpl
 * @generated
 */
@JSON(strict = true)
public class CSDiagramEntryModelImpl
	extends BaseModelImpl<CSDiagramEntry> implements CSDiagramEntryModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a cs diagram entry model instance should use the <code>CSDiagramEntry</code> interface instead.
	 */
	public static final String TABLE_NAME = "CSDiagramEntry";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"CSDiagramEntryId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"CPDefinitionId", Types.BIGINT}, {"CPInstanceId", Types.BIGINT},
		{"CProductId", Types.BIGINT}, {"diagram", Types.BOOLEAN},
		{"quantity", Types.INTEGER}, {"sequence", Types.VARCHAR},
		{"sku", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("CSDiagramEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("CPDefinitionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("CPInstanceId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("CProductId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("diagram", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("quantity", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("sequence", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("sku", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CSDiagramEntry (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,CSDiagramEntryId LONG not null,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,CPDefinitionId LONG,CPInstanceId LONG,CProductId LONG,diagram BOOLEAN,quantity INTEGER,sequence VARCHAR(75) null,sku VARCHAR(75) null,primary key (CSDiagramEntryId, ctCollectionId))";

	public static final String TABLE_SQL_DROP = "drop table CSDiagramEntry";

	public static final String ORDER_BY_JPQL =
		" ORDER BY csDiagramEntry.sequence ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CSDiagramEntry.sequence ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CPDEFINITIONID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CPINSTANCEID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CPRODUCTID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SEQUENCE_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public CSDiagramEntryModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _CSDiagramEntryId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCSDiagramEntryId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _CSDiagramEntryId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CSDiagramEntry.class;
	}

	@Override
	public String getModelClassName() {
		return CSDiagramEntry.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CSDiagramEntry, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CSDiagramEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CSDiagramEntry, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((CSDiagramEntry)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CSDiagramEntry, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CSDiagramEntry, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CSDiagramEntry)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CSDiagramEntry, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CSDiagramEntry, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<CSDiagramEntry, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<CSDiagramEntry, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<CSDiagramEntry, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", CSDiagramEntry::getMvccVersion);
			attributeGetterFunctions.put(
				"ctCollectionId", CSDiagramEntry::getCtCollectionId);
			attributeGetterFunctions.put(
				"CSDiagramEntryId", CSDiagramEntry::getCSDiagramEntryId);
			attributeGetterFunctions.put(
				"companyId", CSDiagramEntry::getCompanyId);
			attributeGetterFunctions.put("userId", CSDiagramEntry::getUserId);
			attributeGetterFunctions.put(
				"userName", CSDiagramEntry::getUserName);
			attributeGetterFunctions.put(
				"createDate", CSDiagramEntry::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", CSDiagramEntry::getModifiedDate);
			attributeGetterFunctions.put(
				"CPDefinitionId", CSDiagramEntry::getCPDefinitionId);
			attributeGetterFunctions.put(
				"CPInstanceId", CSDiagramEntry::getCPInstanceId);
			attributeGetterFunctions.put(
				"CProductId", CSDiagramEntry::getCProductId);
			attributeGetterFunctions.put("diagram", CSDiagramEntry::getDiagram);
			attributeGetterFunctions.put(
				"quantity", CSDiagramEntry::getQuantity);
			attributeGetterFunctions.put(
				"sequence", CSDiagramEntry::getSequence);
			attributeGetterFunctions.put("sku", CSDiagramEntry::getSku);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<CSDiagramEntry, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<CSDiagramEntry, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap<String, BiConsumer<CSDiagramEntry, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<CSDiagramEntry, Long>)
					CSDiagramEntry::setMvccVersion);
			attributeSetterBiConsumers.put(
				"ctCollectionId",
				(BiConsumer<CSDiagramEntry, Long>)
					CSDiagramEntry::setCtCollectionId);
			attributeSetterBiConsumers.put(
				"CSDiagramEntryId",
				(BiConsumer<CSDiagramEntry, Long>)
					CSDiagramEntry::setCSDiagramEntryId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<CSDiagramEntry, Long>)CSDiagramEntry::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<CSDiagramEntry, Long>)CSDiagramEntry::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<CSDiagramEntry, String>)
					CSDiagramEntry::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<CSDiagramEntry, Date>)
					CSDiagramEntry::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<CSDiagramEntry, Date>)
					CSDiagramEntry::setModifiedDate);
			attributeSetterBiConsumers.put(
				"CPDefinitionId",
				(BiConsumer<CSDiagramEntry, Long>)
					CSDiagramEntry::setCPDefinitionId);
			attributeSetterBiConsumers.put(
				"CPInstanceId",
				(BiConsumer<CSDiagramEntry, Long>)
					CSDiagramEntry::setCPInstanceId);
			attributeSetterBiConsumers.put(
				"CProductId",
				(BiConsumer<CSDiagramEntry, Long>)
					CSDiagramEntry::setCProductId);
			attributeSetterBiConsumers.put(
				"diagram",
				(BiConsumer<CSDiagramEntry, Boolean>)
					CSDiagramEntry::setDiagram);
			attributeSetterBiConsumers.put(
				"quantity",
				(BiConsumer<CSDiagramEntry, Integer>)
					CSDiagramEntry::setQuantity);
			attributeSetterBiConsumers.put(
				"sequence",
				(BiConsumer<CSDiagramEntry, String>)
					CSDiagramEntry::setSequence);
			attributeSetterBiConsumers.put(
				"sku",
				(BiConsumer<CSDiagramEntry, String>)CSDiagramEntry::setSku);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@JSON
	@Override
	public long getCSDiagramEntryId() {
		return _CSDiagramEntryId;
	}

	@Override
	public void setCSDiagramEntryId(long CSDiagramEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_CSDiagramEntryId = CSDiagramEntryId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getCPDefinitionId() {
		return _CPDefinitionId;
	}

	@Override
	public void setCPDefinitionId(long CPDefinitionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_CPDefinitionId = CPDefinitionId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCPDefinitionId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("CPDefinitionId"));
	}

	@JSON
	@Override
	public long getCPInstanceId() {
		return _CPInstanceId;
	}

	@Override
	public void setCPInstanceId(long CPInstanceId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_CPInstanceId = CPInstanceId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCPInstanceId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("CPInstanceId"));
	}

	@JSON
	@Override
	public long getCProductId() {
		return _CProductId;
	}

	@Override
	public void setCProductId(long CProductId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_CProductId = CProductId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCProductId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("CProductId"));
	}

	@JSON
	@Override
	public boolean getDiagram() {
		return _diagram;
	}

	@JSON
	@Override
	public boolean isDiagram() {
		return _diagram;
	}

	@Override
	public void setDiagram(boolean diagram) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_diagram = diagram;
	}

	@JSON
	@Override
	public int getQuantity() {
		return _quantity;
	}

	@Override
	public void setQuantity(int quantity) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_quantity = quantity;
	}

	@JSON
	@Override
	public String getSequence() {
		if (_sequence == null) {
			return "";
		}
		else {
			return _sequence;
		}
	}

	@Override
	public void setSequence(String sequence) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_sequence = sequence;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalSequence() {
		return getColumnOriginalValue("sequence");
	}

	@JSON
	@Override
	public String getSku() {
		if (_sku == null) {
			return "";
		}
		else {
			return _sku;
		}
	}

	@Override
	public void setSku(String sku) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_sku = sku;
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CSDiagramEntry.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CSDiagramEntry toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CSDiagramEntry>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CSDiagramEntryImpl csDiagramEntryImpl = new CSDiagramEntryImpl();

		csDiagramEntryImpl.setMvccVersion(getMvccVersion());
		csDiagramEntryImpl.setCtCollectionId(getCtCollectionId());
		csDiagramEntryImpl.setCSDiagramEntryId(getCSDiagramEntryId());
		csDiagramEntryImpl.setCompanyId(getCompanyId());
		csDiagramEntryImpl.setUserId(getUserId());
		csDiagramEntryImpl.setUserName(getUserName());
		csDiagramEntryImpl.setCreateDate(getCreateDate());
		csDiagramEntryImpl.setModifiedDate(getModifiedDate());
		csDiagramEntryImpl.setCPDefinitionId(getCPDefinitionId());
		csDiagramEntryImpl.setCPInstanceId(getCPInstanceId());
		csDiagramEntryImpl.setCProductId(getCProductId());
		csDiagramEntryImpl.setDiagram(isDiagram());
		csDiagramEntryImpl.setQuantity(getQuantity());
		csDiagramEntryImpl.setSequence(getSequence());
		csDiagramEntryImpl.setSku(getSku());

		csDiagramEntryImpl.resetOriginalValues();

		return csDiagramEntryImpl;
	}

	@Override
	public CSDiagramEntry cloneWithOriginalValues() {
		CSDiagramEntryImpl csDiagramEntryImpl = new CSDiagramEntryImpl();

		csDiagramEntryImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		csDiagramEntryImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		csDiagramEntryImpl.setCSDiagramEntryId(
			this.<Long>getColumnOriginalValue("CSDiagramEntryId"));
		csDiagramEntryImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		csDiagramEntryImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		csDiagramEntryImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		csDiagramEntryImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		csDiagramEntryImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		csDiagramEntryImpl.setCPDefinitionId(
			this.<Long>getColumnOriginalValue("CPDefinitionId"));
		csDiagramEntryImpl.setCPInstanceId(
			this.<Long>getColumnOriginalValue("CPInstanceId"));
		csDiagramEntryImpl.setCProductId(
			this.<Long>getColumnOriginalValue("CProductId"));
		csDiagramEntryImpl.setDiagram(
			this.<Boolean>getColumnOriginalValue("diagram"));
		csDiagramEntryImpl.setQuantity(
			this.<Integer>getColumnOriginalValue("quantity"));
		csDiagramEntryImpl.setSequence(
			this.<String>getColumnOriginalValue("sequence"));
		csDiagramEntryImpl.setSku(this.<String>getColumnOriginalValue("sku"));

		return csDiagramEntryImpl;
	}

	@Override
	public int compareTo(CSDiagramEntry csDiagramEntry) {
		int value = 0;

		value = getSequence().compareTo(csDiagramEntry.getSequence());

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CSDiagramEntry)) {
			return false;
		}

		CSDiagramEntry csDiagramEntry = (CSDiagramEntry)object;

		long primaryKey = csDiagramEntry.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CSDiagramEntry> toCacheModel() {
		CSDiagramEntryCacheModel csDiagramEntryCacheModel =
			new CSDiagramEntryCacheModel();

		csDiagramEntryCacheModel.mvccVersion = getMvccVersion();

		csDiagramEntryCacheModel.ctCollectionId = getCtCollectionId();

		csDiagramEntryCacheModel.CSDiagramEntryId = getCSDiagramEntryId();

		csDiagramEntryCacheModel.companyId = getCompanyId();

		csDiagramEntryCacheModel.userId = getUserId();

		csDiagramEntryCacheModel.userName = getUserName();

		String userName = csDiagramEntryCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			csDiagramEntryCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			csDiagramEntryCacheModel.createDate = createDate.getTime();
		}
		else {
			csDiagramEntryCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			csDiagramEntryCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			csDiagramEntryCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		csDiagramEntryCacheModel.CPDefinitionId = getCPDefinitionId();

		csDiagramEntryCacheModel.CPInstanceId = getCPInstanceId();

		csDiagramEntryCacheModel.CProductId = getCProductId();

		csDiagramEntryCacheModel.diagram = isDiagram();

		csDiagramEntryCacheModel.quantity = getQuantity();

		csDiagramEntryCacheModel.sequence = getSequence();

		String sequence = csDiagramEntryCacheModel.sequence;

		if ((sequence != null) && (sequence.length() == 0)) {
			csDiagramEntryCacheModel.sequence = null;
		}

		csDiagramEntryCacheModel.sku = getSku();

		String sku = csDiagramEntryCacheModel.sku;

		if ((sku != null) && (sku.length() == 0)) {
			csDiagramEntryCacheModel.sku = null;
		}

		return csDiagramEntryCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CSDiagramEntry, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CSDiagramEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CSDiagramEntry, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((CSDiagramEntry)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, CSDiagramEntry>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					CSDiagramEntry.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private long _CSDiagramEntryId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _CPDefinitionId;
	private long _CPInstanceId;
	private long _CProductId;
	private boolean _diagram;
	private int _quantity;
	private String _sequence;
	private String _sku;

	public <T> T getColumnValue(String columnName) {
		Function<CSDiagramEntry, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((CSDiagramEntry)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("CSDiagramEntryId", _CSDiagramEntryId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("CPDefinitionId", _CPDefinitionId);
		_columnOriginalValues.put("CPInstanceId", _CPInstanceId);
		_columnOriginalValues.put("CProductId", _CProductId);
		_columnOriginalValues.put("diagram", _diagram);
		_columnOriginalValues.put("quantity", _quantity);
		_columnOriginalValues.put("sequence", _sequence);
		_columnOriginalValues.put("sku", _sku);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("CSDiagramEntryId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("userName", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("CPDefinitionId", 256L);

		columnBitmasks.put("CPInstanceId", 512L);

		columnBitmasks.put("CProductId", 1024L);

		columnBitmasks.put("diagram", 2048L);

		columnBitmasks.put("quantity", 4096L);

		columnBitmasks.put("sequence", 8192L);

		columnBitmasks.put("sku", 16384L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private CSDiagramEntry _escapedModel;

}