/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.shop.by.diagram.model.impl;

import com.liferay.commerce.shop.by.diagram.model.CSDiagramPin;
import com.liferay.commerce.shop.by.diagram.service.CSDiagramPinLocalServiceUtil;

/**
 * The extended model base implementation for the CSDiagramPin service. Represents a row in the &quot;CSDiagramPin&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CSDiagramPinImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CSDiagramPinImpl
 * @see CSDiagramPin
 * @generated
 */
public abstract class CSDiagramPinBaseImpl
	extends CSDiagramPinModelImpl implements CSDiagramPin {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a cs diagram pin model instance should use the <code>CSDiagramPin</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CSDiagramPinLocalServiceUtil.addCSDiagramPin(this);
		}
		else {
			CSDiagramPinLocalServiceUtil.updateCSDiagramPin(this);
		}
	}

}