/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.shop.by.diagram.internal.search.spi.model.index.contributor;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.shop.by.diagram.model.CSDiagramEntry;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.commerce.shop.by.diagram.model.CSDiagramEntry"}, service={ModelDocumentContributor.class})
public class CSDiagramEntryModelDocumentContributor
implements ModelDocumentContributor<CSDiagramEntry> {
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private Localization _localization;

    public void contribute(Document document, CSDiagramEntry csDiagramEntry) {
        document.addNumber("CPDefinitionId", csDiagramEntry.getCPDefinitionId());
        document.addText("sku", csDiagramEntry.getSku());
        document.addNumber("quantity", csDiagramEntry.getQuantity());
        document.addText("sequence", csDiagramEntry.getSequence());
        CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinitionByCProductId(csDiagramEntry.getCProductId());
        if (cpDefinition == null) {
            return;
        }
        List languageIds = this._cpDefinitionLocalService.getCPDefinitionLocalizationLanguageIds(cpDefinition.getCPDefinitionId());
        for (String languageId : languageIds) {
            String shortDescription = cpDefinition.getShortDescription(languageId);
            String description = cpDefinition.getDescription(languageId);
            String name = cpDefinition.getName(languageId);
            document.addText(this._localization.getLocalizedName("shortDescription", languageId), shortDescription);
            document.addText(this._localization.getLocalizedName("description", languageId), description);
            document.addText(this._localization.getLocalizedName("name", languageId), name);
        }
        String cpDefinitionDefaultLanguageId = this._localization.getDefaultLanguageId(cpDefinition.getName());
        document.addText("shortDescription", cpDefinition.getShortDescription(cpDefinitionDefaultLanguageId));
        document.addText("description", cpDefinition.getDescription(cpDefinitionDefaultLanguageId));
        document.addText("name", cpDefinition.getName(cpDefinitionDefaultLanguageId));
    }
}

