/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.shop.by.diagram.service.impl;

import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.shop.by.diagram.exception.DuplicateCSDiagramEntryException;
import com.liferay.commerce.shop.by.diagram.model.CSDiagramEntry;
import com.liferay.commerce.shop.by.diagram.model.CSDiagramPin;
import com.liferay.commerce.shop.by.diagram.service.CSDiagramPinLocalService;
import com.liferay.commerce.shop.by.diagram.service.base.CSDiagramEntryLocalServiceBaseImpl;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.shop.by.diagram.model.CSDiagramEntry"}, service={AopService.class})
public class CSDiagramEntryLocalServiceImpl
extends CSDiagramEntryLocalServiceBaseImpl {
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private CSDiagramPinLocalService _csDiagramPinLocalService;
    @Reference
    private ExpandoRowLocalService _expandoRowLocalService;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public CSDiagramEntry addCSDiagramEntry(long userId, long cpDefinitionId, long cpInstanceId, long cProductId, boolean diagram, int quantity, String sequence, String sku, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        this._validate(null, cpDefinitionId, sequence);
        long csDiagramEntryId = this.counterLocalService.increment();
        CSDiagramEntry csDiagramEntry = this.csDiagramEntryPersistence.create(csDiagramEntryId);
        csDiagramEntry.setCompanyId(user.getCompanyId());
        csDiagramEntry.setUserId(user.getUserId());
        csDiagramEntry.setUserName(user.getFullName());
        csDiagramEntry.setCPDefinitionId(cpDefinitionId);
        csDiagramEntry.setCPInstanceId(cpInstanceId);
        csDiagramEntry.setCProductId(cProductId);
        csDiagramEntry.setDiagram(diagram);
        csDiagramEntry.setQuantity(quantity);
        csDiagramEntry.setSequence(sequence);
        csDiagramEntry.setSku(sku);
        csDiagramEntry.setExpandoBridgeAttributes(serviceContext);
        return (CSDiagramEntry)this.csDiagramEntryPersistence.update((BaseModel)csDiagramEntry);
    }

    public void deleteCSDiagramEntries(long cpDefinitionId) throws PortalException {
        List csDiagramEntries = this.csDiagramEntryPersistence.findByCPDefinitionId(cpDefinitionId);
        for (CSDiagramEntry csDiagramEntry : csDiagramEntries) {
            this.csDiagramEntryLocalService.deleteCSDiagramEntry(csDiagramEntry);
        }
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CSDiagramEntry deleteCSDiagramEntry(CSDiagramEntry csDiagramEntry) throws PortalException {
        csDiagramEntry = (CSDiagramEntry)this.csDiagramEntryPersistence.remove((BaseModel)csDiagramEntry);
        List csDiagramPins = this._csDiagramPinLocalService.getCSDiagramPins(csDiagramEntry.getCPDefinitionId(), -1, -1);
        for (CSDiagramPin csDiagramPin : csDiagramPins) {
            if (csDiagramEntry.getCPDefinitionId() != csDiagramPin.getCPDefinitionId() || !Objects.equals(csDiagramEntry.getSequence(), csDiagramPin.getSequence())) continue;
            this._csDiagramPinLocalService.deleteCSDiagramPin(csDiagramPin.getCSDiagramPinId());
        }
        this._expandoRowLocalService.deleteRows(csDiagramEntry.getCSDiagramEntryId());
        return csDiagramEntry;
    }

    public CSDiagramEntry fetchCSDiagramEntry(long cpDefinitionId, String sequence) {
        return this.csDiagramEntryPersistence.fetchByCPDI_S(cpDefinitionId, sequence);
    }

    public List<CSDiagramEntry> getCPDefinitionRelatedCSDiagramEntries(long cpDefinitionId) {
        HashSet csDiagramEntries = new HashSet();
        List cpInstances = this._cpInstanceLocalService.getCPDefinitionApprovedCPInstances(cpDefinitionId);
        for (CPInstance cpInstance : cpInstances) {
            csDiagramEntries.addAll(this.csDiagramEntryPersistence.findByCPInstanceId(cpInstance.getCPInstanceId()));
        }
        return new ArrayList<CSDiagramEntry>(csDiagramEntries);
    }

    public List<CSDiagramEntry> getCProductCSDiagramEntries(long cProductId, int start, int end, OrderByComparator<CSDiagramEntry> orderByComparator) throws PortalException {
        return this.csDiagramEntryPersistence.findByCProductId(cProductId, start, end, orderByComparator);
    }

    public List<CSDiagramEntry> getCSDiagramEntries(long cpDefinitionId, int start, int end) {
        return this.csDiagramEntryPersistence.findByCPDefinitionId(cpDefinitionId, start, end);
    }

    public int getCSDiagramEntriesCount(long cpDefinitionId) {
        return this.csDiagramEntryPersistence.countByCPDefinitionId(cpDefinitionId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CSDiagramEntry getCSDiagramEntry(long cpDefinitionId, String sequence) throws PortalException {
        return this.csDiagramEntryPersistence.findByCPDI_S(cpDefinitionId, sequence);
    }

    public CSDiagramEntry updateCSDiagramEntry(long csDiagramEntryId, long cpInstanceId, long cProductId, boolean diagram, int quantity, String sequence, String sku, ServiceContext serviceContext) throws PortalException {
        CSDiagramEntry csDiagramEntry = this.csDiagramEntryLocalService.getCSDiagramEntry(csDiagramEntryId);
        this._validate(csDiagramEntry, csDiagramEntry.getCPDefinitionId(), sequence);
        csDiagramEntry.setCPInstanceId(cpInstanceId);
        csDiagramEntry.setCProductId(cProductId);
        csDiagramEntry.setDiagram(diagram);
        csDiagramEntry.setQuantity(quantity);
        csDiagramEntry.setSequence(sequence);
        csDiagramEntry.setSku(sku);
        csDiagramEntry.setExpandoBridgeAttributes(serviceContext);
        return (CSDiagramEntry)this.csDiagramEntryPersistence.update((BaseModel)csDiagramEntry);
    }

    private void _validate(CSDiagramEntry oldCSDiagramEntry, long cpDefinitionId, String sequence) throws PortalException {
        CSDiagramEntry csDiagramEntry = this.csDiagramEntryPersistence.fetchByCPDI_S(cpDefinitionId, sequence);
        if (!Objects.equals(oldCSDiagramEntry, csDiagramEntry)) {
            throw new DuplicateCSDiagramEntryException();
        }
    }
}

