/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.shop.by.diagram.service.impl;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.service.CProductLocalService;
import com.liferay.commerce.shop.by.diagram.model.CSDiagramEntry;
import com.liferay.commerce.shop.by.diagram.service.base.CSDiagramEntryServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=commerce", "json.web.service.context.path=CSDiagramEntry"}, service={AopService.class})
public class CSDiagramEntryServiceImpl
extends CSDiagramEntryServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.commerce.product.model.CPDefinition)")
    private ModelResourcePermission<CPDefinition> _cpDefinitionModelResourcePermission;
    @Reference
    private CProductLocalService _cProductLocalService;

    public CSDiagramEntry addCSDiagramEntry(long cpDefinitionId, long cpInstanceId, long cProductId, boolean diagram, int quantity, String sequence, String sku, ServiceContext serviceContext) throws PortalException {
        this._cpDefinitionModelResourcePermission.check(this.getPermissionChecker(), cpDefinitionId, "UPDATE");
        return this.csDiagramEntryLocalService.addCSDiagramEntry(this.getUserId(), cpDefinitionId, cpInstanceId, cProductId, diagram, quantity, sequence, sku, serviceContext);
    }

    public void deleteCSDiagramEntries(long cpDefinitionId) throws PortalException {
        this._cpDefinitionModelResourcePermission.check(this.getPermissionChecker(), cpDefinitionId, "UPDATE");
        this.csDiagramEntryLocalService.deleteCSDiagramEntries(cpDefinitionId);
    }

    public void deleteCSDiagramEntry(CSDiagramEntry csDiagramEntry) throws PortalException {
        this._cpDefinitionModelResourcePermission.check(this.getPermissionChecker(), csDiagramEntry.getCPDefinitionId(), "UPDATE");
        this.csDiagramEntryLocalService.deleteCSDiagramEntry(csDiagramEntry);
    }

    public CSDiagramEntry fetchCSDiagramEntry(long cpDefinitionId, String sequence) throws PortalException {
        this._cpDefinitionModelResourcePermission.check(this.getPermissionChecker(), cpDefinitionId, "UPDATE");
        return this.csDiagramEntryLocalService.fetchCSDiagramEntry(cpDefinitionId, sequence);
    }

    public List<CSDiagramEntry> getCProductCSDiagramEntries(long cProductId, int start, int end, OrderByComparator<CSDiagramEntry> orderByComparator) throws PortalException {
        CProduct cProduct = this._cProductLocalService.getCProduct(cProductId);
        this._cpDefinitionModelResourcePermission.check(this.getPermissionChecker(), cProduct.getPublishedCPDefinitionId(), "VIEW");
        return this.csDiagramEntryPersistence.findByCProductId(cProductId, start, end, orderByComparator);
    }

    public int getCProductCSDiagramEntriesCount(long cProductId) throws PortalException {
        CProduct cProduct = this._cProductLocalService.getCProduct(cProductId);
        this._cpDefinitionModelResourcePermission.check(this.getPermissionChecker(), cProduct.getPublishedCPDefinitionId(), "VIEW");
        return this.csDiagramEntryPersistence.countByCProductId(cProductId);
    }

    public List<CSDiagramEntry> getCSDiagramEntries(long cpDefinitionId, int start, int end) throws PortalException {
        this._cpDefinitionModelResourcePermission.check(this.getPermissionChecker(), cpDefinitionId, "UPDATE");
        return this.csDiagramEntryLocalService.getCSDiagramEntries(cpDefinitionId, start, end);
    }

    public int getCSDiagramEntriesCount(long cpDefinitionId) throws PortalException {
        this._cpDefinitionModelResourcePermission.check(this.getPermissionChecker(), cpDefinitionId, "UPDATE");
        return this.csDiagramEntryLocalService.getCSDiagramEntriesCount(cpDefinitionId);
    }

    public CSDiagramEntry getCSDiagramEntry(long csDiagramEntryId) throws PortalException {
        CSDiagramEntry csDiagramEntry = this.csDiagramEntryLocalService.getCSDiagramEntry(csDiagramEntryId);
        this._cpDefinitionModelResourcePermission.check(this.getPermissionChecker(), csDiagramEntry.getCPDefinitionId(), "UPDATE");
        return csDiagramEntry;
    }

    public CSDiagramEntry getCSDiagramEntry(long cpDefinitionId, String sequence) throws PortalException {
        this._cpDefinitionModelResourcePermission.check(this.getPermissionChecker(), cpDefinitionId, "UPDATE");
        return this.csDiagramEntryLocalService.getCSDiagramEntry(cpDefinitionId, sequence);
    }

    public CSDiagramEntry updateCSDiagramEntry(long csDiagramEntryId, long cpInstanceId, long cProductId, boolean diagram, int quantity, String sequence, String sku, ServiceContext serviceContext) throws PortalException {
        CSDiagramEntry csDiagramEntry = this.csDiagramEntryLocalService.getCSDiagramEntry(csDiagramEntryId);
        this._cpDefinitionModelResourcePermission.check(this.getPermissionChecker(), csDiagramEntry.getCPDefinitionId(), "UPDATE");
        return this.csDiagramEntryLocalService.updateCSDiagramEntry(csDiagramEntryId, cpInstanceId, cProductId, diagram, quantity, sequence, sku, serviceContext);
    }
}

