/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.shop.by.diagram.service.impl;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.shop.by.diagram.model.CSDiagramSetting;
import com.liferay.commerce.shop.by.diagram.service.base.CSDiagramSettingServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=commerce", "json.web.service.context.path=CSDiagramSetting"}, service={AopService.class})
public class CSDiagramSettingServiceImpl
extends CSDiagramSettingServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.commerce.product.model.CPDefinition)")
    private ModelResourcePermission<CPDefinition> _cpDefinitionModelResourcePermission;

    public CSDiagramSetting addCSDiagramSetting(long cpDefinitionId, long cpAttachmentFileEntryId, String color, double radius, String type) throws PortalException {
        this._cpDefinitionModelResourcePermission.check(this.getPermissionChecker(), cpDefinitionId, "UPDATE");
        return this.csDiagramSettingLocalService.addCSDiagramSetting(this.getUserId(), cpDefinitionId, cpAttachmentFileEntryId, color, radius, type);
    }

    public CSDiagramSetting fetchCSDiagramSettingByCPDefinitionId(long cpDefinitionId) throws PortalException {
        this._cpDefinitionModelResourcePermission.check(this.getPermissionChecker(), cpDefinitionId, "UPDATE");
        return this.csDiagramSettingLocalService.fetchCSDiagramSettingByCPDefinitionId(cpDefinitionId);
    }

    public CSDiagramSetting getCSDiagramSetting(long csDiagramSettingId) throws PortalException {
        CSDiagramSetting csDiagramSetting = this.csDiagramSettingLocalService.getCSDiagramSetting(csDiagramSettingId);
        this._cpDefinitionModelResourcePermission.check(this.getPermissionChecker(), csDiagramSetting.getCPDefinitionId(), "UPDATE");
        return csDiagramSetting;
    }

    public CSDiagramSetting getCSDiagramSettingByCPDefinitionId(long cpDefinitionId) throws PortalException {
        this._cpDefinitionModelResourcePermission.check(this.getPermissionChecker(), cpDefinitionId, "UPDATE");
        return this.csDiagramSettingLocalService.getCSDiagramSettingByCPDefinitionId(cpDefinitionId);
    }

    public CSDiagramSetting updateCSDiagramSetting(long csDiagramSettingId, long cpAttachmentFileEntryId, String color, double radius, String type) throws PortalException {
        CSDiagramSetting csDiagramSetting = this.csDiagramSettingLocalService.getCSDiagramSetting(csDiagramSettingId);
        this._cpDefinitionModelResourcePermission.check(this.getPermissionChecker(), csDiagramSetting.getCPDefinitionId(), "UPDATE");
        return this.csDiagramSettingLocalService.updateCSDiagramSetting(csDiagramSetting.getCSDiagramSettingId(), cpAttachmentFileEntryId, color, radius, type);
    }
}

