/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.tax.service.impl;

import com.liferay.commerce.tax.exception.CommerceTaxMethodEngineKeyException;
import com.liferay.commerce.tax.exception.CommerceTaxMethodNameException;
import com.liferay.commerce.tax.model.CommerceTaxMethod;
import com.liferay.commerce.tax.service.base.CommerceTaxMethodLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(enabled=false, property={"model.class.name=com.liferay.commerce.tax.model.CommerceTaxMethod"}, service={AopService.class})
public class CommerceTaxMethodLocalServiceImpl
extends CommerceTaxMethodLocalServiceBaseImpl {
    public CommerceTaxMethod addCommerceTaxMethod(long userId, long groupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String engineKey, boolean percentage, boolean active) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        this.validate(nameMap, engineKey);
        long commerceTaxMethodId = this.counterLocalService.increment();
        CommerceTaxMethod commerceTaxMethod = this.commerceTaxMethodPersistence.create(commerceTaxMethodId);
        commerceTaxMethod.setGroupId(groupId);
        commerceTaxMethod.setCompanyId(user.getCompanyId());
        commerceTaxMethod.setUserId(user.getUserId());
        commerceTaxMethod.setUserName(user.getFullName());
        commerceTaxMethod.setNameMap(nameMap);
        commerceTaxMethod.setDescriptionMap(descriptionMap);
        commerceTaxMethod.setEngineKey(engineKey);
        commerceTaxMethod.setPercentage(percentage);
        commerceTaxMethod.setActive(active);
        return (CommerceTaxMethod)this.commerceTaxMethodPersistence.update((BaseModel)commerceTaxMethod);
    }

    @Deprecated
    public CommerceTaxMethod addCommerceTaxMethod(Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String engineKey, boolean percentage, boolean active, ServiceContext serviceContext) throws PortalException {
        return this.commerceTaxMethodLocalService.addCommerceTaxMethod(serviceContext.getUserId(), serviceContext.getScopeGroupId(), nameMap, descriptionMap, engineKey, percentage, active);
    }

    public void deleteCommerceTaxMethods(long groupId) throws PortalException {
        List commerceTaxMethods = this.commerceTaxMethodPersistence.findByGroupId(groupId);
        for (CommerceTaxMethod commerceTaxMethod : commerceTaxMethods) {
            this.commerceTaxMethodLocalService.deleteCommerceTaxMethod(commerceTaxMethod);
        }
    }

    public CommerceTaxMethod fetchCommerceTaxMethod(long groupId, String engineKey) {
        return this.commerceTaxMethodPersistence.fetchByG_E(groupId, engineKey);
    }

    public List<CommerceTaxMethod> getCommerceTaxMethods(long groupId) {
        return this.commerceTaxMethodPersistence.findByGroupId(groupId);
    }

    public List<CommerceTaxMethod> getCommerceTaxMethods(long groupId, boolean active) {
        return this.commerceTaxMethodPersistence.findByG_A(groupId, active);
    }

    public int getCommerceTaxMethodsCount(long groupId, boolean active) {
        return this.commerceTaxMethodPersistence.countByG_A(groupId, active);
    }

    public CommerceTaxMethod setActive(long commerceTaxMethodId, boolean active) throws PortalException {
        CommerceTaxMethod commerceTaxMethod = this.commerceTaxMethodPersistence.findByPrimaryKey(commerceTaxMethodId);
        commerceTaxMethod.setActive(active);
        return (CommerceTaxMethod)this.commerceTaxMethodPersistence.update((BaseModel)commerceTaxMethod);
    }

    public CommerceTaxMethod updateCommerceTaxMethod(long commerceTaxMethodId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean percentage, boolean active) throws PortalException {
        CommerceTaxMethod commerceTaxMethod = this.commerceTaxMethodPersistence.findByPrimaryKey(commerceTaxMethodId);
        this.validate(nameMap, commerceTaxMethod.getEngineKey());
        commerceTaxMethod.setNameMap(nameMap);
        commerceTaxMethod.setDescriptionMap(descriptionMap);
        commerceTaxMethod.setPercentage(percentage);
        commerceTaxMethod.setActive(active);
        return (CommerceTaxMethod)this.commerceTaxMethodPersistence.update((BaseModel)commerceTaxMethod);
    }

    protected void validate(Map<Locale, String> nameMap, String engineKey) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        String name = nameMap.get(locale);
        if (Validator.isNull((String)name)) {
            throw new CommerceTaxMethodNameException();
        }
        if (Validator.isNull((String)engineKey)) {
            throw new CommerceTaxMethodEngineKeyException();
        }
    }
}

