/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.tax.model.impl;

import com.liferay.commerce.tax.model.CommerceTaxMethod;
import com.liferay.commerce.tax.service.CommerceTaxMethodLocalServiceUtil;

/**
 * The extended model base implementation for the CommerceTaxMethod service. Represents a row in the &quot;CommerceTaxMethod&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceTaxMethodImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see CommerceTaxMethodImpl
 * @see CommerceTaxMethod
 * @generated
 */
public abstract class CommerceTaxMethodBaseImpl
	extends CommerceTaxMethodModelImpl implements CommerceTaxMethod {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce tax method model instance should use the <code>CommerceTaxMethod</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommerceTaxMethodLocalServiceUtil.addCommerceTaxMethod(this);
		}
		else {
			CommerceTaxMethodLocalServiceUtil.updateCommerceTaxMethod(this);
		}
	}

}