/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.tax.service.impl;

import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.tax.model.CommerceTaxMethod;
import com.liferay.commerce.tax.service.base.CommerceTaxMethodServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CommerceTaxMethodServiceImpl
extends CommerceTaxMethodServiceBaseImpl {
    private static volatile ModelResourcePermission<CommerceChannel> _commerceChannelModelResourcePermission = ModelResourcePermissionFactory.getInstance(CommerceTaxMethodServiceImpl.class, (String)"_commerceChannelModelResourcePermission", CommerceChannel.class);
    @ServiceReference(type=CommerceChannelLocalService.class)
    private CommerceChannelLocalService _commerceChannelLocalService;

    public CommerceTaxMethod addCommerceTaxMethod(long userId, long groupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String engineKey, boolean percentage, boolean active) throws PortalException {
        this._checkCommerceChannel(groupId);
        return this.commerceTaxMethodLocalService.addCommerceTaxMethod(userId, groupId, nameMap, descriptionMap, engineKey, percentage, active);
    }

    @Deprecated
    public CommerceTaxMethod addCommerceTaxMethod(Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String engineKey, boolean percentage, boolean active, ServiceContext serviceContext) throws PortalException {
        return this.commerceTaxMethodService.addCommerceTaxMethod(serviceContext.getUserId(), serviceContext.getScopeGroupId(), nameMap, descriptionMap, engineKey, percentage, active);
    }

    public CommerceTaxMethod createCommerceTaxMethod(long groupId, long commerceTaxMethodId) throws PortalException {
        this._checkCommerceChannel(groupId);
        return this.commerceTaxMethodLocalService.createCommerceTaxMethod(commerceTaxMethodId);
    }

    public void deleteCommerceTaxMethod(long commerceTaxMethodId) throws PortalException {
        CommerceTaxMethod commerceTaxMethod = this.commerceTaxMethodLocalService.getCommerceTaxMethod(commerceTaxMethodId);
        this._checkCommerceChannel(commerceTaxMethod.getGroupId());
        this.commerceTaxMethodLocalService.deleteCommerceTaxMethod(commerceTaxMethod);
    }

    public CommerceTaxMethod fetchCommerceTaxMethod(long groupId, String engineKey) throws PortalException {
        this._checkCommerceChannel(groupId);
        return this.commerceTaxMethodLocalService.fetchCommerceTaxMethod(groupId, engineKey);
    }

    public CommerceTaxMethod getCommerceTaxMethod(long commerceTaxMethodId) throws PortalException {
        CommerceTaxMethod commerceTaxMethod = this.commerceTaxMethodLocalService.getCommerceTaxMethod(commerceTaxMethodId);
        this._checkCommerceChannel(commerceTaxMethod.getGroupId());
        return this.commerceTaxMethodLocalService.getCommerceTaxMethod(commerceTaxMethodId);
    }

    public List<CommerceTaxMethod> getCommerceTaxMethods(long groupId) throws PortalException {
        this._checkCommerceChannel(groupId);
        return this.commerceTaxMethodLocalService.getCommerceTaxMethods(groupId);
    }

    public List<CommerceTaxMethod> getCommerceTaxMethods(long groupId, boolean active) throws PortalException {
        this._checkCommerceChannel(groupId);
        return this.commerceTaxMethodLocalService.getCommerceTaxMethods(groupId, active);
    }

    public CommerceTaxMethod setActive(long commerceTaxMethodId, boolean active) throws PortalException {
        CommerceTaxMethod commerceTaxMethod = this.commerceTaxMethodLocalService.fetchCommerceTaxMethod(commerceTaxMethodId);
        if (commerceTaxMethod != null) {
            this._checkCommerceChannel(commerceTaxMethod.getGroupId());
        }
        return this.commerceTaxMethodLocalService.setActive(commerceTaxMethodId, active);
    }

    public CommerceTaxMethod updateCommerceTaxMethod(long commerceTaxMethodId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean percentage, boolean active) throws PortalException {
        CommerceTaxMethod commerceTaxMethod = this.commerceTaxMethodLocalService.getCommerceTaxMethod(commerceTaxMethodId);
        this._checkCommerceChannel(commerceTaxMethod.getGroupId());
        return this.commerceTaxMethodLocalService.updateCommerceTaxMethod(commerceTaxMethod.getCommerceTaxMethodId(), nameMap, descriptionMap, percentage, active);
    }

    private void _checkCommerceChannel(long groupId) throws PortalException {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByGroupId(groupId);
        _commerceChannelModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceChannel, "UPDATE");
    }
}

