/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.wish.list.service.impl;

import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.permission.CommerceProductViewPermission;
import com.liferay.commerce.product.service.CProductLocalService;
import com.liferay.commerce.wish.list.model.CommerceWishList;
import com.liferay.commerce.wish.list.model.CommerceWishListItem;
import com.liferay.commerce.wish.list.service.base.CommerceWishListItemServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.List;

public class CommerceWishListItemServiceImpl
extends CommerceWishListItemServiceBaseImpl {
    @ServiceReference(type=CommerceProductViewPermission.class)
    protected CommerceProductViewPermission commerceProductViewPermission;
    @ServiceReference(type=CProductLocalService.class)
    protected CProductLocalService cProductLocalService;
    private static volatile ModelResourcePermission<CommerceWishList> _commerceWishListModelResourcePermission = ModelResourcePermissionFactory.getInstance(CommerceWishListItemServiceImpl.class, (String)"_commerceWishListModelResourcePermission", CommerceWishList.class);

    public CommerceWishListItem addCommerceWishListItem(long commerceAccountId, long commerceWishListId, long cProductId, String cpInstanceUuid, String json, ServiceContext serviceContext) throws PortalException {
        _commerceWishListModelResourcePermission.check(this.getPermissionChecker(), commerceWishListId, "UPDATE");
        CProduct cProduct = this.cProductLocalService.getCProduct(cProductId);
        this.commerceProductViewPermission.check(this.getPermissionChecker(), commerceAccountId, cProduct.getPublishedCPDefinitionId());
        return this.commerceWishListItemLocalService.addCommerceWishListItem(commerceWishListId, cProductId, cpInstanceUuid, json, serviceContext);
    }

    public void deleteCommerceWishListItem(long commerceWishListItemId) throws PortalException {
        CommerceWishListItem commerceWishListItem = this.commerceWishListItemLocalService.getCommerceWishListItem(commerceWishListItemId);
        _commerceWishListModelResourcePermission.check(this.getPermissionChecker(), commerceWishListItem.getCommerceWishListId(), "UPDATE");
        this.commerceWishListItemLocalService.deleteCommerceWishListItem(commerceWishListItem);
    }

    public CommerceWishListItem getCommerceWishListItem(long commerceWishListItemId) throws PortalException {
        CommerceWishListItem commerceWishListItem = this.commerceWishListItemLocalService.getCommerceWishListItem(commerceWishListItemId);
        _commerceWishListModelResourcePermission.check(this.getPermissionChecker(), commerceWishListItem.getCommerceWishListId(), "VIEW");
        return commerceWishListItem;
    }

    public CommerceWishListItem getCommerceWishListItem(long commerceWishListId, String cpInstanceUuid, long cProductId) throws PortalException {
        _commerceWishListModelResourcePermission.check(this.getPermissionChecker(), commerceWishListId, "VIEW");
        return this.commerceWishListItemLocalService.getCommerceWishListItem(commerceWishListId, cpInstanceUuid, cProductId);
    }

    public int getCommerceWishListItemByContainsCPInstanceCount(long commerceWishListId, String cpInstanceUuid) throws PortalException {
        _commerceWishListModelResourcePermission.check(this.getPermissionChecker(), commerceWishListId, "VIEW");
        return this.commerceWishListItemPersistence.countByCW_CPI(commerceWishListId, cpInstanceUuid);
    }

    public int getCommerceWishListItemByContainsCProductCount(long commerceWishListId, long cProductId) throws PortalException {
        _commerceWishListModelResourcePermission.check(this.getPermissionChecker(), commerceWishListId, "VIEW");
        return this.commerceWishListItemPersistence.countByCW_CP(commerceWishListId, cProductId);
    }

    public List<CommerceWishListItem> getCommerceWishListItems(long commerceWishListId, int start, int end, OrderByComparator<CommerceWishListItem> orderByComparator) throws PortalException {
        _commerceWishListModelResourcePermission.check(this.getPermissionChecker(), commerceWishListId, "VIEW");
        return this.commerceWishListItemLocalService.getCommerceWishListItems(commerceWishListId, start, end, orderByComparator);
    }

    public int getCommerceWishListItemsCount(long commerceWishListId) throws PortalException {
        _commerceWishListModelResourcePermission.check(this.getPermissionChecker(), commerceWishListId, "VIEW");
        return this.commerceWishListItemLocalService.getCommerceWishListItemsCount(commerceWishListId);
    }
}

