/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.wish.list.service.impl;

import com.liferay.commerce.wish.list.model.CommerceWishList;
import com.liferay.commerce.wish.list.service.base.CommerceWishListServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class CommerceWishListServiceImpl
extends CommerceWishListServiceBaseImpl {
    private static volatile ModelResourcePermission<CommerceWishList> _commerceWishListModelResourcePermission = ModelResourcePermissionFactory.getInstance(CommerceWishListServiceImpl.class, (String)"_commerceWishListModelResourcePermission", CommerceWishList.class);

    public CommerceWishList addCommerceWishList(String name, boolean defaultWishList, ServiceContext serviceContext) throws PortalException {
        if (this.getUserId() != serviceContext.getUserId()) {
            this.checkManagePermission(serviceContext.getScopeGroupId());
        }
        return this.commerceWishListLocalService.addCommerceWishList(name, defaultWishList, serviceContext);
    }

    public void deleteCommerceWishList(long commerceWishListId) throws PortalException {
        _commerceWishListModelResourcePermission.check(this.getPermissionChecker(), commerceWishListId, "DELETE");
        this.commerceWishListLocalService.deleteCommerceWishList(commerceWishListId);
    }

    public CommerceWishList fetchCommerceWishList(long groupId, long userId, boolean defaultWishList, OrderByComparator<CommerceWishList> orderByComparator) throws PortalException {
        CommerceWishList commerceWishList = this.commerceWishListLocalService.fetchCommerceWishList(groupId, userId, defaultWishList, orderByComparator);
        if (commerceWishList != null) {
            _commerceWishListModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceWishList, "VIEW");
        }
        return commerceWishList;
    }

    public CommerceWishList getCommerceWishList(long commerceWishListId) throws PortalException {
        _commerceWishListModelResourcePermission.check(this.getPermissionChecker(), commerceWishListId, "VIEW");
        return this.commerceWishListLocalService.getCommerceWishList(commerceWishListId);
    }

    public List<CommerceWishList> getCommerceWishLists(long groupId, int start, int end, OrderByComparator<CommerceWishList> orderByComparator) throws PortalException {
        this.checkManagePermission(groupId);
        return this.commerceWishListLocalService.getCommerceWishLists(groupId, start, end, orderByComparator);
    }

    public List<CommerceWishList> getCommerceWishLists(long groupId, long userId, int start, int end, OrderByComparator<CommerceWishList> orderByComparator) throws PortalException {
        if (this.getUserId() != userId) {
            this.checkManagePermission(groupId);
        }
        return this.commerceWishListLocalService.getCommerceWishLists(groupId, userId, start, end, orderByComparator);
    }

    public int getCommerceWishListsCount(long groupId) throws PortalException {
        this.checkManagePermission(groupId);
        return this.commerceWishListLocalService.getCommerceWishListsCount(groupId);
    }

    public int getCommerceWishListsCount(long groupId, long userId) throws PortalException {
        if (this.getUserId() != userId) {
            this.checkManagePermission(groupId);
        }
        return this.commerceWishListLocalService.getCommerceWishListsCount(groupId, userId);
    }

    public CommerceWishList getDefaultCommerceWishList(long groupId, long userId) throws PortalException {
        CommerceWishList commerceWishList = this.commerceWishListLocalService.getDefaultCommerceWishList(groupId, userId, null);
        if (commerceWishList != null) {
            _commerceWishListModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceWishList, "VIEW");
        }
        return commerceWishList;
    }

    public CommerceWishList updateCommerceWishList(long commerceWishListId, String name, boolean defaultWishList) throws PortalException {
        _commerceWishListModelResourcePermission.check(this.getPermissionChecker(), commerceWishListId, "UPDATE");
        return this.commerceWishListLocalService.updateCommerceWishList(commerceWishListId, name, defaultWishList);
    }

    protected void checkManagePermission(long groupId) throws PortalException {
        PortletResourcePermission portletResourcePermission = _commerceWishListModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_WISH_LISTS");
    }
}

