/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.wish.list.service.impl;

import com.liferay.commerce.product.util.DDMFormValuesHelper;
import com.liferay.commerce.wish.list.exception.CommerceWishListNameException;
import com.liferay.commerce.wish.list.exception.GuestWishListMaxAllowedException;
import com.liferay.commerce.wish.list.internal.configuration.CommerceWishListConfiguration;
import com.liferay.commerce.wish.list.model.CommerceWishList;
import com.liferay.commerce.wish.list.model.CommerceWishListItem;
import com.liferay.commerce.wish.list.service.base.CommerceWishListLocalServiceBaseImpl;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCachable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class CommerceWishListLocalServiceImpl
extends CommerceWishListLocalServiceBaseImpl {
    @ServiceReference(type=CommerceWishListConfiguration.class)
    private CommerceWishListConfiguration _commerceWishListConfiguration;
    @ServiceReference(type=DDMFormValuesHelper.class)
    private DDMFormValuesHelper _ddmFormValuesHelper;

    public CommerceWishList addCommerceWishList(String name, boolean defaultWishList, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long groupId = serviceContext.getScopeGroupId();
        if (user.isDefaultUser()) {
            this.validateGuestWishLists();
        }
        this.validate(0L, groupId, user.getUserId(), name, defaultWishList);
        long commerceWishListId = this.counterLocalService.increment();
        CommerceWishList commerceWishList = this.commerceWishListPersistence.create(commerceWishListId);
        commerceWishList.setGroupId(groupId);
        commerceWishList.setCompanyId(user.getCompanyId());
        commerceWishList.setUserId(user.getUserId());
        commerceWishList.setUserName(user.getFullName());
        commerceWishList.setName(name);
        commerceWishList.setDefaultWishList(defaultWishList);
        return (CommerceWishList)this.commerceWishListPersistence.update((BaseModel)commerceWishList);
    }

    @Override
    @SystemEvent(type=1)
    public CommerceWishList deleteCommerceWishList(CommerceWishList commerceWishList) {
        this.commerceWishListPersistence.remove((BaseModel)commerceWishList);
        this.commerceWishListItemLocalService.deleteCommerceWishListItems(commerceWishList.getCommerceWishListId());
        return commerceWishList;
    }

    @Override
    public CommerceWishList deleteCommerceWishList(long commerceWishListId) throws PortalException {
        CommerceWishList commerceWishList = this.commerceWishListPersistence.findByPrimaryKey(commerceWishListId);
        return this.commerceWishListLocalService.deleteCommerceWishList(commerceWishList);
    }

    public void deleteCommerceWishLists(long userId, Date date) {
        this.commerceWishListPersistence.removeByU_LtC(userId, date);
    }

    public void deleteCommerceWishListsByGroupId(long groupId) {
        List commerceWishLists = this.commerceWishListPersistence.findByGroupId(groupId);
        for (CommerceWishList commerceWishList : commerceWishLists) {
            this.commerceWishListLocalService.deleteCommerceWishList(commerceWishList);
        }
    }

    public void deleteCommerceWishListsByUserId(long userId) {
        List commerceWishLists = this.commerceWishListPersistence.findByUserId(userId);
        for (CommerceWishList commerceWishList : commerceWishLists) {
            this.commerceWishListLocalService.deleteCommerceWishList(commerceWishList);
        }
    }

    public CommerceWishList fetchCommerceWishList(long groupId, long userId, boolean defaultWishList, OrderByComparator<CommerceWishList> orderByComparator) {
        return this.commerceWishListPersistence.fetchByG_U_D_First(groupId, userId, defaultWishList, orderByComparator);
    }

    public List<CommerceWishList> getCommerceWishLists(long groupId, int start, int end, OrderByComparator<CommerceWishList> orderByComparator) {
        return this.commerceWishListPersistence.findByGroupId(groupId, start, end, orderByComparator);
    }

    public List<CommerceWishList> getCommerceWishLists(long groupId, long userId, int start, int end, OrderByComparator<CommerceWishList> orderByComparator) {
        return this.commerceWishListPersistence.findByG_U(groupId, userId, start, end, orderByComparator);
    }

    public int getCommerceWishListsCount(long groupId) {
        return this.commerceWishListPersistence.countByGroupId(groupId);
    }

    public int getCommerceWishListsCount(long groupId, long userId) {
        return this.commerceWishListPersistence.countByG_U(groupId, userId);
    }

    @ThreadLocalCachable
    public CommerceWishList getDefaultCommerceWishList(long groupId, long userId, String guestUuid) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        CommerceWishList guestCommerceWishList = null;
        if (Validator.isNotNull((String)guestUuid) && (guestCommerceWishList = this.commerceWishListLocalService.fetchCommerceWishListByUuidAndGroupId(guestUuid, groupId)) != null && !guestCommerceWishList.isGuestWishList()) {
            guestCommerceWishList = null;
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(groupId);
        serviceContext.setUserId(user.getUserId());
        if (user.isDefaultUser()) {
            return guestCommerceWishList;
        }
        CommerceWishList commerceWishList = this.commerceWishListPersistence.fetchByG_U_D_First(groupId, userId, true, null);
        if (commerceWishList == null && (commerceWishList = this.commerceWishListPersistence.fetchByG_U_D_First(groupId, userId, false, null)) != null) {
            commerceWishList.setDefaultWishList(true);
            commerceWishList = (CommerceWishList)this.commerceWishListPersistence.update((BaseModel)commerceWishList);
        }
        if (guestCommerceWishList != null) {
            this.mergeCommerceWishList(guestCommerceWishList.getCommerceWishListId(), commerceWishList.getCommerceWishListId(), serviceContext);
        }
        return commerceWishList;
    }

    public CommerceWishList updateCommerceWishList(long commerceWishListId, String name, boolean defaultWishList) throws PortalException {
        CommerceWishList commerceWishList = this.commerceWishListPersistence.findByPrimaryKey(commerceWishListId);
        this.validate(commerceWishList.getCommerceWishListId(), commerceWishList.getGroupId(), commerceWishList.getUserId(), name, defaultWishList);
        commerceWishList.setName(name);
        commerceWishList.setDefaultWishList(defaultWishList);
        return (CommerceWishList)this.commerceWishListPersistence.update((BaseModel)commerceWishList);
    }

    protected String getCookieName(long groupId) {
        return CommerceWishList.class.getName() + "#" + groupId;
    }

    protected void mergeCommerceWishList(long fromCommerceWishListId, long toCommerceWishListId, ServiceContext serviceContext) throws PortalException {
        List fromCommerceWishListItems = this.commerceWishListItemLocalService.getCommerceWishListItems(fromCommerceWishListId, -1, -1, null);
        List toCommerceWishListItems = this.commerceWishListItemLocalService.getCommerceWishListItems(toCommerceWishListId, -1, -1, null);
        for (CommerceWishListItem fromCommerceWishListItem : fromCommerceWishListItems) {
            String json = fromCommerceWishListItem.getJson();
            boolean found = false;
            for (CommerceWishListItem toCommerceWishListItem : toCommerceWishListItems) {
                if (fromCommerceWishListItem.getCProductId() != toCommerceWishListItem.getCProductId() || !Objects.equals(fromCommerceWishListItem.getCPInstanceUuid(), toCommerceWishListItem.getCPInstanceUuid()) || !Objects.equals(json, toCommerceWishListItem.getJson())) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.commerceWishListItemLocalService.addCommerceWishListItem(toCommerceWishListId, fromCommerceWishListItem.getCProductId(), fromCommerceWishListItem.getCPInstanceUuid(), json, serviceContext);
        }
        this.commerceWishListLocalService.deleteCommerceWishList(fromCommerceWishListId);
    }

    protected void validate(long commerceWishListId, long groupId, long userId, String name, boolean defaultWishList) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new CommerceWishListNameException();
        }
        if (defaultWishList) {
            List commerceWishLists = this.commerceWishListPersistence.findByG_U_D(groupId, userId, true);
            for (CommerceWishList commerceWishList : commerceWishLists) {
                if (commerceWishList.getCommerceWishListId() == commerceWishListId) continue;
                commerceWishList.setDefaultWishList(false);
                this.commerceWishListPersistence.update((BaseModel)commerceWishList);
            }
        }
    }

    protected void validateGuestWishLists() throws PortalException {
        int count = this.commerceWishListPersistence.countByUserId(0L);
        if (count >= this._commerceWishListConfiguration.guestWishListMaxAllowed()) {
            throw new GuestWishListMaxAllowedException();
        }
    }
}

