/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.wish.list.internal.scheduler;

import com.liferay.commerce.wish.list.internal.configuration.CommerceWishListConfiguration;
import com.liferay.commerce.wish.list.service.CommerceWishListLocalService;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.scheduler.SchedulerJobConfiguration;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerConfiguration;
import java.util.Date;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.commerce.wish.list.internal.configuration.CommerceWishListConfiguration"}, service={SchedulerJobConfiguration.class})
public class CheckGuestCommerceWishListsSchedulerJobConfiguration
implements SchedulerJobConfiguration {
    private volatile CommerceWishListConfiguration _commerceWishListConfiguration;
    @Reference
    private CommerceWishListLocalService _commerceWishListLocalService;

    public UnsafeRunnable<Exception> getJobExecutorUnsafeRunnable() {
        return () -> {
            int deleteInterval = this._commerceWishListConfiguration.deleteInterval();
            Date createDate = new Date(System.currentTimeMillis() - (long)deleteInterval * 60000L);
            this._commerceWishListLocalService.deleteCommerceWishLists(0L, createDate);
        };
    }

    public TriggerConfiguration getTriggerConfiguration() {
        return TriggerConfiguration.createTriggerConfiguration((int)this._commerceWishListConfiguration.checkInterval(), (TimeUnit)TimeUnit.MINUTE);
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._commerceWishListConfiguration = (CommerceWishListConfiguration)ConfigurableUtil.createConfigurable(CommerceWishListConfiguration.class, properties);
    }
}

