/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.wish.list.internal.upgrade.v1_1_0;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class CommerceWishListItemUpgradeProcess
extends UpgradeProcess {
    private final CPDefinitionLocalService _cpDefinitionLocalService;
    private final CPInstanceLocalService _cpInstanceLocalService;

    public CommerceWishListItemUpgradeProcess(CPDefinitionLocalService cpDefinitionLocalService, CPInstanceLocalService cpInstanceLocalService) {
        this._cpDefinitionLocalService = cpDefinitionLocalService;
        this._cpInstanceLocalService = cpInstanceLocalService;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update CommerceWishListItem set CProductId = ?,CPInstanceUuid = ? where CPInstanceId = ?");
             Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery("select distinct CPInstanceId from CommerceWishListItem");){
            while (resultSet.next()) {
                long cpInstanceId = resultSet.getLong("CPInstanceId");
                CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpInstanceId);
                CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpInstance.getCPDefinitionId());
                preparedStatement.setLong(1, cpDefinition.getCProductId());
                preparedStatement.setString(2, cpInstance.getCPInstanceUuid());
                preparedStatement.setLong(3, cpInstanceId);
                preparedStatement.execute();
            }
        }
    }

    protected UpgradeStep[] getPostUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.dropColumns((String)"CommerceWishListItem", (String[])new String[]{"CPDefinitionId", "CPInstanceId"})};
    }

    protected UpgradeStep[] getPreUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.addColumns((String)"CommerceWishListItem", (String[])new String[]{"CPInstanceUuid VARCHAR(75)", "CProductId LONG"})};
    }
}

