/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.wish.list.internal.util;

import com.liferay.commerce.wish.list.model.CommerceWishList;
import com.liferay.commerce.wish.list.service.CommerceWishListItemService;
import com.liferay.commerce.wish.list.service.CommerceWishListLocalService;
import com.liferay.commerce.wish.list.util.CommerceWishListHttpHelper;
import com.liferay.portal.kernel.cookies.CookiesManagerUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactory;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.PortletURL;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceWishListHttpHelper.class})
public class CommerceWishListHttpHelperImpl
implements CommerceWishListHttpHelper {
    @Reference
    private CommerceWishListItemService _commerceWishListItemService;
    @Reference
    private CommerceWishListLocalService _commerceWishListLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletURLFactory _portletURLFactory;
    @Reference
    private UserLocalService _userLocalService;

    public PortletURL getCommerceWishListPortletURL(HttpServletRequest httpServletRequest) throws PortalException {
        String portletId;
        LiferayPortletURL portletURL = null;
        long groupId = this._portal.getScopeGroupId(httpServletRequest);
        long plid = this._portal.getPlidFromPortletId(groupId, portletId = "com_liferay_commerce_wish_list_web_internal_portlet_CommerceWishListContentPortlet");
        portletURL = plid > 0L ? this._portletURLFactory.create(httpServletRequest, portletId, plid, "RENDER_PHASE") : this._portletURLFactory.create(httpServletRequest, portletId, "RENDER_PHASE");
        return portletURL;
    }

    public CommerceWishList getCurrentCommerceWishList(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        long groupId = this._portal.getScopeGroupId(httpServletRequest);
        User user = this._portal.getUser(httpServletRequest);
        if (user == null) {
            user = this._userLocalService.getGuestUser(this._portal.getCompanyId(httpServletRequest));
        }
        String cookieName = this._getCookieName(groupId);
        String guestUuid = CookiesManagerUtil.getCookieValue((String)cookieName, (HttpServletRequest)httpServletRequest);
        CommerceWishList commerceWishList = this._commerceWishListLocalService.getDefaultCommerceWishList(groupId, user.getUserId(), guestUuid);
        if (commerceWishList == null) {
            return commerceWishList;
        }
        if (user.isGuestUser()) {
            if (Validator.isNull((String)guestUuid)) {
                Cookie cookie = new Cookie(cookieName, commerceWishList.getUuid());
                cookie.setMaxAge(31536000);
                cookie.setPath("/");
                CookiesManagerUtil.addCookie((int)2, (Cookie)cookie, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
            }
        } else if (Validator.isNotNull((String)guestUuid)) {
            CookiesManagerUtil.deleteCookies((String)CookiesManagerUtil.getDomain((HttpServletRequest)httpServletRequest), (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String[])new String[]{cookieName});
        }
        return commerceWishList;
    }

    public int getCurrentCommerceWishListItemsCount(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        CommerceWishList commerceWishList = this.getCurrentCommerceWishList(httpServletRequest, httpServletResponse);
        if (commerceWishList == null) {
            return 0;
        }
        return this._commerceWishListItemService.getCommerceWishListItemsCount(commerceWishList.getCommerceWishListId());
    }

    private String _getCookieName(long groupId) {
        return CommerceWishList.class.getName() + "#" + groupId;
    }
}

