/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.wish.list.service.impl;

import com.liferay.commerce.product.exception.NoSuchCPInstanceException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CProductLocalService;
import com.liferay.commerce.wish.list.exception.GuestWishListItemMaxAllowedException;
import com.liferay.commerce.wish.list.internal.configuration.CommerceWishListConfiguration;
import com.liferay.commerce.wish.list.model.CommerceWishList;
import com.liferay.commerce.wish.list.model.CommerceWishListItem;
import com.liferay.commerce.wish.list.service.base.CommerceWishListItemLocalServiceBaseImpl;
import com.liferay.commerce.wish.list.service.persistence.CommerceWishListPersistence;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.commerce.wish.list.internal.configuration.CommerceWishListConfiguration"}, property={"model.class.name=com.liferay.commerce.wish.list.model.CommerceWishListItem"}, service={AopService.class})
public class CommerceWishListItemLocalServiceImpl
extends CommerceWishListItemLocalServiceBaseImpl {
    private CommerceWishListConfiguration _commerceWishListConfiguration;
    @Reference
    private CommerceWishListPersistence _commerceWishListPersistence;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private CProductLocalService _cProductLocalService;
    @Reference
    private UserLocalService _userLocalService;

    @Deprecated
    public CommerceWishListItem addCommerceWishListItem(long commerceWishListId, long cpDefinitionId, long cpInstanceId, String json, ServiceContext serviceContext) throws PortalException {
        CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinition(cpDefinitionId);
        String cpInstanceUuid = null;
        if (cpInstanceId > 0L) {
            CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpInstanceId);
            cpInstanceUuid = cpInstance.getCPInstanceUuid();
        }
        return this.commerceWishListItemLocalService.addCommerceWishListItem(commerceWishListId, cpDefinition.getCProductId(), cpInstanceUuid, json, serviceContext);
    }

    public CommerceWishListItem addCommerceWishListItem(long commerceWishListId, long cProductId, String cpInstanceUuid, String json, ServiceContext serviceContext) throws PortalException {
        CommerceWishList commerceWishList = this._commerceWishListPersistence.findByPrimaryKey(commerceWishListId);
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        this._validate(commerceWishList, cProductId, cpInstanceUuid);
        long commerceWishListItemId = this.counterLocalService.increment();
        CommerceWishListItem commerceWishListItem = this.commerceWishListItemPersistence.create(commerceWishListItemId);
        commerceWishListItem.setGroupId(commerceWishList.getGroupId());
        commerceWishListItem.setCompanyId(user.getCompanyId());
        commerceWishListItem.setUserId(user.getUserId());
        commerceWishListItem.setUserName(user.getFullName());
        commerceWishListItem.setCommerceWishListId(commerceWishList.getCommerceWishListId());
        commerceWishListItem.setCPInstanceUuid(cpInstanceUuid);
        commerceWishListItem.setCProductId(cProductId);
        commerceWishListItem.setJson(json);
        return (CommerceWishListItem)this.commerceWishListItemPersistence.update((BaseModel)commerceWishListItem);
    }

    public void deleteCommerceWishListItems(long commerceWishListId) {
        this.commerceWishListItemPersistence.removeByCommerceWishListId(commerceWishListId);
    }

    @Deprecated
    public void deleteCommerceWishListItemsByCPDefinitionId(long cpDefinitionId) {
        CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinition(cpDefinitionId);
        if (cpDefinition != null) {
            this.commerceWishListItemPersistence.removeByCProductId(cpDefinition.getCProductId());
        }
    }

    @Deprecated
    public void deleteCommerceWishListItemsByCPInstanceId(long cpInstanceId) {
        CPInstance cpInstance = this._cpInstanceLocalService.fetchCPInstance(cpInstanceId);
        if (cpInstance != null) {
            this.commerceWishListItemPersistence.removeByCPInstanceUuid(cpInstance.getCPInstanceUuid());
        }
    }

    public CommerceWishListItem getCommerceWishListItem(long commerceWishListId, String cpInstanceUuid, long cProductId) throws PortalException {
        return this.commerceWishListItemPersistence.findByCW_CPI_CP(commerceWishListId, cpInstanceUuid, cProductId);
    }

    public int getCommerceWishListItemByContainsCPInstanceCount(long commerceWishListId, String cpInstanceUuid) {
        return this.commerceWishListItemPersistence.countByCW_CPI(commerceWishListId, cpInstanceUuid);
    }

    public int getCommerceWishListItemByContainsCProductCount(long commerceWishListId, long cProductId) {
        return this.commerceWishListItemPersistence.countByCW_CP(commerceWishListId, cProductId);
    }

    public List<CommerceWishListItem> getCommerceWishListItems(long commerceWishListId, int start, int end, OrderByComparator<CommerceWishListItem> orderByComparator) {
        return this.commerceWishListItemPersistence.findByCommerceWishListId(commerceWishListId, start, end, orderByComparator);
    }

    public int getCommerceWishListItemsCount(long commerceWishListId) {
        return this.commerceWishListItemPersistence.countByCommerceWishListId(commerceWishListId);
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._commerceWishListConfiguration = (CommerceWishListConfiguration)ConfigurableUtil.createConfigurable(CommerceWishListConfiguration.class, properties);
    }

    private void _validate(CommerceWishList commerceWishList, long cProductId, String cpInstanceUuid) throws PortalException {
        CPInstance cpInstance;
        int count;
        if (commerceWishList.getUserId() == 0L && (count = this.commerceWishListItemPersistence.countByCommerceWishListId(commerceWishList.getCommerceWishListId())) >= this._commerceWishListConfiguration.guestWishListItemMaxAllowed()) {
            throw new GuestWishListItemMaxAllowedException();
        }
        if (Validator.isNotNull((String)cpInstanceUuid) && (cpInstance = this._cpInstanceLocalService.getCProductInstance(cProductId, cpInstanceUuid)) == null) {
            CProduct cProduct = this._cProductLocalService.getCProduct(cProductId);
            throw new NoSuchCPInstanceException(StringBundler.concat((Object[])new Object[]{"CPInstance ", cpInstanceUuid, " belongs to a different CPDefinition than ", cProduct.getPublishedCPDefinitionId()}));
        }
    }
}

