/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.wish.list.service.impl;

import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.permission.CommerceProductViewPermission;
import com.liferay.commerce.product.service.CProductLocalService;
import com.liferay.commerce.wish.list.model.CommerceWishList;
import com.liferay.commerce.wish.list.model.CommerceWishListItem;
import com.liferay.commerce.wish.list.service.base.CommerceWishListItemServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=commerce", "json.web.service.context.path=CommerceWishListItem"}, service={AopService.class})
public class CommerceWishListItemServiceImpl
extends CommerceWishListItemServiceBaseImpl {
    @Reference
    protected CommerceProductViewPermission commerceProductViewPermission;
    @Reference
    protected CProductLocalService cProductLocalService;
    @Reference(target="(model.class.name=com.liferay.commerce.wish.list.model.CommerceWishList)")
    private ModelResourcePermission<CommerceWishList> _commerceWishListModelResourcePermission;

    public CommerceWishListItem addCommerceWishListItem(long commerceAccountId, long commerceWishListId, long cProductId, String cpInstanceUuid, String json, ServiceContext serviceContext) throws PortalException {
        this._commerceWishListModelResourcePermission.check(this.getPermissionChecker(), commerceWishListId, "UPDATE");
        CProduct cProduct = this.cProductLocalService.getCProduct(cProductId);
        this.commerceProductViewPermission.check(this.getPermissionChecker(), commerceAccountId, cProduct.getPublishedCPDefinitionId());
        return this.commerceWishListItemLocalService.addCommerceWishListItem(commerceWishListId, cProductId, cpInstanceUuid, json, serviceContext);
    }

    public void deleteCommerceWishListItem(long commerceWishListItemId) throws PortalException {
        CommerceWishListItem commerceWishListItem = this.commerceWishListItemLocalService.getCommerceWishListItem(commerceWishListItemId);
        this._commerceWishListModelResourcePermission.check(this.getPermissionChecker(), commerceWishListItem.getCommerceWishListId(), "UPDATE");
        this.commerceWishListItemLocalService.deleteCommerceWishListItem(commerceWishListItem);
    }

    public CommerceWishListItem getCommerceWishListItem(long commerceWishListItemId) throws PortalException {
        CommerceWishListItem commerceWishListItem = this.commerceWishListItemLocalService.getCommerceWishListItem(commerceWishListItemId);
        this._commerceWishListModelResourcePermission.check(this.getPermissionChecker(), commerceWishListItem.getCommerceWishListId(), "VIEW");
        return commerceWishListItem;
    }

    public CommerceWishListItem getCommerceWishListItem(long commerceWishListId, String cpInstanceUuid, long cProductId) throws PortalException {
        this._commerceWishListModelResourcePermission.check(this.getPermissionChecker(), commerceWishListId, "VIEW");
        return this.commerceWishListItemLocalService.getCommerceWishListItem(commerceWishListId, cpInstanceUuid, cProductId);
    }

    public int getCommerceWishListItemByContainsCPInstanceCount(long commerceWishListId, String cpInstanceUuid) throws PortalException {
        this._commerceWishListModelResourcePermission.check(this.getPermissionChecker(), commerceWishListId, "VIEW");
        return this.commerceWishListItemPersistence.countByCW_CPI(commerceWishListId, cpInstanceUuid);
    }

    public int getCommerceWishListItemByContainsCProductCount(long commerceWishListId, long cProductId) throws PortalException {
        this._commerceWishListModelResourcePermission.check(this.getPermissionChecker(), commerceWishListId, "VIEW");
        return this.commerceWishListItemPersistence.countByCW_CP(commerceWishListId, cProductId);
    }

    public List<CommerceWishListItem> getCommerceWishListItems(long commerceWishListId, int start, int end, OrderByComparator<CommerceWishListItem> orderByComparator) throws PortalException {
        this._commerceWishListModelResourcePermission.check(this.getPermissionChecker(), commerceWishListId, "VIEW");
        return this.commerceWishListItemLocalService.getCommerceWishListItems(commerceWishListId, start, end, orderByComparator);
    }

    public int getCommerceWishListItemsCount(long commerceWishListId) throws PortalException {
        this._commerceWishListModelResourcePermission.check(this.getPermissionChecker(), commerceWishListId, "VIEW");
        return this.commerceWishListItemLocalService.getCommerceWishListItemsCount(commerceWishListId);
    }
}

