/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.wish.list.internal.security.permission.resource;

import com.liferay.commerce.wish.list.model.CommerceWishList;
import com.liferay.commerce.wish.list.model.CommerceWishListModel;
import com.liferay.commerce.wish.list.service.CommerceWishListLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CommerceWishListModelResourcePermissionRegistrar.class})
public class CommerceWishListModelResourcePermissionRegistrar {
    @Reference
    private CommerceWishListLocalService _commerceWishListLocalService;
    @Reference(target="(resource.name=com.liferay.commerce.wish.list)")
    private PortletResourcePermission _portletResourcePermission;
    private ServiceRegistration<ModelResourcePermission<CommerceWishList>> _serviceRegistration;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceRegistration = bundleContext.registerService(ModelResourcePermission.class, (Object)ModelResourcePermissionFactory.create(CommerceWishList.class, CommerceWishListModel::getCommerceWishListId, arg_0 -> ((CommerceWishListLocalService)this._commerceWishListLocalService).getCommerceWishList(arg_0), (PortletResourcePermission)this._portletResourcePermission, (modelResourcePermission, consumer) -> consumer.accept(new CommerceWishListModelResourcePermissionLogic())), (Dictionary)HashMapDictionaryBuilder.put((Object)"model.class.name", (Object)CommerceWishList.class.getName()).build());
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }

    private class CommerceWishListModelResourcePermissionLogic
    implements ModelResourcePermissionLogic<CommerceWishList> {
        private CommerceWishListModelResourcePermissionLogic() {
        }

        public Boolean contains(PermissionChecker permissionChecker, String name, CommerceWishList commerceWishList, String actionId) throws PortalException {
            if (actionId.equals("DELETE") && !permissionChecker.isSignedIn()) {
                return false;
            }
            if (commerceWishList.getUserId() == permissionChecker.getUserId()) {
                return true;
            }
            return CommerceWishListModelResourcePermissionRegistrar.this._portletResourcePermission.contains(permissionChecker, commerceWishList.getGroupId(), "MANAGE_COMMERCE_WISH_LISTS");
        }
    }
}

