/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.wish.list.internal.upgrade.v1_1_0;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.wish.list.model.impl.CommerceWishListItemModelImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class CommerceWishListItemUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(CommerceWishListItemUpgradeProcess.class);
    private final CPDefinitionLocalService _cpDefinitionLocalService;
    private final CPInstanceLocalService _cpInstanceLocalService;

    public CommerceWishListItemUpgradeProcess(CPDefinitionLocalService cpDefinitionLocalService, CPInstanceLocalService cpInstanceLocalService) {
        this._cpDefinitionLocalService = cpDefinitionLocalService;
        this._cpInstanceLocalService = cpInstanceLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._addColumn(CommerceWishListItemModelImpl.class, "CommerceWishListItem", "CPInstanceUuid", "VARCHAR(75)");
        this._addColumn(CommerceWishListItemModelImpl.class, "CommerceWishListItem", "CProductId", "LONG");
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update CommerceWishListItem set CProductId = ?,CPInstanceUuid = ? where CPInstanceId = ?");
             Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery("select distinct CPInstanceId from CommerceWishListItem");){
            while (resultSet.next()) {
                long cpInstanceId = resultSet.getLong("CPInstanceId");
                CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpInstanceId);
                CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpInstance.getCPDefinitionId());
                preparedStatement.setLong(1, cpDefinition.getCProductId());
                preparedStatement.setString(2, cpInstance.getCPInstanceUuid());
                preparedStatement.setLong(3, cpInstanceId);
                preparedStatement.execute();
            }
        }
        this._dropColumn("CommerceWishListItem", "CPDefinitionId");
        this._dropColumn("CommerceWishListItem", "CPInstanceId");
    }

    private void _addColumn(Class<?> entityClass, String tableName, String columnName, String columnType) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Adding column %s to table %s", columnName, tableName));
        }
        if (!this.hasColumn(tableName, columnName)) {
            this.alter(entityClass, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, columnName + " " + columnType)});
        } else if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Column %s already exists on table %s", columnName, tableName));
        }
    }

    private void _dropColumn(String tableName, String columnName) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Dropping column %s from table %s", columnName, tableName));
        }
        if (this.hasColumn(tableName, columnName)) {
            this.runSQL(StringBundler.concat((String[])new String[]{"alter table ", tableName, " drop column ", columnName}));
        } else if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Column %s already does not exist on table %s", columnName, tableName));
        }
    }
}

